

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DashBoardSchedulePattern.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--   	  This stored procedure is for returning the missing schedule dates
--		  input will be a datetime and the output will contains missing schedule dates till the current date
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DashBoardSchedulePattern.sp,v $ $Id: DashBoardSchedulePattern.sp,v 1.1.78.1 2018/03/20 00:30:55 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "DashBoardSchedulePattern"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DashBoardSchedulePattern <<<'

IF EXISTS (select * from sysobjects where name='DashBoardSchedulePattern')
	drop procedure DashBoardSchedulePattern
IF EXISTS (select * from GxQscripts where name='DashBoardSchedulePattern')
	delete from GxQscripts where name = 'DashBoardSchedulePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardSchedulePattern')
	delete from GXDBVersions where aliasname = 'DashBoardSchedulePattern'
GO
print '... Creating Procedure: DashBoardSchedulePattern'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DashBoardSchedulePattern
  @starttime INTEGER
AS
  DECLARE @o_time DATETIME
  DECLARE @o_subtaskid INTEGER
if OBJECT_ID('#tempJmBkpStats') is not null
begin
	drop table #tempJmBkpStats
end
create table #tempJmBkpStats (subtaskid int , modifiedtime date)
declare @start datetime
declare @minsubtaskid int
declare @maxsubtaskid int
declare @temp int
declare @minmodifieddate date
declare @maxmodifieddate date
declare @i date
set @start = dbo.getdatetime(@starttime)
set @minsubtaskid = (select MIN(subtaskid) from JMBkpStats where initFrom = 3)
set @maxsubtaskid = (select MAX(subtaskid) from JMBkpStats where initFrom = 3)
set @temp = 0
while ( (@minsubtaskid>@temp) and (@minsubtaskid<=@maxsubtaskid))
begin
	set @minmodifieddate = (select MIN(convert(date , dbo.UTCToCellLocalTime(dbo.getdatetime(modifiedTime), 2))) from JMBkpStats where subTaskId=@minsubtaskid)
	set @maxmodifieddate = (select MAX(convert(date , dbo.UTCToCellLocalTime(dbo.getdatetime(modifiedTime), 2))) from JMBkpStats where subTaskId=@minsubtaskid)
	set @i = @minmodifieddate
		while ( @i <= @maxmodifieddate)
		begin
			insert into #tempJmBkpStats
				select @minsubtaskid ,@i
			set @i = DATEADD(DAY , 1 , @i)
		end
	set @temp = @minsubtaskid
	if (@temp = @maxsubtaskid)
	begin
		break
	end
	set @minsubtaskid = (select MIN(subtaskid) from JMBkpStats where subTaskId <> @temp and initFrom = 3)
end
select t.modifiedtime as ScheduleFailedDate, t.subtaskid
from #tempJmBkpStats t left outer join JMBkpStats j
	on t.modifiedtime = convert(date , dbo.UTCToCellLocalTime(dbo.getdatetime(j.modifiedTime), 2)) and t.subtaskid = j.subTaskId
where t.modifiedtime>=@start and j.subtaskid is null and j.modifiedTime is null
order by t.modifiedtime
GO

IF EXISTS (select * from GxQscripts where name = 'DashBoardSchedulePattern')
	delete from GxQscripts where name = 'DashBoardSchedulePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardSchedulePattern')
	delete from GXDBVersions where aliasname = 'DashBoardSchedulePattern'
GO

insert into GXDBVersions values(2, 'DashBoardSchedulePattern',  '00010001007800010000', 'DashBoardSchedulePattern', '00010001007800010000')
GO

