

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DashBoardResourceUtilizationMeter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--        This stored procedure is used for selecting the streams information for every hour.
--		  the  input will the datetime and from that input till the current date the output is returned.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DashBoardResourceUtilizationMeter.sp,v $ $Id: DashBoardResourceUtilizationMeter.sp,v 1.1.78.1 2018/03/20 00:30:09 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DashBoardResourceUtilizationMeter <<<'

IF EXISTS (select * from sysobjects where name='DashBoardResourceUtilizationMeter')
	drop procedure DashBoardResourceUtilizationMeter
IF EXISTS (select * from GxQscripts where name='DashBoardResourceUtilizationMeter')
	delete from GxQscripts where name = 'DashBoardResourceUtilizationMeter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardResourceUtilizationMeter')
	delete from GXDBVersions where aliasname = 'DashBoardResourceUtilizationMeter'
GO
print '... Creating Procedure: DashBoardResourceUtilizationMeter'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DashBoardResourceUtilizationMeter
  @starttime INTEGER
AS
  DECLARE @o_availablestreams INTEGER
  DECLARE @o_usedstreams INTEGER
  DECLARE @o_freestreams INTEGER
  DECLARE @o_plottime INTEGER
if OBJECT_ID('#tempResourceTbl') is not null
begin
	drop table #tempResourceTbl
end
create table #tempResourceTbl(MediaStreamAvailable int ,MediaStreamUsed int ,MediaStreamFree int ,plottime datetime)
declare @end datetime =current_timestamp
declare @start datetime = dbo.getdatetime(@starttime)
declare @available int , @used int
while @start <= @end
begin
	insert into #tempResourceTbl
	select top(1) t1.attributevalue as availablestreams, t2.attributevalue as usedstreams ,  (t1.attributevalue -  t2.attributevalue) as freestreams , t1.plottime as plottime
	from DashBoardMediaStreamUsage t1 , DashBoardMediaStreamUsage t2
	where t1.id=t2.id and t1.attributename='availablestreams' and t2.attributename='usedstreams' and t1.plottime >= @start
	set @start =DATEADD (HOUR , 1 ,@start)
end
SELECT	@available=(SUM(AG.maxStreams - (ISNULL(res1.streamCount, 0) + ISNULL(res2.streamCount, 0)))) ,
		@used=(SUM( ISNULL(res1.streamCount, 0) + ISNULL(res2.streamCount, 0)))
FROM	archGroupCopy AGC
		inner join archGroup AG ON AGC.archGroupId = AG.id
		left join
		(
			SELECT CopyId, COUNT(DISTINCT StreamId) streamCount FROM MMResource WITH (NOLOCK)
			WHERE	CopyId > 0 AND StreamId > 0
			AND		HasJobInterrupted = 0 AND IntrJobId_l = 0
			AND		LogicalRelease = 0
			GROUP BY CopyId
		) res1 on AGC.Id = res1.copyId
		left join
		(
			SELECT CopyId, COUNT(DISTINCT StreamId) streamCount FROM MMResource WITH (NOLOCK)
			WHERE	CopyId > 0 AND StreamId > 0
			AND		HasJobInterrupted = 0 AND IntrJobId_l = 0
			AND		LogicalRelease > 0
			GROUP BY CopyId
		) res2 on AGC.Id = res2.copyId
WHERE	AGC.id > 0 AND AGC.isActive > 0
insert into #tempResourceTbl
select @available ,@used ,@available -@used ,CURRENT_TIMESTAMP
select distinct * from #tempResourceTbl order by plottime
GO

IF EXISTS (select * from GxQscripts where name = 'DashBoardResourceUtilizationMeter')
	delete from GxQscripts where name = 'DashBoardResourceUtilizationMeter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardResourceUtilizationMeter')
	delete from GXDBVersions where aliasname = 'DashBoardResourceUtilizationMeter'
GO

insert into GXDBVersions values(2, 'DashBoardResourceUtilizationMeter',  '00010001007800010000', 'DashBoardResourceUtilizationMeter', '00010001007800010000')
GO

