

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DashBoardJobFlowMeter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--        This stored procedure returns the job flow meter like running,waiting and pending jobs for every hour basis.
--		  input will be a datetime and output is returned till the current date.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DashBoardJobFlowMeter.sp,v $ $Id: DashBoardJobFlowMeter.sp,v 1.2.50.1 2018/03/20 00:34:09 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "DashBoardJobFlowMeter"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DashBoardJobFlowMeter <<<'

IF EXISTS (select * from sysobjects where name='DashBoardJobFlowMeter')
	drop procedure DashBoardJobFlowMeter
IF EXISTS (select * from GxQscripts where name='DashBoardJobFlowMeter')
	delete from GxQscripts where name = 'DashBoardJobFlowMeter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardJobFlowMeter')
	delete from GXDBVersions where aliasname = 'DashBoardJobFlowMeter'
GO
print '... Creating Procedure: DashBoardJobFlowMeter'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DashBoardJobFlowMeter
  @starttime INTEGER
AS
  DECLARE @o_running INTEGER
  DECLARE @o_pending INTEGER
  DECLARE @o_waiting INTEGER
  DECLARE @o_modified DATETIME
if OBJECT_ID('#tempJobTbl') is not null
begin
	drop table #tempJobTbl
end
create table #tempJobTbl(running int ,pending int ,waiting int ,modified datetime)
declare @start datetime
set @start = dbo.GetDateTime(@starttime)
declare @end datetime =current_timestamp
while @start <= @end
begin
	insert into #tempJobTbl
	select top(1) Running , pending , waiting ,modified
	from JMJobStateHistory where Modified >= @start
	set @start = DATEADD (HOUR , 1 ,@start)
end
insert into #tempJobTbl
select  ISNULL(SUM( CASE WHEN (State IN (1, 6, 7, 8, 13, 17, 18)) then 1 ELSE 0 END), 0) AS 'Running',
            ISNULL(SUM( CASE WHEN (State IN (2, 15, 16)) then 1 ELSE 0 END), 0) AS 'Pending',
            ISNULL(SUM( CASE WHEN (State = 3) then 1 ELSE 0 END), 0) AS 'Waiting',
            CURRENT_TIMESTAMP
from JMJobInfo
select distinct * from #tempJobTbl order by modified
GO

IF EXISTS (select * from GxQscripts where name = 'DashBoardJobFlowMeter')
	delete from GxQscripts where name = 'DashBoardJobFlowMeter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardJobFlowMeter')
	delete from GXDBVersions where aliasname = 'DashBoardJobFlowMeter'
GO

insert into GXDBVersions values(2, 'DashBoardJobFlowMeter',  '00010002005000010000', 'DashBoardJobFlowMeter', '00010002005000010000')
GO

