

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DashBoardJobAndResourceUtil.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--        This stored procedure returns both the job flow meter and streams information like running,waiting,pending,streamsavailable and streamsfree
--		   input will be a datetime and a flag.
--		if the flag is one then only the current information is returned.
--		is the flag is not one then all the records from input datetime is selected till the current date.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DashBoardJobAndResourceUtil.sp,v $ $Id: DashBoardJobAndResourceUtil.sp,v 1.3.50.1 2018/03/20 00:41:54 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "DashBoardJobAndResourceUtil"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DashBoardJobAndResourceUtil <<<'

IF EXISTS (select * from sysobjects where name='DashBoardJobAndResourceUtil')
	drop procedure DashBoardJobAndResourceUtil
IF EXISTS (select * from GxQscripts where name='DashBoardJobAndResourceUtil')
	delete from GxQscripts where name = 'DashBoardJobAndResourceUtil'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardJobAndResourceUtil')
	delete from GXDBVersions where aliasname = 'DashBoardJobAndResourceUtil'
GO
print '... Creating Procedure: DashBoardJobAndResourceUtil'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DashBoardJobAndResourceUtil
  @starttime INTEGER,
  @flagGetLatest INTEGER
AS
  DECLARE @o_time DATETIME
  DECLARE @o_jobrunning INTEGER
  DECLARE @o_jobwaiting INTEGER
  DECLARE @o_jobpending INTEGER
  DECLARE @o_mediastreamused INTEGER
  DECLARE @o_mediastreamavailable INTEGER
  DECLARE @o_mediastreamfree INTEGER
if OBJECT_ID('#tempJobAndResourceTbl') is not null
begin
	drop table #tempJobAndResourceTbl
end
create table #tempJobAndResourceTbl (time datetime ,jobrunning int,jobwaiting int , jobpending int ,mediaStreamUsed int,MediaStreamAvailable int ,MediaStreamFree int)
declare @end datetime =current_timestamp
declare @start datetime
set @start = dbo.getdatetime(@starttime)
declare @available int , @used int
SELECT	@available=(SUM(AG.maxStreams - (ISNULL(res1.streamCount, 0) + ISNULL(res2.streamCount, 0)))) ,
		@used=(SUM( ISNULL(res1.streamCount, 0) + ISNULL(res2.streamCount, 0)))
FROM	archGroupCopy AGC
		inner join archGroup AG ON AGC.archGroupId = AG.id
		left join
		(
			SELECT CopyId, COUNT(DISTINCT StreamId) streamCount FROM MMResource WITH (NOLOCK)
			WHERE	CopyId > 0 AND StreamId > 0
			AND		HasJobInterrupted = 0 AND IntrJobId_l = 0
			AND		LogicalRelease = 0
			GROUP BY CopyId
		) res1 on AGC.Id = res1.copyId
		left join
		(
			SELECT CopyId, COUNT(DISTINCT StreamId) streamCount FROM MMResource WITH (NOLOCK)
			WHERE	CopyId > 0 AND StreamId > 0
			AND		HasJobInterrupted = 0 AND IntrJobId_l = 0
			AND		LogicalRelease > 0
			GROUP BY CopyId
		) res2 on AGC.Id = res2.copyId
WHERE	AGC.id > 0 AND AGC.isActive > 0
if @flagGetLatest=1
begin
	select	CURRENT_TIMESTAMP as time,
	ISNULL(SUM( CASE WHEN (State IN (1, 6, 7, 8, 13, 17, 18)) then 1 ELSE 0 END), 0) AS 'jobRunning',
	ISNULL(SUM( CASE WHEN (State = 3) then 1 ELSE 0 END), 0) AS 'jobWaiting',
            ISNULL(SUM( CASE WHEN (State IN (2, 15, 16)) then 1 ELSE 0 END), 0) AS 'jobPending',
            @used as Mediastreamused,
            @available as mediastreamavailable,
            @available-@used as mediastreamfree
	from JMJobInfo
end
else
begin
	while @start <= @end
	begin
	insert into #tempJobAndResourceTbl
	select top(1) t1.plottime as Time ,c.Running as JobRunning,c.waiting as JobWaiting ,c.pending as JobPending, t2.attributevalue as MediaStreamUsed ,t1.attributevalue as MediaStreamAvailabe  ,  (t1.attributevalue -  t2.attributevalue) as MediaStreamFree
	from DashBoardMediaStreamUsage t1 , DashBoardMediaStreamUsage t2 , JMJobStateHistory c
	where t1.id=t2.id and t1.attributename='availablestreams' and t2.attributename='usedstreams' and c.Modified = t1.plottime and c.Modified >=@start
	set @start =DATEADD (HOUR , 1 ,@start)
	end
	insert into #tempJobAndResourceTbl
	select		CURRENT_TIMESTAMP as time,
				ISNULL(SUM( CASE WHEN (State IN (1, 6, 7, 8, 13, 17, 18)) then 1 ELSE 0 END), 0) AS 'jobRunning',
				ISNULL(SUM( CASE WHEN (State = 3) then 1 ELSE 0 END), 0) AS 'jobWaiting',
				ISNULL(SUM( CASE WHEN (State IN (2, 15, 16)) then 1 ELSE 0 END), 0) AS 'jobPending',
				@used as Mediastreamused,
				@available as mediastreamavailable,
				@available-@used as mediastreamfree
	from JMJobInfo
	select distinct * from #tempJobAndResourceTbl
end
GO

IF EXISTS (select * from GxQscripts where name = 'DashBoardJobAndResourceUtil')
	delete from GxQscripts where name = 'DashBoardJobAndResourceUtil'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DashBoardJobAndResourceUtil')
	delete from GXDBVersions where aliasname = 'DashBoardJobAndResourceUtil'
GO

insert into GXDBVersions values(2, 'DashBoardJobAndResourceUtil',  '00010003005000010000', 'DashBoardJobAndResourceUtil', '00010003005000010000')
GO

