

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DaTSRptSetMMErrorCodesForPruningFailures.sp] ---------- 

--  +====================================================================================================+
--  | Cursor Name:  DaTSRptSetMMErrorCodesForPruningFailures()
--  | Description:  Set error code in MMDeletedAF and MMVolume table for any pruning conditions.
--  +====================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DaTSRptSetMMErrorCodesForPruningFailures.sp,v $ $Id: DaTSRptSetMMErrorCodesForPruningFailures.sp,v 1.2.186.2 2018/03/22 03:10:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DaTSRptSetMMErrorCodesForPruningFailures <<<'

IF EXISTS (select * from sysobjects where name='DaTSRptSetMMErrorCodesForPruningFailures')
	drop procedure DaTSRptSetMMErrorCodesForPruningFailures
IF EXISTS (select * from GxQscripts where name='DaTSRptSetMMErrorCodesForPruningFailures')
	delete from GxQscripts where name = 'DaTSRptSetMMErrorCodesForPruningFailures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptSetMMErrorCodesForPruningFailures')
	delete from GXDBVersions where aliasname = 'DaTSRptSetMMErrorCodesForPruningFailures'
GO
print '... Creating Procedure: DaTSRptSetMMErrorCodesForPruningFailures'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DaTSRptSetMMErrorCodesForPruningFailures
  @i_JobId integer,
  @i_Dummy integer
AS
-- Cursor Output
  DECLARE @o_errorCode INTEGER
	SET NOCOUNT ON
	DECLARE @xmlText 			XML
	DECLARE @handle 			INTEGER
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE	@skipSettingMMErrorCodes	INTEGER
	SET			@skipSettingMMErrorCodes	= 0
	DECLARE @MountPathListCursorFlag 		INTEGER
	SET 		@MountPathListCursorFlag		= 0
	DECLARE @curMountPathId							INTEGER
	SET 		@curMountPathId							= 0
	SELECT @skipSettingMMErrorCodes = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_SKIP_SETTING_MM_ERRORCODES_FOR_PRUNING'
	SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_JobId))
	EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
	DECLARE @AllSPSelected		INT
	SET @AllSPSelected = (SELECT DISTINCT ISNULL(allCopies, 0) FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/storagePolicyCopyList', 1) WITH (allCopies int))
	IF object_id('tempdb.dbo.#tmpMountPathList') is not null
		DROP TABLE #tmpMountPathList
	CREATE TABLE #tmpMountPathList
	(
		MountPathId	 int
		PRIMARY KEY(MountPathId)
	)
	IF (@skipSettingMMErrorCodes = 0)
	BEGIN
		IF (@AllSPSelected = 1)
		BEGIN
			INSERT INTO #tmpMountPathList
			SELECT 0
		END
		ELSE
		BEGIN
			INSERT INTO #tmpMountPathList
			SELECT DISTINCT DAF.mountPathId
			FROM MMDeletedAF DAF WITH (NOLOCK), #tmpSelectedCopies T
			WHERE DAF.copyId = T.copyId
			UNION
			SELECT DISTINCT DAF.mountPathId
			FROM MMDeletedAF DAF WITH (NOLOCK) LEFT OUTER JOIN archGroupCopy AGC WITH (NOLOCK)
			ON DAF.copyId = AGC.Id
			WHERE AGC.Id IS NULL
			AND		DAF.copyId > 0
			UNION
			SELECT DISTINCT (CASE WHEN (V.currMountPathId > 0 AND V.siloStatus = 2) THEN V.currMountPathId ELSE MP.mountPathId END) AS mountPathId
			FROM MMVolume V WITH (NOLOCK)
			INNER JOIN MMMountPath MP WITH (NOLOCK)
			ON	V.mediaSideId = MP.mediaSideId
			LEFT OUTER JOIN archStream S WITH (NOLOCK)
			ON	V.mediaGroupId = S.mediaGroupId
			WHERE V.volumeFlags = 6
			AND	 	(S.archGroupCopyId IS NULL OR S.archGroupCopyId IN (SELECT copyId FROM #tmpSelectedCopies))
		END
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		DECLARE	MountPathListCursor CURSOR STATIC FOR
		SELECT MountPathId
		FROM #tmpMountPathList
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SET		@MountPathListCursorFlag = 1
		OPEN	MountPathListCursor
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM MountPathListCursor
		INTO	@curMountPathId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			EXEC MMSetErrorCodeForPruningFailures @curMountPathId, 0, ''
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			FETCH	NEXT
			FROM MountPathListCursor
			INTO	@curMountPathId
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
	END
CX_EXIT:
	EXEC sp_xml_removedocument @handle
	IF @MountPathListCursorFlag = 1
	BEGIN
			CLOSE				MountPathListCursor
			DEALLOCATE	MountPathListCursor
	END
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'DaTSRptSetMMErrorCodesForPruningFailures')
	delete from GxQscripts where name = 'DaTSRptSetMMErrorCodesForPruningFailures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptSetMMErrorCodesForPruningFailures')
	delete from GXDBVersions where aliasname = 'DaTSRptSetMMErrorCodesForPruningFailures'
GO

insert into GXDBVersions values(2, 'DaTSRptSetMMErrorCodesForPruningFailures',  '00010002018600020000', 'DaTSRptSetMMErrorCodesForPruningFailures', '00010002018600020000')
GO

