

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DaTSRptGetMediaInfo.sp] ---------- 

--  +========================================================================+
--  | Cursor Name:  DaTSRptGetMediaInfo()
--  | Description:  Retrieves the list of jobs AND their prune info sorted
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DaTSRptGetMediaInfo.sp,v $ $Id: DaTSRptGetMediaInfo.sp,v 1.24.34.3 2020/03/27 02:00:35 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DaTSRptGetMediaInfo')
BEGIN
	print '>>> Drop Stored Procedure: DaTSRptGetMediaInfo <<<'
	drop procedure DaTSRptGetMediaInfo
END
IF EXISTS (select * from GxQscripts where name='DaTSRptGetMediaInfo')
	delete from GxQscripts where name = 'DaTSRptGetMediaInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptGetMediaInfo')
	delete from GXDBVersions where aliasname = 'DaTSRptGetMediaInfo'
GO
print '... Creating Procedure: DaTSRptGetMediaInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DaTSRptGetMediaInfo
  @inPruneStatus integer
AS
-- Cursor Output
  DECLARE @o_PruneStatus INTEGER
  DECLARE @o_BarCode CHAR(255)
  DECLARE @o_VolumeFlags INTEGER
  DECLARE @o_MediaId INTEGER
  DECLARE @o_MediaTypeId INTEGER
  DECLARE @o_MountPathTypeId INTEGER
  DECLARE @o_PolicyId INTEGER
  DECLARE @o_PrimaryCopyId INTEGER
  DECLARE @o_CopyId INTEGER
  DECLARE @o_CopyType INTEGER
  DECLARE @o_RetentionCycles INTEGER
  DECLARE @o_RetentionDays INTEGER
  DECLARE @o_PolicyName CHAR(255)
  DECLARE @o_CopyName CHAR(255)
  DECLARE @o_AgingRuleFlags INTEGER
  DECLARE @o_MagSizeToFree BIGINT
  DECLARE @o_MagSizeToKeep BIGINT
  DECLARE @o_LibraryId INTEGER
  DECLARE @o_LibraryName CHAR(255)
  DECLARE @o_MediaLocationId INTEGER
  DECLARE @o_ExportlocationId INTEGER
  DECLARE @o_ExportLocation CHAR(255)
  DECLARE @o_ContainerId INTEGER
  DECLARE @o_ContainerName CHAR(255)
  DECLARE @o_MediaEstAgingDate BIGINT
  DECLARE @o_commCellId INTEGER
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_SIDBStoreName CHAR(255)
  DECLARE @o_SIDBStatus INTEGER
  DECLARE @o_SIDBFlags INTEGER
  DECLARE @o_StoreEstAgingDate BIGINT
  DECLARE @o_StorePruneStatus INTEGER
  DECLARE @o_MediaEstAgingDateTZ NCHAR(255)
  DECLARE @o_NumBarcodeInStore INTEGER
  DECLARE @o_NumBarcodeInLibrary INTEGER
  DECLARE @o_NumBarcodeInCopy INTEGER
  DECLARE @o_NumBarcodeInLocation INTEGER		
  DECLARE @o_pendingSizeToFree BIGINT
  DECLARE @o_PruneFailureErrorCode VARCHAR(MAX)
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tmpVolumePruneInfo') IS NOT null
	DROP TABLE #tmpVolumePruneInfo
CREATE TABLE #tmpVolumePruneInfo (
	PruneStatus						INTEGER,
	BarCode								VARCHAR(255),
	VolumeFlags						INTEGER,
	MediaId								INTEGER,
	MediaTypeId						INTEGER,
	MountPathTypeId 			INTEGER,
	PolicyId							INTEGER,
	PrimaryCopyId					INTEGER,
	CopyId								INTEGER,
	CopyType							INTEGER,
	RetentionCycles				INTEGER,
	RetentionDays					INTEGER,
	PolicyName						VARCHAR(255),
	CopyName							VARCHAR(255),
	AgingRuleFlags				INTEGER,
	MagSizeToFree					BIGINT,
	MagSizeToKeep					BIGINT,
	LibraryId							INTEGER,
	LibraryName						VARCHAR(255),
	MediaLocationId				INTEGER,
	ExportlocationId			INTEGER,
	ExportLocation				VARCHAR(255),
	ContainerId						INTEGER,
	ContainerName					VARCHAR(255),
	MediaEstAgingDate			BIGINT,
	commCellId						INTEGER,
	SIDBStoreId						INTEGER,
	SIDBStoreName					VARCHAR(255),
	SIDBStatus						INTEGER,
	SIDBFlags							INTEGER,
	StoreEstAgingDate			BIGINT,
	StorePruneStatus			INTEGER,
MediaEstAgingDateTZ		NCHAR(255)
)
CREATE INDEX Idx_tmpVolumePruneInfo_1 ON #tmpVolumePruneInfo (SIDBStoreId, CommCellId, libraryId, copyId)
IF object_id('tempdb.dbo.#tmpNumBarcodeMag') IS NOT null
	DROP TABLE #tmpNumBarcodeMag
CREATE TABLE #tmpNumBarcodeMag
(
		numBarcodeInStore 		INTEGER,
		SIDBStoreId						INTEGER,
		numBarcodeInLibrary 	INTEGER,
		libraryId 						INTEGER,
		numBarcodeInCopy 			INTEGER,
		copyId 								INTEGER
		PRIMARY KEY (SIDBStoreId, libraryId, copyId)
)
IF object_id('tempdb.dbo.#tmpNumBarcodeNonMag') IS NOT null
	DROP TABLE #tmpNumBarcodeNonMag
CREATE TABLE #tmpNumBarcodeNonMag
(
		numBarcodeInLibrary 	INTEGER,
		libraryId 						INTEGER,
		numBarcodeInLocation 	INTEGER,
		MediaLocationId 			INTEGER,
		ExportLocationId 			INTEGER,
		ContainerId						INTEGER
		PRIMARY KEY (libraryId, MediaLocationId, ExportLocationId, ContainerId)
)
IF object_id('tempdb.dbo.#tmpMagMediaErrorCodes') IS NOT null
	DROP TABLE #tmpMagMediaErrorCodes
CREATE TABLE #tmpMagMediaErrorCodes
(
		SIDBStoreId				INTEGER,
		commCellId				INTEGER,
		libraryId					INTEGER,
		copyId						INTEGER,
		mountPathId				INTEGER,
		mediaId 					INTEGER,
		pendingSizeToFree	BIGINT,
		errorCodeList			VARCHAR(MAX)
)
CREATE INDEX Idx_tmpMagMediaErrorCodes_1 ON #tmpMagMediaErrorCodes (SIDBStoreId, commCellId, libraryId, copyId, mountPathId, mediaId)
IF object_id('tempdb.dbo.#tmpSIDBPruneStatus') IS NOT null
	DROP TABLE #tmpSIDBPruneStatus
CREATE TABLE #tmpSIDBPruneStatus
(
		SIDBStoreId				INTEGER,
		commCellId				INTEGER,
		StoreEstAgingDate		BIGINT,
		StorePruneStatus		INTEGER,
		PRIMARY KEY (SidbStoreId, commCellId)
)
IF object_id('tempdb.dbo.#tmpMediaPruneStatus') IS NOT null
	DROP TABLE #tmpMediaPruneStatus
CREATE TABLE #tmpMediaPruneStatus
(
		LibraryId			INTEGER,
		BarCode				VARCHAR(255),
		copyId				INTEGER,
		MediaPruneStatus	INTEGER,
		PRIMARY KEY (LibraryId, BarCode, copyId, MediaPruneStatus)
)
	DECLARE @MAXINT INT
	SET @MAXINT = 2147483647
	INSERT INTO  #tmpSIDBPruneStatus
	SELECT DISTINCT SIDBStoreId, commCellId, StoreEstAgingDate, StorePruneStatus
	FROM #VolumePruneInfo
	INSERT INTO  #tmpMediaPruneStatus
	SELECT DISTINCT LibraryId, BarCode, copyId, PruneStatus
	FROM #VolumePruneInfo
	-- Get magnetic media info
	IF @inPruneStatus = 0
	BEGIN
		--Get the size that is pending to free
		INSERT INTO #tmpMagMediaErrorCodes
		SELECT TMP.SIDBStoreId, TMP.commCellId, TMP.libraryId, TMP.copyId, TMP.mountPathId, TMP.mediaId, SUM(TMP.pendingSizeToFree), TMP.errorCodeList
		FROM	(
						SELECT DAF.SIDBStoreId, (CASE WHEN DAF.commCellId > 0 THEN DAF.commCellId ELSE DAF.chunkCommCellId END) AS commCellId, 0 AS libraryId, DAF.copyId, DAF.mountPathId, 0 AS mediaId,
									 SUM(DAF.CapacityFreedBytes) AS pendingSizeToFree, '' AS errorCodeList
						FROM MMDeletedAF DAF WITH (NOLOCK), #tmpSelectedCopies T
						WHERE DAF.copyId = T.copyId
						GROUP BY DAF.SIDBStoreId, (CASE WHEN DAF.commCellId > 0 THEN DAF.commCellId ELSE DAF.chunkCommCellId END), DAF.copyId, DAF.mountPathId
						UNION
						SELECT DAF.SIDBStoreId, (CASE WHEN DAF.commCellId > 0 THEN DAF.commCellId ELSE DAF.chunkCommCellId END) AS commCellId, 0 AS libraryId, DAF.copyId, DAF.mountPathId, 0 AS mediaId,
									 SUM(DAF.CapacityFreedBytes) AS pendingSizeToFree, '' AS errorCodeList
						FROM MMDeletedAF DAF WITH (NOLOCK) LEFT OUTER JOIN archGroupCopy AGC WITH (NOLOCK)
						ON DAF.copyId = AGC.Id
						WHERE AGC.Id IS NULL
						AND		DAF.copyId > 0
						GROUP BY DAF.SIDBStoreId, (CASE WHEN DAF.commCellId > 0 THEN DAF.commCellId ELSE DAF.chunkCommCellId END), DAF.copyId, DAF.mountPathId
						UNION
						SELECT V.SIDBStoreId, (CASE WHEN V.OrigCCCommcellId = 0 THEN 2 ELSE V.OrigCCCommcellId END) AS commCellId,
									 0 AS libraryId, ISNULL(CAST(S.archGroupCopyId AS INT), @MAXINT) AS copyId,
									 (CASE WHEN (V.currMountPathId > 0 AND V.siloStatus = 2) THEN V.currMountPathId ELSE MP.mountPathId END) AS mountPathId,
									 0 AS mediaId, (SUM(CAST(physicalBytesMB AS BIGINT)) * 1024) AS pendingSizeToFree, '' AS errorCodeList
						FROM MMVolume V WITH (NOLOCK)
						INNER JOIN MMMountPath MP WITH (NOLOCK)
						ON	V.mediaSideId = MP.mediaSideId
						LEFT OUTER JOIN archStream S WITH (NOLOCK)
						ON	V.mediaGroupId = S.mediaGroupId
						WHERE V.volumeFlags = 6
						AND		( (V.SIDBStoreId > 0 AND V.FailureErrorCode > 0) OR (V.SIDBStoreId = 0 AND V.physicalBytesMB > 0) )
						AND	 	(S.archGroupCopyId IS NULL OR S.archGroupCopyId IN (SELECT copyId FROM #tmpSelectedCopies))
						GROUP BY V.SIDBStoreId, (CASE WHEN V.OrigCCCommcellId = 0 THEN 2 ELSE V.OrigCCCommcellId END),
											ISNULL(CAST(S.archGroupCopyId AS INT), @MAXINT), CASE WHEN (V.currMountPathId > 0 AND V.siloStatus = 2) THEN V.currMountPathId ELSE MP.mountPathId END
					) TMP
		GROUP BY TMP.SIDBStoreId, TMP.commCellId, TMP.libraryId, TMP.copyId, TMP.mountPathId, TMP.mediaId, TMP.errorCodeList
		UPDATE #tmpMagMediaErrorCodes
		SET libraryId = MP.libraryId,
				mediaId		= MS.mediaId
		FROM #tmpMagMediaErrorCodes T, MMMountPath MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
		WHERE T.mountPathId = MP.mountPathId
		AND		MP.mediaSideId = MS.mediaSideId
		UPDATE #tmpMagMediaErrorCodes
		SET	errorCodeList = dbo.DaTSRptGetMountPathErrorCode(SIDBStoreId, copyId, mediaId)
		INSERT	INTO #tmpVolumePruneInfo
		SELECT	distinct VPI.*, dbo.GetClientTimeZone(2) -- CS TimeZone Name for MediaEstAgingDate
		FROM #VolumePruneInfo VPI, #tmpSelectedCopies TMP
		WHERE	VPI.MediaTypeId = 10001
		AND		VPI.CopyId = TMP.CopyId
		UNION
		--Get the entries for deleted copies
		SELECT 	DISTINCT 1, 'N/A', 0, T.MediaId, 0, 0, 0, 0, T.CopyId,
						0, 0, 0, 'N/A', 'N/A', 0, 0, 0, T.LibraryId, 'N/A', 0, 0, '',
						0, 'N/A', 0, T.commCellId, T.SIDBStoreId, 'N/A', 0, 0,
						0, 1, dbo.GetClientTimeZone(2) -- CS TimeZone Name for MediaEstAgingDate
		FROM #tmpMagMediaErrorCodes T LEFT OUTER JOIN archGroupCopy AGC WITH (NOLOCK)
		ON T.CopyId = AGC.id
		WHERE AGC.id IS NULL
		--Get the entries from MMDeletedAF
		INSERT	INTO #tmpVolumePruneInfo
		SELECT 	DISTINCT 1, 'N/A', 0, T.MediaId, 0, 0, C.PolicyId, C.PrimaryCopyId, C.CopyId,
						C.CopyType, C.RetentionCycles, C.RetentionDays, C.PolicyName, C.CopyName, C.AgingRuleFlags,
						0, 0, T.LibraryId, 'N/A', 0, 0, '',
						0, 'N/A', 0, T.commCellId, T.SIDBStoreId, 'N/A', 0, 0,
						0, 1, dbo.GetClientTimeZone(2) -- CS TimeZone Name for MediaEstAgingDate
		FROM #tmpMagMediaErrorCodes T, #tmpSelectedCopies TMP, #CopyIdInfo C
		WHERE	T.CopyId = TMP.CopyId
		AND 	TMP.CopyId = C.copyId
		AND NOT EXISTS (SELECT *
										FROM #tmpVolumePruneInfo TT
										WHERE TT.SIDBStoreId = T.SIDBStoreId
										AND		TT.LibraryId = T.LibraryId
										AND		TT.CopyId = T.CopyId
										AND		TT.MediaId = T.MediaId
									)
		UPDATE #tmpVolumePruneInfo
		SET 	BarCode = M.BarCode,
					MediaTypeId = M.MediaTypeId,
					MediaLocationId = M.MediaLocation,
					ExportlocationId = M.ExportlocationId,
					ContainerId = M.ContainerId
		FROM #tmpVolumePruneInfo TMP, MMMedia M WITH (NOLOCK)
		WHERE TMP.MediaId = M.MediaId
		DELETE  #tmpVolumePruneInfo
WHERE MediaTypeId != 10001
		UPDATE #tmpVolumePruneInfo
		SET StorePruneStatus = 0
		FROM #tmpVolumePruneInfo TMP, archJobsOnStoreInfo JS, JMBkpStats JBK WITH (NOLOCK)
		WHERE TMP.SIDBStoreId = JS.StoreId
		AND	  TMP.commCellId = JS.commCellId
		AND	  JS.jobId = JBK.jobId
		AND   JS.commCellId = JBK.commCellId
		AND   JBK.status IN (1, 3, 14)
		AND	  TMP.StorePruneStatus = 1
		UPDATE #tmpVolumePruneInfo
		SET StorePruneStatus = VPI.StorePruneStatus
		FROM #tmpVolumePruneInfo TMP,  #VolumePruneInfo VPI
		WHERE TMP.SIDBStoreId = VPI.SIDBStoreId
		AND	  TMP.commCellId = VPI.commCellId
		UPDATE	#tmpVolumePruneInfo
		SET		BarCode = MP.MountPathName,
					MountPathTypeId = MP.MountPathTypeId,
					VolumeFlags = 4
		FROM #tmpVolumePruneInfo TMP, MMS2getMountPathNameGUIView MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
		WHERE	TMP.mediaId = MS.mediaId
		AND		MS.mediaSideId = MP.mediaSideId
AND		TMP.MediaTypeId = 10001
		UPDATE	#tmpVolumePruneInfo
		SET		LibraryName = L.aliasName
		FROM #tmpVolumePruneInfo TMP, MMLibrary L WITH (NOLOCK)
		WHERE	TMP.libraryId = L.libraryId
		UPDATE #tmpVolumePruneInfo
		SET 	SIDBStoreName = SS.SIDBStoreName,
					SIDBStatus = SS.Status,
					SIDBFlags = SS.flags
		FROM #tmpVolumePruneInfo TMP, IdxSIDBStore SS WITH (NOLOCK)
		WHERE TMP.SIDBStoreId = SS.SIDBStoreId
		AND		TMP.commCellId = SS.commCellId
		UPDATE 	#tmpVolumePruneInfo
		SET 	StoreEstAgingDate = T1.StoreEstAgingDate,
				StorePruneStatus = T1.StorePruneStatus
		FROM	#tmpVolumePruneInfo T, #tmpSIDBPruneStatus T1
		WHERE	T.SIDBStoreId = T1.SIDBStoreId
		AND		T.commCellId = T1.commCellId
		UPDATE 	#tmpVolumePruneInfo
		SET 	PruneStatus = T1.MediaPruneStatus
		FROM	#tmpVolumePruneInfo T, #tmpMediaPruneStatus T1
		WHERE	T.LibraryId = T1.LibraryId
		AND		T.BarCode = T1.BarCode
		AND		T.copyId = T1.copyId
		INSERT	INTO #tmpNumBarcodeMag
		SELECT	0, SIDBStoreId, 0, libraryId, COUNT(*), copyId
		FROM	#tmpVolumePruneInfo
		GROUP	BY SIDBStoreId, libraryId, copyId
		UPDATE #tmpNumBarcodeMag
		SET		numBarcodeInLibrary = b.numBarcodeInLibrary
		FROM	#tmpNumBarcodeMag a,
				(SELECT SUM(T.numBarcodeInCopy) as numBarcodeInLibrary, T.SIDBStoreId AS SIDBStoreId, T.libraryId AS libraryId
				FROM	#tmpNumBarcodeMag T
				GROUP	BY T.SIDBStoreId, T.libraryId
				) b
		WHERE	a.SIDBStoreId = b.SIDBStoreId
		AND		a.libraryId = b.libraryId
		UPDATE #tmpNumBarcodeMag
		SET		numBarcodeInStore = b.numBarcodeInStore
		FROM	#tmpNumBarcodeMag a,
				(SELECT SUM(T.numBarcodeInCopy) as numBarcodeInStore, T.SIDBStoreId AS SIDBStoreId
				FROM	#tmpNumBarcodeMag T
				GROUP	BY T.SIDBStoreId
				) b
		WHERE	a.SIDBStoreId = b.SIDBStoreId
		SELECT	a.*, b.numBarcodeInStore, b.numBarcodeInLibrary, b.numBarcodeInCopy, 0, ISNULL(t.pendingSizeToFree, 0), ISNULL(t.errorCodeList, '')
		FROM	#tmpVolumePruneInfo a INNER JOIN #tmpNumBarcodeMag b
			ON a.SIDBStoreId = b.SIDBStoreId
			AND		a.libraryId = b.libraryId
			AND		a.copyId = b.copyId
		LEFT OUTER JOIN #tmpMagMediaErrorCodes t
			ON		a.SIDBStoreId = t.SIDBStoreId
			AND		a.libraryId = t.libraryId
			AND		a.copyId = t.copyId
			AND		a.mediaId = t.mediaId
		ORDER	BY a.SIDBStoreId, a.LibraryId, a.PolicyId, a.CopyId, a.CommCellId, a.Barcode
	END
	-- Get non magnetic media info
	IF @inPruneStatus <> 0
	BEGIN
		INSERT	INTO #tmpVolumePruneInfo
		SELECT	VPI.*, dbo.GetClientTimeZone(2) -- CS TimeZone Name for MediaEstAgingDate
		FROM #VolumePruneInfo VPI, #tmpSelectedCopies TMP
		WHERE	VPI.MediaTypeId <> 10001
		AND		VPI.CopyId = TMP.CopyId
		UPDATE	#tmpVolumePruneInfo
		SET		MediaLocationId = 1
		FROM	#tmpVolumePruneInfo
		WHERE	MediaLocationId = 2
		INSERT	INTO #tmpNumBarcodeNonMag
		SELECT	0, libraryId, COUNT(*), MediaLocationId, ExportLocationId, ContainerId
		FROM	#tmpVolumePruneInfo
		GROUP	BY libraryId, MediaLocationId, ExportLocationId, ContainerId
		UPDATE #tmpNumBarcodeNonMag
		SET		numBarcodeInLibrary = b.numBarcodeInLibrary
		FROM	#tmpNumBarcodeNonMag a,
				(SELECT SUM(t.numBarcodeInLocation) as numBarcodeInLibrary, t.libraryId as libraryId
				FROM	#tmpNumBarcodeNonMag t
				GROUP	BY	t.libraryId
				) b
		WHERE	a.libraryId = b.libraryId
		SELECT	a.*, 0, b.numBarcodeInLibrary, 0, b.numBarcodeInLocation, 0, ''
		FROM	#tmpVolumePruneInfo a, #tmpNumBarcodeNonMag b
		WHERE	b.libraryId = a.libraryId
		AND		b.mediaLocationId = a.mediaLocationId
		AND		b.ExportLocationId = a.ExportLocationId
		AND		b.ContainerId = a.ContainerId
		ORDER	BY a.LibraryId, a.MediaLocationId, a.ExportLocationId, a.ContainerId, a.Barcode
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'DaTSRptGetMediaInfo')
	delete from GxQscripts where name = 'DaTSRptGetMediaInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptGetMediaInfo')
	delete from GXDBVersions where aliasname = 'DaTSRptGetMediaInfo'
GO

insert into GXDBVersions values(2, 'DaTSRptGetMediaInfo',  '00010024003400030000', 'DaTSRptGetMediaInfo', '00010024003400030000')
GO

