

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DaTSRptGetJobInfo.sp] ---------- 

--  +========================================================================+
--  | Cursor Name:  DaTSRptGetJobInfo()
--  | Description:  Retrieves the list of jobs AND their prune info sorted
--  |				by storage policy, copy AND volume
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DaTSRptGetJobInfo.sp,v $ $Id: DaTSRptGetJobInfo.sp,v 1.42.88.7 2018/09/21 04:08:35 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DaTSRptGetJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: DaTSRptGetJobInfo <<<'
	drop procedure DaTSRptGetJobInfo
END
IF EXISTS (select * from GxQscripts where name='DaTSRptGetJobInfo')
	delete from GxQscripts where name = 'DaTSRptGetJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptGetJobInfo')
	delete from GXDBVersions where aliasname = 'DaTSRptGetJobInfo'
GO
print '... Creating Procedure: DaTSRptGetJobInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DaTSRptGetJobInfo
  @i_taskId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @o_OrderByClient INTEGER
  DECLARE @o_VolumePruneStatus INTEGER
  DECLARE @o_PruneStatus INTEGER
  DECLARE @o_JobId INTEGER
  DECLARE @o_CommCellId INTEGER
  DECLARE @o_CommCellName CHAR(255)
  DECLARE @o_AppId INTEGER
  DECLARE @o_AppFlags BIGINT
  DECLARE @o_CopyId INTEGER
  DECLARE @o_VolumeId INTEGER
  DECLARE @o_BarCode CHAR(255)
  DECLARE @o_MediaTypeId INTEGER
  DECLARE @o_MountPathTypeId INTEGER
  DECLARE @o_VolumeEstAgingDate BIGINT
  DECLARE @o_VolumeEstAgingDateTZ NCHAR(255)
  DECLARE @o_LibraryId INTEGER
  DECLARE @o_LibraryName CHAR(255)
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_SIDBStoreName CHAR(255)
  DECLARE @o_SIDBStatus INTEGER
  DECLARE @o_SIDBFlags INTEGER
  DECLARE @o_StoreEstAgingDate BIGINT
  DECLARE @o_StorePruneStatus INTEGER
  DECLARE @o_NumJobonVolCopy INTEGER
  DECLARE @o_NumJobonStoreCopy INTEGER
  DECLARE @o_AppType INTEGER
  DECLARE @o_AppTypeName CHAR(255)
  DECLARE @o_ClientId INTEGER
  DECLARE @o_ClientName NCHAR(255)
  DECLARE @o_InstanceName NCHAR(255)
  DECLARE @o_BackupSetName NCHAR(255)
  DECLARE @o_SubclientName NCHAR(255)
  DECLARE @o_PolicyName CHAR(255)
  DECLARE @o_CopyName CHAR(255)
  DECLARE @o_AgingRuleFlags INTEGER
  DECLARE @o_JobStatus INTEGER
  DECLARE @o_BkpLevel INTEGER
  DECLARE @o_StartTime INTEGER
  DECLARE @o_EndTime INTEGER
  DECLARE @o_TimeZoneToHonor NCHAR(255)
  DECLARE @o_LocalStartTime NCHAR(255)
  DECLARE @o_LocalEndTime NCHAR(255)
  DECLARE @o_DataStatus INTEGER
  DECLARE @o_DataDisabled INTEGER
  DECLARE @o_fullCycleNum INTEGER
  DECLARE @o_cyclesequence INTEGER
  DECLARE @o_CycleId INTEGER
  DECLARE @o_CycleEndTime INTEGER
  DECLARE @o_CycleEndJob INTEGER
  DECLARE @o_EstimatedAgingDate BIGINT
  DECLARE @o_LocalEstimatedAgingDate NCHAR(255)
  DECLARE @o_ExtRetentionFlags INTEGER 
  DECLARE @o_JobRetainReason INTEGER
  DECLARE @o_BkpAttributes BIGINT
  DECLARE @o_NumJobClientCopy INTEGER
  DECLARE @o_NumJobClientAppCopy INTEGER
  DECLARE @o_NumJobClientAppSubclientCopy INTEGER
  DECLARE @o_JobFlags INTEGER
  DECLARE @o_AppFlagsExt INTEGER
  DECLARE @o_CopyIsActive INTEGER
  DECLARE @o_retainedByJobIds CHAR(255)
  DECLARE @o_ClientDisplayName NVARCHAR(255)
DECLARE	@JobsOnNoMediaCnt			INTEGER
DECLARE @errorCode		INTEGER
SET		@errorCode		= 0
DECLARE @isSnapCopy		INTEGER
SET		@isSnapCopy		= 0
DECLARE @userId					INTEGER
DECLARE @locId					INTEGER
DECLARE @flags					BIGINT
DECLARE @orderBy 				INTEGER
DECLARE @rowCount				INTEGER
-- Get parameters
EXEC RptOptGetUserFlags @i_taskId, @userId OUTPUT, @locId OUTPUT, @flags OUTPUT
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
SET @orderBy = (CASE WHEN (@flags & 0x80) > 0 THEN 1 ELSE 0 END)
IF object_id('tempdb.dbo.#tmpJobInfo') IS NOT null DROP TABLE #tmpJobInfo
CREATE TABLE #tmpJobInfo
(
 OrderByClient INT, VolumePruneStatus INT, PruneStatus INT, JobId INT, CommCellId INT, CommCellName VARCHAR(1024),
 AppId INT, AppFlags BIGINT, CopyId INT, VolumeId INT, BarCode VARCHAR(1024), MediaTypeId INT, MountPathTypeId INT, VolumeEstAgingDate BIGINT,
 VolumeEstAgingDateTZ NVARCHAR(1024), LibraryId INT, LibraryName VARCHAR(1024), SIDBStoreId	INT, SIDBStoreName VARCHAR(1024), SIDBStatus INT,
 SIDBFlags INT, StoreEstAgingDate BIGINT, StorePruneStatus	INT, NumJobonVolCopy INT, NumJobonStoreCopy INT, AppType INT,
 AppTypeName VARCHAR(1024), ClientId INT, ClientName NVARCHAR(1024), InstanceName NVARCHAR(1024), BackupSetName NVARCHAR(1024),
 SubclientName NVARCHAR(1024), PolicyName VARCHAR(1024), CopyName VARCHAR(1024), AgingRuleFlags INT, JobStatus INT, BkpLevel INT,
 StartTime INT, EndTime INT, TimeZoneToHonor NVARCHAR(1024), LocalStartTime NVARCHAR(1024), LocalEndTime NVARCHAR(1024),
 DataStatus INT, Disabled INT, fullCycleNum INT, cyclesequence INT, CycleId INT, cycleEndTime INT, cycleEndJob INT, estimatedAgingDate BIGINT,
 LocalEstimatedAgingDate NVARCHAR(1024), extRetentionFlags INT, jobRetainReason INT, BkpAttributes BIGINT,
 NumJobPerClient INT, NumJobPerAppType INT, NumJobPerAppId INT, JobFlags INT, AppFlagsExt INT, CopyIsActive INT, retainedByJobIds VARCHAR(MAX), ClientDisplayName NVARCHAR(1024))
SELECT @rowCount = count(*)
FROM #ArchJobCopy
WHERE copyId = @i_copyId
IF @rowCount = 0 GOTO CX_EXIT
SELECT @isSnapCopy = isSnapCopy
FROM archGroupCopy WITH (NOLOCK)
WHERE Id = @i_copyId
IF @@ERROR != 0 GOTO CX_EXIT
INSERT INTO #tmpJobInfo
(OrderByClient, VolumePruneStatus, PruneStatus, JobId, CommCellId, CommCellName, AppId, AppFlags, CopyId, VolumeId,
BarCode, MediaTypeId, MountPathTypeId, VolumeEstAgingDate, VolumeEstAgingDateTZ, LibraryId, LibraryName, SIDBStoreId, SIDBStoreName,
SIDBStatus,	SIDBFlags, StoreEstAgingDate, StorePruneStatus, NumJobonVolCopy, NumJobonStoreCopy,
AppType, AppTypeName, ClientId, ClientName, InstanceName, BackupSetName, SubclientName, PolicyName, CopyName, AgingRuleFlags, JobStatus,
BkpLevel, StartTime, EndTime, TimeZoneToHonor, LocalStartTime, LocalEndTime, DataStatus, Disabled, fullCycleNum, cyclesequence,
CycleId, cycleEndTime, cycleEndJob, estimatedAgingDate,	LocalEstimatedAgingDate, extRetentionFlags, jobRetainReason,
BkpAttributes, NumJobPerClient, NumJobPerAppType, NumJobPerAppId, JobFlags, AppFlagsExt, CopyIsActive, retainedByJobIds, ClientDisplayName)
SELECT (CASE WHEN @orderBy = 1 THEN 1 ELSE 0 END) AS OrderByClient, A.MediaPruneStatus AS VolumePruneStatus, A.PruneStatus, A.JobId, A.CommCellId, D.CommCellName,
		A.AppId, A.AppFlags, A.CopyId, A.VolumeId, A.BarCode, A.MediaTypeId, A.MountPathTypeId,
		A.VolumeEstAgingDate, dbo.GetClientTimeZone(2) AS VolumeEstAgingDateTZ, -- CS TimeZone Name for VolumeEstAgingDate
		A.LibraryId, A.LibraryName, A.SIDBStoreId, A.SIDBStoreName, A.SIDBStatus,	A.SIDBFlags, A.StoreEstAgingDate, A.StorePruneStatus,
		A.NumJobonVolCopy, A.NumJobonStoreCopy, 0, '', 0, N'', N'', N'', N'', '', '', 0, D.JobStatus, D.BkpLevel,
		dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTime(D.StartTime), D.TimeZoneToHonor)) AS StartTime,
		dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTime(D.EndTime), D.TimeZoneToHonor)) AS EndTime,
		D.TimeZoneToHonor,
		CASE WHEN D.startTime > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTime(D.startTime), D.TimeZoneToHonor) ELSE N'' END AS LocalStartTime,
		CASE WHEN D.EndTime > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTime(D.EndTime), D.TimeZoneToHonor) ELSE N'' END AS LocalEndTime,
		D.DataStatus, D.Disabled, D.fullCycleNum, D.cyclesequence, D.CycleId,	0 AS cycleEndTime, 0 AS cycleEndJob,
		CASE WHEN D.estimatedAgingDate > 0 THEN dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTimeBig(D.estimatedAgingDate), D.TimeZoneToHonor)) ELSE D.estimatedAgingDate END AS estimatedAgingDate,
		CASE WHEN D.estimatedAgingDate > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTimeBig(D.estimatedAgingDate), D.TimeZoneToHonor) ELSE N'' END AS LocalEstimatedAgingDate,
		D.extRetentionFlags, D.jobRetainReason, D.BkpAttributes, 0 AS NumJobPerClient, 0 AS NumJobPerAppType, 0 AS NumJobPerAppId, D.JobFlags, D.AppFlagsExt, 1, D.retainedByJobIds, N''
FROM	#JobMediaPruneInfo A, #ArchJobCopy D
WHERE	A.CopyId = @i_copyId AND A.JobId = D.JobId AND A.CommCellId = D.CommCellId AND A.CopyId = D.CopyId AND A.appflags = D.appflags
UNION
-- Get all Foreign Commcell jobs
-- Get all Snap jobs on Snap Copies without BCD Index
-- Get Cloud Paas jobs
SELECT (CASE WHEN @orderBy = 1 THEN 1 ELSE 0 END) AS OrderByClient, D.PruneStatus AS VolumePruneStatus, D.PruneStatus, D.JobId, D.CommCellId, D.CommCellName,
		D.AppId, D.AppFlags, D.CopyId, -1 AS VolumeId, 'NO MEDIA' AS BarCode, 0 AS MediaTypeId, 0 AS MountPathTypeId,
		-1 AS VolumeEstAgingDate, dbo.GetClientTimeZone(2) AS VolumeEstAgingDateTZ, -- CS TimeZone Name for VolumeEstAgingDate
		0 AS LibraryId, '' AS LibraryName, -2 AS SIDBStoreId, '' AS SIDBStoreName, 0 AS SIDBStatus,	0 AS SIDBFlags, 0 AS StoreEstAgingDate, 0 AS StorePruneStatus,
		0 AS NumJobonVolCopy, 0 AS NumJobonStoreCopy, 0, '', 0, N'', N'', N'', N'', '', '', 0, D.JobStatus, D.BkpLevel,
		dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTime(D.StartTime), D.TimeZoneToHonor)) AS StartTime,
		dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTime(D.EndTime), D.TimeZoneToHonor)) AS EndTime,
		D.TimeZoneToHonor,
		CASE WHEN D.startTime > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTime(D.startTime), D.TimeZoneToHonor) ELSE N'' END AS LocalStartTime,
		CASE WHEN D.EndTime > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTime(D.EndTime), D.TimeZoneToHonor) ELSE N'' END AS LocalEndTime,
		D.DataStatus, D.Disabled, D.fullCycleNum, D.cyclesequence, D.CycleId, 0 AS cycleEndTime, 0 AS cycleEndJob,
		CASE WHEN D.estimatedAgingDate > 0 THEN dbo.getUnixTimeBig(dbo.UTCToLocalTime(dbo.getDateTimeBig(D.estimatedAgingDate), D.TimeZoneToHonor)) ELSE D.estimatedAgingDate END AS estimatedAgingDate,
		CASE WHEN D.estimatedAgingDate > 0 THEN dbo.UTCToLocalStringTime(dbo.getDateTimeBig(D.estimatedAgingDate), D.TimeZoneToHonor) ELSE N'' END AS LocalEstimatedAgingDate,
		D.extRetentionFlags, D.jobRetainReason, D.BkpAttributes, 0 AS NumJobPerClient, 0 AS NumJobPerAppType, 0 AS NumJobPerAppId, D.JobFlags, D.AppFlagsExt, 1, D.retainedByJobIds, N''
FROM	#ArchJobCopy D
WHERE	D.CopyId = @i_copyId
AND		(			((D.JobFlags & 2) != 0)
OR 	(@isSnapCopy != 0 AND (D.JobFlags & 4) = 0)
OR	((D.AppFlagsExt & 1) != 0)
			)
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
--Indexes for query performance
CREATE INDEX idx_tmpJobInfo_1 ON #tmpJobInfo (appId)
CREATE INDEX idx_tmpJobInfo_2 ON #tmpJobInfo (copyId)
UPDATE #tmpJobInfo
SET	appType = a.AppType, AppTypeName = a.AppTypeName, clientId = a.ClientId, ClientName = a.ClientName,
	InstanceName = a.InstanceName, BackupSetName = a.BackupSetName, SubclientName = a.SubclientName,
	PolicyName = c.PolicyName, CopyName = c.CopyName, AgingRuleFlags = c.AgingRuleFlags, CopyIsActive = c.isActive,
    ClientDisplayName = a.ClientDisplayName
FROM #tmpJobInfo T, #AppIdInfo a, #CopyIdInfo c
WHERE	T.appId = a.appId
AND	T.CopyId = c.CopyId
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
SELECT @JobsOnNoMediaCnt = count(*)
FROM #tmpJobInfo
WHERE VolumeId = -1
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
UPDATE #tmpJobInfo
SET		NumJobonVolCopy = ISNULL(@JobsOnNoMediaCnt, 0), NumJobonStoreCopy = ISNULL(@JobsOnNoMediaCnt, 0)
WHERE VolumeId = -1
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
IF @orderBy = 1 --Order by subclient
BEGIN
	UPDATE #tmpJobInfo
	SET		NumJobPerAppId = b.NumJobPerAppId
	FROM	#tmpJobInfo a,
			(SELECT clientId, appType, appId, count(JobId) as NumJobPerAppId
			FROM #tmpJobInfo
			GROUP BY clientId, appType, appId) b
	WHERE	a.clientId = b.clientId
	AND		a.appType = b.appType
	AND		a.appId = b.appId
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE #tmpJobInfo
	SET		NumJobPerAppType = b.NumJobPerAppType
	FROM	#tmpJobInfo a,
			(SELECT clientId, appType, count(JobId) as NumJobPerAppType
			FROM #tmpJobInfo
			GROUP BY clientId, appType) b
	WHERE	a.clientId = b.clientId
	AND		a.appType = b.appType
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE #tmpJobInfo
	SET		NumJobPerClient = b.NumJobPerClient
	FROM	#tmpJobInfo a,
			(SELECT clientId, count(JobId) as NumJobPerClient
			FROM #tmpJobInfo
			GROUP BY clientId) b
	WHERE	a.clientId = b.clientId
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
END
--Update retainedByJobIds with distinct JobIds
UPDATE #tmpJobInfo
SET retainedByJobIds = SUBSTRING((	SELECT DISTINCT ( ', ' + CAST(TT._ID AS VARCHAR(10)))
																		FROM dbo.SplitIDs(retainedByJobIds) TT
																		FOR XML PATH('')
																	), 2, 99999999)
CX_EXIT:
	IF @orderBy = 1  --Order by subclient
	BEGIN
		SELECT OrderByClient, VolumePruneStatus, PruneStatus, JobId, CommCellId, CommCellName, AppId, AppFlags, CopyId, VolumeId,
		BarCode, MediaTypeId, MountPathTypeId, VolumeEstAgingDate,	VolumeEstAgingDateTZ, LibraryId, LibraryName, SIDBStoreId, SIDBStoreName,
		SIDBStatus,	SIDBFlags, StoreEstAgingDate, StorePruneStatus, NumJobonVolCopy, NumJobonStoreCopy,
		AppType, AppTypeName, ClientId, ClientName, InstanceName, BackupSetName, SubclientName, PolicyName, CopyName, AgingRuleFlags, JobStatus,
		BkpLevel, StartTime, EndTime, TimeZoneToHonor, LocalStartTime, LocalEndTime, DataStatus, Disabled, fullCycleNum, cyclesequence,
		CycleId, cycleEndTime, cycleEndJob, estimatedAgingDate,	LocalEstimatedAgingDate, extRetentionFlags, jobRetainReason,
		BkpAttributes, NumJobPerClient, NumJobPerAppType, NumJobPerAppId, JobFlags, AppFlagsExt, CopyIsActive, retainedByJobIds, ClientDisplayName
		FROM #tmpJobInfo
		ORDER BY clientId, appType, InstanceName, BackupSetName, SubclientName, StartTime, SIDBStoreId, VolumeId
	END
	ELSE
	BEGIN
		SELECT OrderByClient, VolumePruneStatus, PruneStatus, JobId, CommCellId, CommCellName, AppId, AppFlags, CopyId, VolumeId,
		BarCode, MediaTypeId, MountPathTypeId, VolumeEstAgingDate,	VolumeEstAgingDateTZ, LibraryId, LibraryName, SIDBStoreId, SIDBStoreName,
		SIDBStatus,	SIDBFlags, StoreEstAgingDate, StorePruneStatus, NumJobonVolCopy, NumJobonStoreCopy,
		AppType, AppTypeName, ClientId, ClientName, InstanceName, BackupSetName, SubclientName, PolicyName, CopyName, AgingRuleFlags, JobStatus,
		BkpLevel, StartTime, EndTime, TimeZoneToHonor, LocalStartTime, LocalEndTime, DataStatus, Disabled, fullCycleNum, cyclesequence,
		CycleId, cycleEndTime, cycleEndJob, estimatedAgingDate,	LocalEstimatedAgingDate, extRetentionFlags, jobRetainReason,
		BkpAttributes, NumJobPerClient, NumJobPerAppType, NumJobPerAppId, JobFlags, AppFlagsExt, CopyIsActive, retainedByJobIds, ClientDisplayName
		FROM #tmpJobInfo
		ORDER BY SIDBStoreId, VolumeId, StartTime, AppId
	END
IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
SET NOCOUNT OFF
CX_ERROR_EXIT:
	IF object_id('tempdb.dbo.#tmpJobInfo') IS NOT null DROP TABLE #tmpJobInfo
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'DaTSRptGetJobInfo')
	delete from GxQscripts where name = 'DaTSRptGetJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DaTSRptGetJobInfo')
	delete from GXDBVersions where aliasname = 'DaTSRptGetJobInfo'
GO

insert into GXDBVersions values(2, 'DaTSRptGetJobInfo',  '00010042008800070000', 'DaTSRptGetJobInfo', '00010042008800070000')
GO

