

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2WAUpdateSite.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2WAUpdateSite.sp,v $ $Id: DM2WAUpdateSite.sp,v 1.2.42.4 2018/03/27 09:19:13 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2WAUpdateSite <<<'

IF EXISTS (select * from sysobjects where name='DM2WAUpdateSite')
	drop procedure DM2WAUpdateSite
IF EXISTS (select * from GxQscripts where name='DM2WAUpdateSite')
	delete from GxQscripts where name = 'DM2WAUpdateSite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2WAUpdateSite')
	delete from GXDBVersions where aliasname = 'DM2WAUpdateSite'
GO
print '... Creating Procedure: DM2WAUpdateSite'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2WAUpdateSite
  @i_UserID int,
  @i_SiteName nvarchar(128),
  @i_GUID varchar(64),
  @i_SiteData nvarchar(max),
  @i_ModifyTime bigint,
  @i_ListOfDomains xml,
  @i_localeId INT =0
AS
BEGIN
  DECLARE @o_errorCode integer;
  DECLARE @o_errorMessage varchar(MAX);
  DECLARE @l_RegisteredSiteID integer;
  DECLARE @l_ID integer;
SET NOCOUNT ON
IF EXISTS  (select top 1 ID from WARegisteredSite WITH (READUNCOMMITTED) where SiteName = @i_SiteName AND UserID=@i_UserID AND SiteGUID <> @i_GUID)
BEGIN
	SET @o_errorCode=12006;
	SET @o_errorMessage='Site with the given name is already registered';
END
ELSE IF EXISTS (select top 1 SiteGUID from WARegisteredSite WITH (READUNCOMMITTED) where SiteGUID = @i_GUID)
	BEGIN
		DECLARE @oldSiteData nvarchar(max) = ISNULL ( (select top 1 SiteData from WARegisteredSite WITH (READUNCOMMITTED) where SiteGUID = @i_GUID) ,'')
		update WARegisteredSite set UserID=@i_UserID,SiteName=@i_SiteName,SiteGUID=@i_GUID,SiteData=@i_SiteData,ModifyTime=@i_ModifyTime where SiteGUID = @i_GUID;
		select top 1 @l_RegisteredSiteID= ID from WARegisteredSite WITH (READUNCOMMITTED) where SiteGUID= @i_GUID;
		delete from WAUrls where RegisteredSiteID=@l_RegisteredSiteID;
		insert into WAUrls SELECT DISTINCT @l_RegisteredSiteID, T.col.value('@val','nvarchar(512)')
		FROM @i_ListOfDomains.nodes('DM2ContentIndexing_WARegisterSiteData/listOfDomains') AS T(col);
		SET @o_errorCode=0;
		SET @o_errorMessage='Site successfully updated';
		--Audit site registration
		DECLARE @siteDataMapping TABLE (t_siteProp varchar(128), t_auditString varchar(512))
		INSERT INTO @siteDataMapping
VALUES ('"_aprm"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3602 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) ),
('"_strt"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3603 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_aurl"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3604 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_dns"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3605 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_cref"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3606 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_scls"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3607 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_sprm"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3608 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_surl"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3609 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_loc"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3610 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_name"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3611 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"contentid"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3612 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2))
		DECLARE @siteProp VARCHAR(128)
		DECLARE @auditString VARCHAR(128)
		DECLARE sitePropCur CURSOR FOR
		SELECT t_siteProp, t_auditString FROM @siteDataMapping
		OPEN sitePropCur;
		FETCH NEXT FROM sitePropCur into @siteProp, @auditString
		WHILE @@FETCH_STATUS = 0
		   BEGIN
				SET @i_SiteData =   REPLACE (@i_SiteData, @siteProp, @auditString)
				SET @oldSiteData =   REPLACE (@oldSiteData, @siteProp, @auditString)
				FETCH NEXT FROM sitePropCur into @siteProp, @auditString
		   END
		CLOSE sitePropCur
		DEALLOCATE sitePropCur
		-- SET GUI AUDIT OPERATION
		DECLARE @opEvMsgId          INT
		DECLARE @opId               INT
DECLARE  @opMsgId			INT = (3593 | (CAST(POWER(2, 24) AS BIGINT) * 61))
DECLARE  @paramMsgId 		INT = (3601 | (CAST(POWER(2, 24) AS BIGINT) * 61))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_UserID, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @oldSiteData, 0
		EXEC EvGuiAuditSetParamData @opId, @i_SiteData, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_UserID
		--
	END
ELSE
BEGIN
	SET @o_errorCode=12004;
	SET @o_errorMessage='Some error occurred while updating site';
END
SELECT @o_errorCode,@o_errorMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2WAUpdateSite')
	delete from GxQscripts where name = 'DM2WAUpdateSite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2WAUpdateSite')
	delete from GXDBVersions where aliasname = 'DM2WAUpdateSite'
GO

insert into GXDBVersions values(2, 'DM2WAUpdateSite',  '00010002004200040000', 'DM2WAUpdateSite', '00010002004200040000')
GO

