

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2WAAddSite.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2WAAddSite.sp,v $ $Id: DM2WAAddSite.sp,v 1.2.42.4 2018/03/27 09:06:04 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2WAAddSite <<<'

IF EXISTS (select * from sysobjects where name='DM2WAAddSite')
	drop procedure DM2WAAddSite
IF EXISTS (select * from GxQscripts where name='DM2WAAddSite')
	delete from GxQscripts where name = 'DM2WAAddSite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2WAAddSite')
	delete from GXDBVersions where aliasname = 'DM2WAAddSite'
GO
print '... Creating Procedure: DM2WAAddSite'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2WAAddSite
  @i_UserID int,
  @i_SiteName nvarchar(128),
  @i_GUID varchar(64),
  @i_SiteData nvarchar(max),
  @i_CloudId int,
  @i_CreateTime bigint,
  @i_ModifyTime bigint,
  @i_ListOfDomains xml, 
  @i_Email nvarchar(255),
  @i_localeId INT =0
AS
BEGIN
  DECLARE @o_errorCode integer;
  DECLARE @o_errorMessage varchar(MAX);
  DECLARE @l_RegisteredSiteID integer;
  DECLARE @l_ID integer;
SET NOCOUNT ON
SET @l_RegisteredSiteID=0;
IF EXISTS (select top 1 SiteGUID from WARegisteredSite WITH (READUNCOMMITTED) where SiteGUID = @i_GUID)
BEGIN
	SET @o_errorCode=12001;
	SET @o_errorMessage='GUID is already available';
END
ELSE IF EXISTS  (select top 1 ID from WARegisteredSite WITH (READUNCOMMITTED) where SiteName = @i_SiteName AND UserID=@i_UserID)
BEGIN
	SET @o_errorCode=12006;
	SET @o_errorMessage='Site with the given name is already registered.';
END
ELSE
BEGIN
	insert into WARegisteredSite (UserID,SiteName,SiteGUID,SiteData,CloudId,CreateTime,ModifyTime)
		values (@i_UserID,@i_SiteName, @i_GUID, @i_SiteData,@i_CloudId, @i_CreateTime, @i_ModifyTime);
    select top 1 @l_RegisteredSiteID= ID from WARegisteredSite WITH (READUNCOMMITTED) where SiteGUID= @i_GUID;
	IF (@l_RegisteredSiteID > 0)
	BEGIN
		insert into WARegisteredSitePermission (RegisteredSiteID,Email,UserID,PermissionFlag)
		values (@l_RegisteredSiteID, @i_Email, @i_UserID, 1);
		insert into WAUrls SELECT DISTINCT @l_RegisteredSiteID, T.col.value('@val','nvarchar(512)')
		FROM @i_ListOfDomains.nodes('DM2ContentIndexing_WARegisterSiteData/listOfDomains') AS T(col);
		SET @o_errorCode=0;
		SET @o_errorMessage='Site successfully registered';
		--Audit site registration
		DECLARE @siteDataMapping TABLE (t_siteProp varchar(128), t_auditString varchar(512))
		INSERT INTO @siteDataMapping
VALUES ('"_aprm"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3602 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) ),
('"_strt"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3603 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_aurl"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3604 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_dns"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3605 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_cref"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3606 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_scls"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3607 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_sprm"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3608 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_surl"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3609 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_loc"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3610 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"_name"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3611 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)),
('"contentid"', dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3612 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2))
		DECLARE @siteProp VARCHAR(128)
		DECLARE @auditString VARCHAR(128)
		DECLARE sitePropCur CURSOR FOR
		SELECT t_siteProp, t_auditString FROM @siteDataMapping
		OPEN sitePropCur;
		FETCH NEXT FROM sitePropCur into @siteProp, @auditString
		WHILE @@FETCH_STATUS = 0
		   BEGIN
				SET @i_SiteData =   REPLACE (@i_SiteData, @siteProp, @auditString)
				FETCH NEXT FROM sitePropCur into @siteProp, @auditString
		   END
		CLOSE sitePropCur
		DEALLOCATE sitePropCur
		-- SET GUI AUDIT OPERATION
		DECLARE @opEvMsgId          INT
		DECLARE @opId               INT
DECLARE  @opMsgId			INT = (3592 | (CAST(POWER(2, 24) AS BIGINT) * 61))
DECLARE  @paramMsgId 		INT = (3600 | (CAST(POWER(2, 24) AS BIGINT) * 61))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_UserID, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @i_SiteData, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_UserID
		--
	END
	ELSE
	BEGIN
		SET @o_errorCode=12003;
		SET @o_errorMessage='Some error occurred during site Registration';
	END
END
SELECT @o_errorCode,@o_errorMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2WAAddSite')
	delete from GxQscripts where name = 'DM2WAAddSite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2WAAddSite')
	delete from GXDBVersions where aliasname = 'DM2WAAddSite'
GO

insert into GXDBVersions values(2, 'DM2WAAddSite',  '00010002004200040000', 'DM2WAAddSite', '00010002004200040000')
GO

