

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2ValidateTags.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2ValidateTags()
--  | Description:  Checks if specified Tag Ids or Tag Guids are valid and allows to
--  | 		    Check if user specified has view permission on corresponding TagSet or not.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2ValidateTags.sp,v $ $Id: DM2ValidateTags.sp,v 1.1.2.1 2020/09/11 16:51:38 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2ValidateTags')
BEGIN
	print '>>> Drop Stored Procedure: DM2ValidateTags <<<'
	drop procedure DM2ValidateTags
END
IF EXISTS (select * from GxQscripts where name='DM2ValidateTags')
	delete from GxQscripts where name = 'DM2ValidateTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ValidateTags')
	delete from GXDBVersions where aliasname = 'DM2ValidateTags'
GO
print '... Creating Procedure: DM2ValidateTags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2ValidateTags
  @i_UserId INT,
  @i_TagIds VARCHAR(MAX),
  @i_TagGuids VARCHAR(MAX) = ''
AS
begin
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--
--Tables to be used by SP sec_getObjectsWithPermissionsV2
IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
BEGIN
    DROP TABLE #getObjectsTable
END
--
CREATE TABLE #getObjectsTable (
    entityId INT,
    permissionId INT
);
IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
BEGIN
    DROP TABLE #permissionIdTable
END
--
CREATE TABLE #permissionIdTable (
    permissionId INT
);
INSERT INTO #permissionIdTable
SELECT 31 /* EV_VISIBILITY */
exec sec_getObjectsWithPermissionsV2 @i_UserId, 9504 /* TAG_ENTITY */, 0
DECLARE @tblTags TABLE(TagID INT, TagGUID VARCHAR(36), TagSetID INT default 0, Allowed INT default 0)
DECLARE @tblTagSet TABLE(containerId INT)
INSERT INTO @tblTags(TagID)
SELECT _ID FROM dbo.SplitIDs(@i_TagIds)
INSERT INTO @tblTags(TagGUID)
SELECT _ID FROM dbo.SplitIDString(@i_TagGuids)
UPDATE T
SET TagSetID = C.containerId, T.TagGUID = D.TagID, T.TagID = D.id, Allowed = (CASE WHEN O.permissionId IS NOT NULL THEN 1 ELSE 0 END)
FROM @tblTags T
JOIN DM2DocTags D ON (T.TagID IS NOT NULL AND T.TagID = D.id) OR (T.TagGUID IS NOT NULL AND T.TagGUID = D.TagID)
JOIN DM2Container C ON D.containerGuid = C.containerGuid
LEFT JOIN #getObjectsTable O ON C.containerId = O.entityId
SELECT TagID 'TagId', TagGUID 'id', TagSetID 'containerid', Allowed 'HasAccess' FROM @tblTags
IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
BEGIN
    DROP TABLE #permissionIdTable
END
IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
BEGIN
    DROP TABLE #getObjectsTable
END
end
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'DM2ValidateTags')
	delete from GxQscripts where name = 'DM2ValidateTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ValidateTags')
	delete from GXDBVersions where aliasname = 'DM2ValidateTags'
GO

insert into GXDBVersions values(2, 'DM2ValidateTags',  '00010001000200010000', 'DM2ValidateTags', '00010001000200010000')
GO

