

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2ValidateDDSUser.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2ValidateDDSUser()
--  | Description:  Returns UserGuid if that user already exists for LN User
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2ValidateDDSUser.sp,v $ $Id: DM2ValidateDDSUser.sp,v 1.4.60.4 2019/12/18 22:20:01 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2ValidateDDSUser')
BEGIN
	print '>>> Drop Stored Procedure: DM2ValidateDDSUser <<<'
	drop procedure DM2ValidateDDSUser
END
IF EXISTS (select * from GxQscripts where name='DM2ValidateDDSUser')
	delete from GxQscripts where name = 'DM2ValidateDDSUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ValidateDDSUser')
	delete from GXDBVersions where aliasname = 'DM2ValidateDDSUser'
GO
print '... Creating Procedure: DM2ValidateDDSUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2ValidateDDSUser
  @i_userName nvarchar(255) = N'',
  @i_domainName nvarchar(255) = N'',
  @i_canonicalName NVARCHAR(MAX) = N''
AS
/*
         * Returns the userGuid and canonical name Or the error Object.
         * if the user already logged-in
         *      return the existing userGuid
         * else if new valid user and his details (exists OR doesnt ) in CS
         *      return empty guid (DM2AddUserGuid will insert newGuid)
         * else
         *      return error
         *
		 *		Input  :    loginCanonicalName
		 *		Output :    <UserGuidCanonicalMap>
		 *						  <userInfo userGuid = "XYXYXY[36 dgt]" canonicalName = "canonicalName"/>
		 *						  <errorObj errorCode = "123" errorString = "xyz"/>
		 *					</UserGuidCanonicalMap>
		 **/
DECLARE	@o_userGuid NVARCHAR(36),
		@o_canonicalName NVARCHAR(MAX),
		@o_errorCode int = 0,
		@o_errorString NVARCHAR(MAX)
BEGIN TRY
	IF(LEN(ISNULL(@i_canonicalName,N'')) > 0)
	BEGIN
		-- case when the entry for the input canonicalName exists in UMUsers table BASED ON origUserGuid
			-- return the userGuid and the input canonical name
			SELECT @o_canonicalName =origUserGuid , @o_userGuid = userGuid
				FROM UMUsers WITH(NOLOCK)
			WHERE origUserGuid = @i_canonicalName
		IF ISNULL(@o_userGuid, N'') = N''
		BEGIN
			-- Due to bug in original logic using varchar instead of nvarchar variables, userGUID doesn't get returned from here
			-- for unicode (example chinese) name..
			-- This further impacts sec_ADUserLogin call doesn't receive userguid due to which it overwrites origUserGuid value
			-- For such problematic domino users, this fallback based on as name value in UMUsers should help
			--
			SELECT @o_canonicalName = name, @o_userGuid = userGuid
			FROM UMUsers WITH(NOLOCK)
			WHERE name = @i_canonicalName
		END
		IF ISNULL(@o_userGuid, N'') = N''
		BEGIN
			-- case when entry is not found in UMUsers table.
			--check whether the entry exists in APP_Guid table
			--ie CVD has updated its entries in this table
			IF EXISTS (SELECT distinct T.GUID FROM APP_GUID AS T WITH(NOLOCK) WHERE T.GUID  = @i_canonicalName)
			BEGIN
				--Now we will try to get any old canonical names exists for the inputCanonical name
				DECLARE @tblOldCanonical TABLE (canonicalName NVARCHAR(MAX));
				INSERT INTO @tblOldCanonical
				EXEC DM2GetOldCanonicalNames @i_canonicalName
				-- check if any one of the oldCanonicalName has entry in UMUsers table
				DECLARE @existingUserGuid NVARCHAR(256)
				SELECT @existingUserGuid = userGuid FROM UMUsers WITH(NOLOCK)
				WHERE origUserGuid in (SELECT canonicalName FROM @tblOldCanonical)
				IF (LEN(ISNULL(@existingUserGuid ,N''))>0)
				BEGIN
					--For some oldCanonical name user has logged into the WebUI
					--and his entry exists in the UMUsers table
					--Return the userGuid and input canonicalName exists in UMUSers table
					SELECT @o_canonicalName =@i_canonicalName , @o_userGuid = userGuid FROM UMUsers
					WHERE userGuid = @existingUserGuid
					--we will update the old user with the new logged in user.
					--so that we maintain the same userId and the userGuid but
					-- we will have new login,name,canonicalname
					IF (LEN(ISNULL(@i_userName ,N''))>0)
					BEGIN
						DECLARE @t_userLogIn	NVARCHAR(1024)
						SET @t_userLogIn = @i_userName
						IF @i_domainName <> N''
						BEGIN
							SET @t_userLogIn = (@i_domainName + '\' + @t_userLogIn)
						END
						UPDATE UMUsers SET name = @i_userName,
										login = @t_userLogIn,
										origUserGuid = @i_canonicalName
						WHERE userGuid = @existingUserGuid
					END
				END
				ELSE
				BEGIN
					-- First time user logs in the webUI and its entry already exists in the APP_GUID table
					-- return emptyGuid and the input canonicalName
					-- So the DM2AddUserGuid sp will create newGuid if the input guid is empty..
					SELECT @o_userGuid = N'', @o_canonicalName = @i_canonicalName
				END
			END
			ELSE
			BEGIN
				-- user is valid but the CVD thread has not put its entry in APP_GUID table
				-- So consider him as new user
				SELECT @o_userGuid = N'', @o_canonicalName = @i_canonicalName
			END
		END
	END
	ELSE
	BEGIN
		--Input canonical name is empty
		SELECT @o_userGuid = N'', @o_canonicalName = N''
		SELECT @o_errorCode = 1,
			   @o_errorString = N'Input canonical name is empty'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	--ALSO MAKE THE USERGuid and CanonicalName as empty
	SELECT @o_userGuid = '',@i_canonicalName = ''
	-- Rollback any active or uncommittable transactions
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
SELECT
	@o_userGuid 'userInfo/@userGuid',@o_canonicalName 'userInfo/@canonicalName',
	@o_errorCode 'errorObj/@errorCode',	@o_errorString 'errorObj/@errorString'
FOR XML PATH('UserGuidCanonicalNameMap')
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'DM2ValidateDDSUser')
	delete from GxQscripts where name = 'DM2ValidateDDSUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ValidateDDSUser')
	delete from GXDBVersions where aliasname = 'DM2ValidateDDSUser'
GO

insert into GXDBVersions values(2, 'DM2ValidateDDSUser',  '00010004006000040000', 'DM2ValidateDDSUser', '00010004006000040000')
GO

