

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2UpdateWBAClientOwnersXML.sp] ---------- 

--  +========================================================================+
--  | Name:  DM2UpdateWBAClientOwnersXML
--  | Description: Takes clientId and list of owners and populates the owners table.
--  | In case any owner does not have login already, new user is added to UMUsers table.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2UpdateWBAClientOwnersXML')
BEGIN
	print '>>> Drop Stored Procedure: DM2UpdateWBAClientOwnersXML <<<'
	drop procedure DM2UpdateWBAClientOwnersXML
END
IF EXISTS (select * from GxQscripts where name='DM2UpdateWBAClientOwnersXML')
	delete from GxQscripts where name = 'DM2UpdateWBAClientOwnersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateWBAClientOwnersXML')
	delete from GXDBVersions where aliasname = 'DM2UpdateWBAClientOwnersXML'
GO
print '... Creating Procedure: DM2UpdateWBAClientOwnersXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2UpdateWBAClientOwnersXML
  @i_xmlText XML OUTPUT
AS
BEGIN TRY
	DECLARE  @o_xmlMsg      XML;
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(MAX) = N''
	DECLARE @clientInfo Table (ownerName NVARCHAR(MAX), clientId bigint, ownerType int)
	DECLARE @tempTable TABLE (returnCode INT, errorSTring NVARCHAR(max))
	DECLARE @owners varchar(max)
	DECLARE @clientId bigint
	DECLARE @pos int
	DECLARE @ownername varchar (MAX)
	DECLARE @operationType int = 2 --ADD
	DECLARE @ownerType int = 0
	DECLARE @execUserId int =0
	DECLARE @extAuthUserGroupId int = 0
	DECLARE @isVSA int = 0
	DECLARE @extAuthServer NVARCHAR(1024) = N''
	DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @customDomainXML XML = @i_xmlText
	DECLARE @useUPNForEmail INT =1
	DECLARE @clientTablePreUpdate TABLE (clientId INT, userId INT, userGroupId INT, externalGroupId INT, userName NVARCHAR(MAX), groupName NVARCHAR(MAX))
	DECLARE @clientTablePostUpdate TABLE (clientId INT, userId INT, userGroupId INT, externalGroupId INT, userName NVARCHAR(MAX), groupName NVARCHAR(MAX))
	-- Before anything else, just call AppCreateCustomDomain SP to create domain from below request
	-- for now, we are passing hardoced user id and localeid
	EXEC AppCreateCustomDomains 1, 0, 0, @customDomainXML OUTPUT
	SELECT @errorCode=ref.value('@errorCode', 'INT') ,@errorStr=ref.value('@errorMessage', 'NVARCHAR(1024)')  FROM @customDomainXML.nodes('Api_GenericResp') R ( ref ) WHERE ref.value('@errorCode', 'INT') >0
	IF (@errorCode > 0)
	BEGIN
		-- In case of error just exist. required values are already populated
		GOTO PROC_EXIT
	END
	DECLARE  @adUserInfoTbl TABLE(userId INT DEFAULT (0), reqLoginAlias NVARCHAR(1024), loginAlias NVARCHAR(1024), upn NVARCHAR(1024) DEFAULT '', email NVARCHAR(1024) DEFAULT '', uguid nvarchar(64), uSID nvarchar(128), useUPN INT DEFAULT(0))
	INSERT into @adUserInfoTbl (reqLoginAlias, loginAlias , uguid , upn , email , uSID )
	SELECT ref.value('@loginAlias', 'NVARCHAR(MAX)'), ref.value('@loginAlias', 'NVARCHAR(MAX)'), ref.value('@uGUID', 'NVARCHAR(MAX)'),
			ISNULL(ref.value('@userPrincipalName', 'NVARCHAR(MAX)'), ''), ISNULL(ref.value('@email', 'NVARCHAR(MAX)'), ''),
			CASE WHEN ref.value('@uSID', 'NVARCHAR(MAX)')<>''
				THEN '<App_ADSIDInfo uSID="' + ISNULL(ref.value('@uSID', 'NVARCHAR(MAX)'),'') + '" />'
			ELSE NULL
			END
		FROM @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners/ownerNameADUserInfo') R(ref)
	-- Step 2
	-- For all users for which we have some email or guid, just get the matching login alias for them and update them in our table
	------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppFindDomainUser.spb  ----------
-- Sequence is as per Mr  - https:--engweb.commvault.com/engtools/defect/207409
	-- first check on GUID
	UPDATE ADT
		SET ADT.userId=UU.id, ADT.loginAlias=UU.login
	FROM @adUserInfoTbl ADT
	INNER JOIN UMUsers UU
		ON ((UU.userGuid=ADT.uguid) AND (ADT.uguid <> '') AND (UU.userGuid IS NOT NULL))
	-- Second check on Email
	UPDATE ADT
		SET ADT.userId=UU.id, ADT.loginAlias=UU.login
	FROM @adUserInfoTbl ADT
	INNER JOIN UMUsers UU
		ON ((ADT.email = UU.email) AND (ADT.email <> ''))
	WHERE ADT.userId=0
	-- Third check on UPN
	UPDATE ADT
		SET ADT.userId=UU.id, ADT.loginAlias=UU.login
	FROM @adUserInfoTbl ADT
	INNER JOIN UMUsers UU
		ON (((ADT.upn=UU.email) AND (ADT.upn <> '')) AND @useUPNForEmail=1)
	WHERE ADT.userId=0
	-- Fourth Check for login directly
	UPDATE ADT
		SET ADT.userId=UU.id
	FROM @adUserInfoTbl ADT
	INNER JOIN UMUsers UU
		ON (ADT.loginAlias=UU.login)
	WHERE ADT.userId=0
--- CODE Till HERE IS FROM AppFindDomainUser.spb  ----------
	------------------------------------------------------------------------------------------------------
	-- Step 3
	-- If Login Alias is of deleted one, then lets get the one without it as that will help us later in the SPB
	UPDATE ADT
		SET loginAlias = substring(loginAlias, 1, charindex('(Deleted', loginAlias, 1)-1)
	FROM @adUserInfoTbl ADT
	WHERE loginAlias like '%(Deleted,%'
	INSERT INTO @clientTablePreUpdate
	SELECT AC.id, userId , userGroupId, externalGroupId , UU.login, (SELECT CASE WHEN OT.userGroupId<>0 THEN UG.name
																					WHEN OT.externalGroupId<>0 THEN (UD.domainName+'\'+UG.name)
																					ELSE NULL END)
			FROM @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
			CROSS APPLY cw.nodes('./client') C(cl)
			INNER JOIN APP_Client AC WITH(NOLOCK)
ON AC.id=cl.value('@clientId', 'int') AND (AC.status&0x1000 =0x1000)
			LEFT OUTER JOIN dbo.sec_getClientOwnersExpandUG  OT
				ON OT.clientId=AC.id
			LEFT OUTER JOIN UMUsers UU  WITH(NOLOCK)
				ON UU.id=OT.userId
			LEFT OUTER JOIN UMGroups UG  WITH(NOLOCK)
				ON (UG.id=OT.userGroupId) OR (UG.id=OT.externalGroupId)
			LEFT JOIN UMDSProviders UD  WITH(NOLOCK)
				ON UD.id=UG.umdsProviderId
	DECLARE ClientInfoCursor CURSOR
	FOR
	SELECT  ow.value('@val', 'NVARCHAR(1024)') AS ownerName,
			CASE
				WHEN cl.value('@clientId', 'int')=0
					THEN (SELECT id FROM APP_Client WHERE name=cl.value('@clientName', 'NVARCHAR(1024)'))
				ELSE cl.value('@clientId', 'int') END
				AS clientId
		FROM    @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
		CROSS APPLY cw.nodes('./ownerGroupName') O(ow)
		CROSS APPLY cw.nodes('./client') C(cl)
	OPEN ClientInfoCursor
	FETCH FROM ClientInfoCursor INTO @owners, @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS(SELECT * FROM @clientInfo WHERE clientId = @clientId AND ownerType = 1)
		BEGIN
			UPDATE @clientInfo SET ownerName=ownerName+','+@owners WHERE clientId=@clientId AND ownerType = 1
		END
		ELSE
			INSERT INTO @clientInfo VALUES(@owners, @clientId, 1)
		FETCH FROM ClientInfoCursor INTO @owners, @clientId
	END
	CLOSE ClientInfoCursor
	DEALLOCATE ClientInfoCursor
	DECLARE ClientInfoCursor CURSOR
	FOR
	SELECT  (CASE
				WHEN ADT.loginAlias IS NULL THEN ow.value('@val', 'NVARCHAR(1024)')
				ELSE ADT.loginAlias
				END
				) AS ownerName,
			CASE
				WHEN cl.value('@clientId', 'int')=0
					THEN (SELECT id FROM APP_Client WHERE name=cl.value('@clientName', 'NVARCHAR(1024)'))
				ELSE cl.value('@clientId', 'int') END
				AS clientId
		FROM    @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
		CROSS APPLY cw.nodes('./ownerName') O(ow)
		CROSS APPLY cw.nodes('./client') C(cl)
		LEFT OUTER JOIN @adUserInfoTbl ADT
			ON ADT.reqLoginAlias=ow.value('@val', 'NVARCHAR(1024)')
	OPEN ClientInfoCursor
	FETCH FROM ClientInfoCursor INTO @owners, @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS(SELECT * FROM @clientInfo WHERE clientId = @clientId AND ownerType = 0)
		BEGIN
			UPDATE @clientInfo SET ownerName=ownerName+','+@owners WHERE clientId=@clientId AND ownerType = 0
		END
		ELSE
			INSERT INTO @clientInfo VALUES(@owners, @clientId, 0)
		FETCH FROM ClientInfoCursor INTO @owners, @clientId
	END
	CLOSE ClientInfoCursor
	DEALLOCATE ClientInfoCursor
	SET @isVSA = CASE WHEN EXISTS ( SELECT cw.value('@isVSA', 'int')
									FROM @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw ) WHERE cw.value('@isVSA', 'int') = 1)
				 THEN 1 ELSE 0
				 END
	DECLARE CallSPCursor CURSOR
	FOR SELECT ownerName, clientId, ownerType FROM @clientInfo
	OPEN CallSPCursor
	FETCH FROM CallSPCursor INTO @owners, @clientId, @ownerType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @o_errorCode INT
		DECLARE @o_errorStr NVARCHAR(MAX)
		SET @extAuthServer = ISNULL(( SELECT cw.value('@extAuthServer', 'nvarchar(256)')
                        FROM @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
						CROSS APPLY cw.nodes('./client') C(cl)
						WHERE  cl.value ('@clientId', 'int') = @clientId), '')
		IF  @extAuthServer <> ''
			SET @extAuthUserGroupId = (select top 1 componentnameid from UMGroupsProp where attrName = 'External Authentication URL' and attrVal like '%'+ @extAuthServer +'%' and modified = 0)
--  +========================================================================+
--  | Name:  DM2UpdateWBAClientOwners
--  | Description: Takes clientId and list of owners and populates the UMUserandGroupEntityAssociation table.
--  | If a non-existing AD user is given as client owner, that user will be created(if domain is registered).
--	| If a non-existing simpana user is given, it will be skipped but the valid users will be saved.
--	| If an externally authenticated user (like vcloud user) is given, a user will be created and added to the special user group @extAuthUserGroupId.
--	| All the user entries which were not saved will be returned in o_errorStr with o_errorCode=0(since we should continue in spite of this error)
--  +========================================================================+
    SET ANSI_NULLS ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
     SET @o_errorCode = 0
     SET @o_errorStr = 'Success'
     DECLARE @client_Locked INT= 0
     DECLARE @SecurityModel INT=0
     DECLARE @activated_mode INT=0
     DECLARE @IsInValidClient INT=0
     SELECT @SecurityModel = dbo.isNewSecurity()
     IF @clientId <= 0
         BEGIN
             SET @o_errorCode = 1
             SET @o_errorStr = 'Error:[clientId is wrong]'
     END
         ELSE
     IF NOT EXISTS
     (
         SELECT 1
         FROM App_Client WITH (READUNCOMMITTED)
         WHERE id = @clientId
     )
         BEGIN
             SET @o_errorCode = 1
             SET @o_errorStr = 'Error:[No rows found in App_Client for the given clientId]'
             SET @IsInValidClient=1
     END
         ELSE  -- if clientId is valid
	    BEGIN
		   SET @activated_mode = (ISNULL((SELECT attrval FROM APP_CLIENTPROP WITH(NOLOCK) WHERE componentNameId = @clientId AND
(attrName = 'Activated Mode' ) AND modified = 0),0))
IF @activated_mode = 2 -- SHARED LAPTOP
		    BEGIN
			    SET @o_errorCode = 1
			    SET @o_errorStr = 'Error. Client owner(s) modification is restricted on a shared laptop.'
                SET @IsInValidClient=1
		    END
		ELSE
	     BEGIN
             SET @client_locked = (ISNULL(
                                         (
SELECT CASE attrVal WHEN 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
												ELSE 0
												END
											FROM APP_CLIENTPROP
											WHERE componentNameId = @clientId
AND attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND modified = 0
                                         ), 0))
            IF(@client_locked = 1) AND @o_errorCode = 0
            BEGIN
IF @ownerType = 1
                 BEGIN
                     SET @o_errorCode = 1
                     SET @o_errorStr = 'Error.User group client owner(s) modification is restricted on a locked client.'
                  END
                IF dbo.IsClientOwner(@clientId, @execUserId) = 0
                 BEGIN
                     SET @o_errorCode = 1
                     SET @o_errorStr = 'Error.Only an owner can associate/remove an owner for a locked client.'
                   END
            END
        END
     END   -- 	ELSE   if clientId is valid
     IF @o_errorCode = 0
         BEGIN
           IF(OBJECT_ID('tempdb.dbo.#tOwners') IS NOT NULL)
                 DROP TABLE #tOwners
		    SET @owners = LTRIM(RTRIM(@owners))+','
             SET @pos = CHARINDEX(',', @owners, 1)
          CREATE TABLE #tOwners
			(id               INT IDENTITY(1, 1) PRIMARY KEY ,
			 ownername        NVARCHAR(1024),
			 Domain           NVARCHAR(510),
			 LoginorGroupName NVARCHAR(510),
             ownerEmail		  NVARCHAR(510) DEFAULT '',
			 ProviderID		  INT DEFAULT 0 ,
			 GroupID          INT DEFAULT 0,
			 Errcode          INT DEFAULT 0 ,
			 ErrString        NVARCHAR(max)
			)
			IF REPLACE(@owners, ',', '') <> ''
                 BEGIN
                     WHILE @pos > 0
                         BEGIN
                             SET @ownername = LTRIM(RTRIM(LEFT(@owners, @pos-1)))
                             IF @ownername <> ''
                                AND LEN(@ownername) <> 0
                                 BEGIN
                                     INSERT INTO #tOwners(ownername)
                                 VALUES(@ownername)
                             END
                             SET @owners = RIGHT(@owners, LEN(@owners) - @pos)
                             SET @pos = CHARINDEX(',', @owners, 1)
						 END
				END
             DECLARE @owner NVARCHAR(1024)
             DECLARE @row INT
             DECLARE @userid INT
             DECLARE @groupid INT
             DECLARE @providerId INT
             DECLARE @loginname NVARCHAR(512)
             DECLARE @domainname NVARCHAR(512)
             DECLARE @isExtAuthUser INT= 0
             DECLARE @localUsersGroupId INT=0
       --Delete Owner for Operation type 3
IF(@operationType = 1
                AND @SecurityModel = 1)
                 BEGIN
                          DELETE FROM UMOwners
                         WHERE entityId = @clientId
                               AND entityType = 3
                 END
	 -- Break Down Domain and Username where applicable
             UPDATE #tOwners
               SET
                   Domain = CASE
                                WHEN CHARINDEX('\', ownername) > 0
                                THEN LEFT(ownername, CHARINDEX('\', ownername)-1)
								WHEN ownername like '%_@_%._%'
                                THEN RIGHT(ownername, LEN(ownername)-CHARINDEX('@', ownername, 1))
								ELSE NULL  -- Where Domain does not exists
							END,
                   LoginorGroupName = CASE
                                          WHEN CHARINDEX('\', ownername) > 0
                                          THEN RIGHT(ownername, LEN(ownername)-CHARINDEX('\', ownername, 1))
					  					  WHEN ownername like '%_@_%._%'
					  					  THEN LEFT(ownername, CHARINDEX('@', ownername)-1)
                                          ELSE ownername
                                      END,
		  			ownerEmail = CASE
                                          WHEN ownername like '%_@_%._%'
					  					  THEN ownername
					  					  ELSE ownerEmail
                                      END
									  WHERE ownername is not NULL
	-- update user Domain and LoginorGroupName from email id
		UPDATE #tOwners
		     SET   ownerEmail =TBL.ownername,
                           LoginorGroupName = CASE WHEN provider.id > 0 THEN LEFT(TBL.ownername, CHARINDEX('@', TBL.ownername)-1) ELSE Users.login END,
                           ProviderID = Users.umDSproviderId,
			   			   ownername = CASE WHEN provider.id > 0 THEN ownername ELSE Users.login END,
                           Domain = CASE WHEN provider.id > 0 THEN provider.domainName ELSE NULL END
                     FROM #tOwners TBL
                     INNER JOIN UMUsers Users
                           ON Users.email=TBL.ownername
                     INNER JOIN UMDSProviders provider
                           ON provider.id=Users.umDSproviderId
                     WHERE
                           TBL.ownername like '%_@_%._%'
     -- update saml users Domain and LoginorGroupName  from email id
		UPDATE #tOwners
			SET ownerEmail =TBL.ownername,
                Domain = provider.domainName,
				LoginorGroupName = LEFT(TBL.ownername, CHARINDEX('@', TBL.ownername)-1),
				ProviderID = provider.id
			FROM #tOwners TBL, App_ThirdPartyApp saml, APP_ComponentProp redirect, UMDSProviders provider
			WHERE
				TBL.ownername like '%_@_%._%' and
				(';' + RTRIM(redirect.stringVal) + ';') like ('%;'+ RIGHT(TBL.ownername, LEN(TBL.ownername)-CHARINDEX('@', TBL.ownername, 1))  +';%') and	--searching domain of email in one of the redirect rule
				redirect.componentType = 112 and
				redirect.longVal = saml.id and
				redirect.componentId = provider.id
	 -- update AD usergroups Domain and ProviderID from email id
		UPDATE #tOwners
		     SET ProviderID = UMg.umDSproviderId,
                 Domain = provider.domainName
            FROM #tOwners TBL
            INNER JOIN UMDSGROUPS UMg
                ON UMg.email=TBL.ownername
            INNER JOIN UMDSProviders provider
                ON provider.id=UMg.umDSproviderId
            WHERE
                TBL.ownername IS NOT NULL AND TBL.ownername <>'' AND TBL.ownername like '%_@_%._%' AND TBL.ProviderID = 0
	-- Update Errocode and Error String when a) user is not domain user and is not a valid user in umusers, UmGroups
 UPDATE O            -- Update error for  invalid CV user or group update error string, ignore AD
               SET
                   Errstring = CASE WHEN (o.ownername = o.owneremail) THEN owneremail ELSE LoginorGroupName END,
                   Errcode =  CASE WHEN  isnull(o.domain,'') ='EXT_AUTH_USER' AND  @ownerType=0 THEN 0 ELSE 1 END
             FROM #tOwners O
                  LEFT JOIN UmUsers U ON U.login = o.ownername AND  @ownerType=0
                  LEFT JOIN UmGroups Ug ON Ug.name = o.ownername AND @ownerType=1
  OUTER APPLY
								(SELECT ID FROM UMDSProviders Up   WHERE (Up.domainname = o.Domain OR Up.hostname = o.Domain)
								 UNION
								 SELECT id FROM APP_ADVANCESETTINGS WITH (NOLOCK)
												WHERE entityId = @clientId and keyName = 'sLaptopUserDomain'
												and enabled = 1 and entityType = 3  and cast(value as nvarchar(64)) = o.domain and @ownerType=0
												) Usr
												 WHERE (Usr.Id IS NULL)  and
                  (U.Id IS NULL   AND Ug.id IS NULL)
			SELECT @o_errorCode=@@rowcount          --Supress this error string if Client is locked and
			 IF @o_errorCode>0
				SET   @o_errorStr=null
	--Check if the User belongs to a Group (AD,CV) ,Update Provider for AD Users
             UPDATE #tOwners
               SET
                   ProviderID = ISNUll(u.id,0),
GroupID= CASE WHEN @ownerType = 1 THEN  COALESCE(UgAD.ID,Ugcv.ID) ELSE 0 END
             FROM  #tOwners o
                   LEFT JOIN UMDSProviders U  ON(u.domainname = o.Domain
                                     OR U.hostname = o.Domain)
            	   LEFT JOIN UMGroups UgAD  ON UgAD.Name =o.Loginorgroupname AND UgAD.umdsProviderId = U.ID
                   LEFT JOIN UMGroups Ugcv  ON Ugcv.Name = o.Loginorgroupname AND Ugcv.umdsProviderId =0
             WHERE
                     isnull(Errcode,0) <> 1
	--Set login name for AD users
			UPDATE #tOwners
			SET
				Domain = u.domainname,
				OwnerName = u.domainname + '\' + LoginorGroupName
			FROM  #tOwners o
			    LEFT JOIN UMDSProviders U  ON(u.domainname = o.Domain OR U.hostname = o.Domain)
			WHERE
                o.ProviderID > 0 and isnull(Errcode,0) <> 1
IF @operationType = 3-- 3
                 BEGIN
IF @ownerType = 0
                         BEGIN
                            --FLAG_CLIENT_OWNERS_USERS
                             DELETE Uo
                             FROM UMOwners Uo
                                  JOIN UMUSERS U ON uo.userOrGroupId = u.id
     								   CROSS APPLY ( Select id FROM #tOwners o WHERE  o.ownername = u.login and o.ProviderID>0 And isnull(o.Errcode,0) <> 1
													UNION
												  SELECT id FROM #tOwners o1 WHERE o1.LoginorGroupName = u.login and o1.ProviderID=0 and  isnull(o1.Errcode,0) <> 1	) Owners
                             WHERE entityId = @clientId
                                   AND entityType = 3
                                   AND isUser = 1
                     END
IF @ownerType = 1
                         BEGIN
                             DELETE UO
                             FROM UMOwners UO
                                  JOIN #tOwners o ON UO.userOrGroupId = o.groupid
                             WHERE entityId = @clientId
                                   AND entityType = 3
                                   AND isUser = 0
                                   AND isnull(Errcode,0) <> 1
                     END
                     SET @o_errorCode = 0
                     SET @o_errorStr = 'Success'
             END
                 ELSE --Operation <>3
                 BEGIN   --
IF @ownerType = 0  --Handing user CLIENT_OWNER_USER
					-- IF the AD User Exist re enable the user
                         BEGIN
							 -- Do not update owner password, the password will be validated by corresponding provider depending on the provider type
							 -- Otherwise, this statement updates passwords for organization users as there is no check for provider type.
                             UPDATE UMUsers
                               SET
								[login] = CASE WHEN o.ProviderID=0 THEN O.LoginorGroupName
									ELSE [ownername] END,
                                   flags = 1,
                                   enabled = 1,
                                   --password = '2ALXqLLXNLLX0LLXcLLXxLL', -- pwd='admin'
                                   umDSproviderId = O.providerId
                             FROM UMUsers U , #tOwners O
                             WHERE (u.login like O.ownername+'(Deleted,%' or   U.login=O.OwnerName)
                                   AND ISNULL(Errcode,0) <> 1
                                   AND ISNULL(GroupID,0)=0
								   AND (ISNULL(O.providerId,0)>0 OR   (LEN(O.Domain) >0 and o.ProviderID=0))
                                   AND U.id =
                             (
                                 SELECT MAX(u1.ID)
                                 FROM UMUSERS U1
                                 WHERE U1.[login] = u.[login]
                              )
							--Insert If the AD User that does not exists
                             DECLARE @UserOutputValue TABLE
                             (id             INT PRIMARY KEY ,
                              Name           NVARCHAR(510),
                              umDSproviderId INT
                             )   --reoptimize
                             INSERT INTO UMUsers
                             ([name],
                              [description],
                              [login],
                              [password],
                              [email],
                              [datePasswordSet],
                              [dateExpires],
                              [policy],
                              [enabled],
                              [flags],
                              [modified],
                              [pVer],
                              [Pager],
                              [lastLogInTime],
                              [credSetTime],
                              [umDSproviderId],
                              [userGuid],
                              [origUserGuid]
                             )
                             OUTPUT Inserted.ID,
                                    Inserted.login,
                                    Inserted.UMDSProviderID
                                    INTO @UserOutputValue
                                    SELECT O.LoginorGroupName, --name
                                           'WBA Client Owner', -- description
                                           CASE WHEN o.ProviderID=0 THEN O.LoginorGroupName
																	ELSE [ownername] END , -- owner
                                           '2ALXqLLXNLLX0LLXcLLXxLL', -- password
                                           o.ownerEmail, --email
                                           0, --datePWDset
                                           0, --dateExpires
                                           0, --policy
                                           1, --enabled
                                           1, --flags
                                           0, --modified
                                           0, --pVer
                                           0, --Pager
                                           0, --lastLogInTime
                                           0, --credSetTime
                                           o.providerId, --umDSproviderId
                                           '', --userGUID
                                           '' --origUserGuid)
                                    FROM #tOwners o
                                    WHERE     ISNULL(Errcode,0) <> 1
                                          AND ISNULL(GroupID,0) = 0
                                          AND CHARINDEX('(Deleted,%', ownername , 0) = 0
										  	  AND (ISNULL(O.providerId,0)>0 OR (LEN(O.Domain) >0 and o.ProviderID=0))
                                          AND NOT EXISTS
                                    (
                                        SELECT 1
                                        FROM UMUsers U
                                         WHERE (U.[login] = O.ownername or  (U.umDSproviderId=0  and U.[login]=O.LoginorGroupName  ))
                                    )
                       --Checking for EXT_AUTH_USER
					   IF EXISTS(SELECT id  FROM #tOwners O  WHERE LEN(O.Domain) >0 and o.ProviderID=0)
						BEGIN
							SELECT @localUsersGroupId = id
							FROM UMGROUPS WITH (NOLOCK)
							WHERE name =
							(
								SELECT CAST(value AS NVARCHAR(64))
								FROM APP_ADVANCESETTINGS WITH (NOLOCK)
								WHERE entityId = @clientId
									  AND keyName = 'DefaultUserGroupName'
									  AND enabled = 1
									  AND entityType = 3
							)
							IF @localUsersGroupId >0
							SET @extAuthUserGroupId = @localUsersGroupId
							IF @extAuthUserGroupId>0
								INSERT INTO UMUserGroup
									(userId,
									 groupId,
									 flag
									)
								   SELECT uo.ID,
										  @extAuthUserGroupId,
										  0
								   FROM #tOwners o
									,@UserOutputValue Uo WHERE  UO.[name] = O.LoginorGroupName   AND (LEN(O.Domain) >0 and o.ProviderID=0)
									AND NOT EXISTS
                                    (
                                        SELECT 1
                                        FROM UMUserGroup Ug
                                         WHERE (Ug.userid = uo.id and groupId =@extAuthUserGroupId and flag=0  )
                                    )
						END
                        --Add SAML users to UMUserGroup
						INSERT INTO UMUserGroup
							(
							 userId,
							 groupId,
							 flag
							)
						SELECT temp.userID,temp.groupId,0
						FROM
							(
								SELECT DISTINCT usr.id as userID, UG.id as groupId
									FROM #tOwners O
										INNER JOIN UMUsers usr
											ON O.ownerEmail = usr.email
										INNER JOIN UMDSProviders samlApp
											ON samlApp.id=dbo.AppGetCompanyForProvider(O.ProviderID) AND usr.umdsProviderId=O.ProviderID
										INNER JOIN UMGroups UG
ON UG.umdsProviderId=samlApp.id AND UG.name='Tenant Users'
									WHERE
										o.owneremail IS NOT NULL AND o.owneremail<>'' AND O.ownerEmail like '%_@_%._%'
							) as temp  LEFT OUTER JOIN  UMUserGroup UG ON temp.userID=UG.userId and temp.groupId=UG.groupId
						WHERE UG.userId IS NULL
                        --Check Email Present for Locked Client , if email absent , owner should not be set.
						 IF @client_locked = 1 AND EXISTS(SELECT 1 FROM UMUSERS U JOIN  #tOwners O
															ON U.login = O.ownername WHERE
                                (email = '' or email = 'Email Disabled' or email='No Email' or enabled = 0) and   LEN(Domain) > 0   AND isnull(Errcode,0) <> 1)
							BEGIN
								 UPDATE O
								   SET
									   ErrCode = 1,
									   ErrString = 'Error.User should be enabled and have an email id set to be an owner of a locked client.'
								 FROM #tOwners O
									  JOIN Umusers U ON U.login = O.ownername
														AND isnull(O.GroupID,0) = 0
								 WHERE(U.email = ''
									   OR email = 'Email Disabled'
									   OR email = 'No Email'
									   OR U.enabled = 0)
									  AND @client_locked = 1
									  AND LEN(Domain) > 0
									  AND isnull(Errcode,0) <> 1
							END
					   -- Set Owners , Users
                             IF @SecurityModel = 1
                                 BEGIN
                                     INSERT INTO UMOwners
                                     (entityType,
                                      entityId,
                                      userOrGroupId,
                                      isUser,
                                      authorId
                                     )
                                            SELECT 3,
                                                   @clientId,
                                                   usr.ID,
                                                   1,
                                                   @execUserID
                                            FROM #tOwners O
                                               CROSS APPLY ( Select ID FROM  Umusers U WHERE  U.login = O.ownername and o.ProviderID>0
															 UNION
															 SELECT ID FROM UmUsers U1 WHERE u1.login =o.LoginorGroupName and o.ProviderID=0) Usr
                                                                  -- THis will set  all owners except the ones that dont have email.
                                            WHERE NOT EXISTS
                                            (
                                                SELECT 1
                                                FROM UMOwners WITH (READUNCOMMITTED)
                                                WHERE userOrGroupID = usr.id
                                                      AND isUser = 1
                                                      AND entityId = @clientId
                                                      AND entityType = 3
                                            ) AND isnull(O.GroupID,0) = 0 AND isnull(Errcode,0)<>1
                             END
                     END  -- Owner Type Group
IF @Ownertype = 1 -- Create  Groups (AD Groups)
                         BEGIN
                             DECLARE @GrpOutputValue TABLE
                             (Groupid    INT,
                              ProviderID INT,
                              GroupName  VARCHAR(510)
                             )
                             DELETE FROM @GrpOutputValue
                             INSERT INTO UMGroups
                             (umdsProviderId,
                              groupFlags,
                              allCapabilities,
                              allAssociations,
                              selfAssociation,
                              name,
                              description,
                              email,
                              origCCId,
                              GUID,
                              lastCredSetTime
                             )
                             OUTPUT INSERTED.Id,
                                    INSERTED.umdsProviderID,
                                    INSERTED.name
                                    INTO @GrpOutputValue
                                    SELECT providerid,
                                           1,
                                           0,
                                           0,
                                           1,
                                           LoginorGroupName,
                                           'Added via Client Owners Security',
                                           '',
                                           2,
                                           NEWID(),
                                           0
                                    FROM #tOwners O
                                    WHERE NOT EXISTS
                                    (
                                        SELECT ID
                                        FROM UMGROUPS UG
                                        WHERE UG.umdsProviderId = O.ProviderID
                                              AND Ug.Name = O.LoginorGroupName
                                    )
                                          AND isnull(Errcode,0) <> 1
										  AND isnull(ProviderID,0)>0
								--Insert add AD Groups
                             INSERT INTO UMDSGROUPS
                             (ID,
                              umdsProviderId,
                              enabled,
                              name,
                              description,
                              email,
                              oldid,
                              lastCredSetTime
                             )
                                    SELECT Groupid,
                                           ProviderID,
                                           1,
                                           GroupName,
                                           'Added via Client Owner Security',
                                           '',
                                           0,
                                           0
                                    FROM @GrpOutputValue
				      --SetOwners
                             IF @SecurityModel = 1
                                 BEGIN
                                     INSERT INTO UMOwners
                                     (entityType,
                                      entityId,
                                      userOrGroupId,
                                      isUser,
                                      authorId
                                     )
                                            SELECT 3,
                                                   @clientId,
                                                   u.ID,
                                                   0,
                                                   @execUserID
                                            FROM #tOwners O
                                                 JOIN UMGroups U ON U.name = O.LoginorGroupName  --Asumption All CV and AD groups will have enrtry in umgroups
                                                                       AND U.umdsProviderId=O.ProviderID
                                                                       AND isnull(Errcode,0) <> 1
                                            WHERE NOT EXISTS
                                            (
                                                SELECT 1
                                                FROM UMOwners WITH (READUNCOMMITTED)
                                                WHERE userOrGroupID = u.id
                                                      AND isUser = 0
                                                      AND entityId = @clientId
                                                      AND entityType = 3
                                            )
                             END
                     END
             END
  --This check makes sure that there s atleast owner for a locked client
             IF(@client_locked = 1)
                 BEGIN
                     IF @SecurityModel = 1
                            AND NOT EXISTS
                           (
                               SELECT 1
                               FROM UMOwners
                               WHERE entityId = @clientId
                                     AND entityType = 3
                           )
                         BEGIN
                             SET @o_errorCode = 1
                             SET @o_errorStr = 'Error.Cannot Delete the last owner of a locked client.'
                         END
				END
	 END -- END @o_errorCode = 0
				If @SecurityModel=1 AND @IsInValidClient=0
                 BEGIN
                     DELETE App_SyncCloudConfig
                     WHERE NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = EA.userOrGroupID
                                                                                    AND EA.isUser = 1
                         WHERE entityType = 3
                               AND entityID = clientId
                     ) -- USER
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              INNER JOIN UMUserGroup UM WITH (READUNCOMMITTED) ON EA.userOrGroupId = UM.groupId
                                                                                  AND EA.isUser = 0
                              INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
                         WHERE entityType = 3
                               AND entityId = clientId
                     ) -- USER PART OF INTERNAL GROUP
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              INNER JOIN UMDSGroupMaps GM WITH (READUNCOMMITTED) ON EA.userOrGroupId = GM.umgroupId
                                                                                    AND EA.isUser = 0
                              INNER JOIN UMDSUserGroup UM WITH (READUNCOMMITTED) ON GM.umDSgroupId = UM.groupId
                              INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
                         WHERE entityType = 3
                               AND entityId = clientId
                     ) -- USER PART OF EXTERNAL GROUP LINKED TO INTERNAL GROUP WHICH IS AN OWNER
                         AND EXISTS
                     (
                         SELECT 1
                         FROM App_SyncCloudFolder CF WITH (READUNCOMMITTED)
                         WHERE CF.syncWebFolderId = syncWebFolderId
                     )
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM App_Client C WITH (READUNCOMMITTED)
                         WHERE C.id = clientId
                               AND status&0x10000000 <> 0
                     ) -- Ignore Edge Clients
					 AND NOT EXISTS
                     (
SELECT 1 FROM APP_IDAName I WITH (READUNCOMMITTED) WHERE I.clientId = clientId AND I.appTypeId = 137
                     ) -- Ignore Exchange mailbox share clients
             END
	 IF (@o_errorCode<>0 AND @o_errorStr is null )
	 BEGIN
				SELECT @o_errorStr=COALESCE(@o_errorStr+ ',', '')+Errstring,@o_errorCode=1   FROM  #tOwners O WHERE   isnull(Errcode,0) = 1 order by ID asc
				IF @@CURSOR_ROWS  <>0
				SELECT @o_errorCode=0 -- reset errorcode to handle outside cursor loop
	 END
          IF(OBJECT_ID('tempdb.dbo.#tOwners') IS NOT NULL)
                 DROP TABLE #tOwners
		FETCH FROM CallSPCursor INTO @owners, @clientId, @ownerType
		--SELECT @o_errorCode=returnCode, @o_errorStr=errorSTring  FROM @tempTable
		SET @errorCode = @o_errorCode
		IF @o_errorStr <> 'Success'
			IF @errorStr = ''
				SET @errorStr = @o_errorStr
			ELSE
				SET @errorStr = @errorStr + ',' + @o_errorStr
		IF @o_errorCode <> 0
			BREAK
	END
	CLOSE CallSPCursor
	DEALLOCATE CallSPCursor
	-- Step 4 - Get details of all users for which we didn't have userid earlier, means they were created as part of above SPB
	UPDATE ADT
		SET ADT.userId=UU.id, ADT.loginAlias=UU.login
	FROM @adUserInfoTbl ADT
	INNER JOIN UMUsers UU
		ON UU.login=ADT.loginAlias AND ADT.userId=0
	-- Step 5 - Since, we have userid now, validate user want to use UPN or Email as there primary means of login
	-- If UPN is empty, then keep email even though property is set
	UPDATE ADT
		SET email=upn, useUPN=1
	FROM @adUserInfoTbl ADT
	 INNER JOIN App_CompanyProp ACP
ON ACP.attrName='Use UPN For Email' AND ACP.modified=0 AND ACP.componentNameId=dbo.AppGetCompanyForUserOrUserGroup(ADT.userId, 1) AND ACP.attrVal='1'
	WHERE ADT.upn <> ''
	-- Form 118 in SP12 allows us to set UPN at commcell level in gxglobalParam table.
	-- Form 2549 in SP11 allows us to set UPN at company level in App_companyProp table.
	-- To handle both scenarios we look into the gxglobalparam table for the UPN property only when companyId = 0 and we dont find UPN property set at company level.
	UPDATE ADT
		SET email=upn, useUPN=1
	FROM @adUserInfoTbl ADT
	 INNER JOIN GXGlobalParam GXP
ON GXP.name='Use UPN For Email' AND GXP.modified=0 AND 0 = dbo.AppGetCompanyForUserOrUserGroup(ADT.userId, 1) AND GXP.value='1'
AND NOT EXISTS(SELECT 1 FROM App_CompanyProp ACP WHERE ACP.attrName = 'Use UPN For Email' AND ACP.modified = 0 AND componentNameID = 0)
	WHERE ADT.upn <> ''
	-- Step 6 - Since email field is now mapped with company setting for property - "Use UPN For Email", update UmUsers in case either email or guid is different
	-- MR - https:--engweb.commvault.com/engtools/defect/217113
	-- Don't update any details if user is 1st admin user
	UPDATE UU
	SET UU.email=ADIT.email , UU.userGuid=ADIT.uguid
	FROM UMUsers UU
	INNER JOIN @adUserInfoTbl ADIT
		ON ADIT.userId=UU.id
WHERE (((UU.email<>ADIT.email) AND (ADIT.email <> '')) OR (ADIT.uguid <> UU.userGuid)) AND UU.flags & 0x040 = 0
	-- Step 7 - Update user sid for case where it is not already present in DB.
	INSERT INTO UMUsersProp
SELECT ADIT.userId,'User SID', 1,ADIT.usid, @currentTime, 0
		FROM @adUserInfoTbl ADIT
		LEFT OUTER JOIN UMUsersProp UUP
ON UUP.componentnameid=ADIT.userId AND UUP.attrname='User SID' AND UUP.modified=0
		WHERE UUP.componentnameid IS NULL AND ADIT.userId>0  AND ADIT.usid IS NOT NULL
IF (@isVSA = 1 OR EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'EnableClientOwnerDeletion' AND value = '1' AND modified = 0))
BEGIN
-- Now, remove owners, if any specified.
	delete @clientInfo				-- remove any rows used for adding owners previously
--    IF (OBJECT_ID('tempdb.dbo.#tempRes') IS NOT NULL) --Need to hold result set from [DM2UpdateWBAClientOwners]
--        DROP TABLE #tempRes
--	create table #tempRes (
--        errorCode           int,
--        errorStr            nvarchar(512)
--    )
	DECLARE ClientInfoCursor CURSOR
	FOR
	SELECT  ru.value('@val', 'NVARCHAR(1024)') AS ownerName,
			CASE
				WHEN cl.value('@clientId', 'int')=0
					THEN (SELECT id FROM APP_Client WHERE name=cl.value('@clientName', 'NVARCHAR(1024)'))
				ELSE cl.value('@clientId', 'int') END
				AS clientId
		FROM    @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
		CROSS APPLY cw.nodes('./removeGroups') O(ru)
		CROSS APPLY cw.nodes('./client') C(cl)
	OPEN ClientInfoCursor
	FETCH FROM ClientInfoCursor INTO @owners, @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS(SELECT * FROM @clientInfo WHERE clientId = @clientId AND ownerType = 1)
		BEGIN
			UPDATE @clientInfo SET ownerName=ownerName+','+@owners WHERE clientId=@clientId AND ownerType = 1
		END
		ELSE
			INSERT INTO @clientInfo VALUES(@owners, @clientId, 1)
		FETCH FROM ClientInfoCursor INTO @owners, @clientId
	END
	CLOSE ClientInfoCursor
	DEALLOCATE ClientInfoCursor
	DECLARE ClientInfoCursor CURSOR
	FOR
	SELECT  ru.value('@val', 'NVARCHAR(1024)') AS ownerName,
			CASE
				WHEN cl.value('@clientId', 'int')=0
					THEN (SELECT id FROM APP_Client WHERE name=cl.value('@clientName', 'NVARCHAR(1024)'))
				ELSE cl.value('@clientId', 'int') END
				AS clientId
		FROM    @i_xmlText.nodes('App_SetClientOwnerReq/clientOwners') R ( cw )
		CROSS APPLY cw.nodes('./removeUsers') O(ru)
		CROSS APPLY cw.nodes('./client') C(cl)
	OPEN ClientInfoCursor
	FETCH FROM ClientInfoCursor INTO @owners, @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS(SELECT * FROM @clientInfo WHERE clientId = @clientId AND ownerType = 0)
		BEGIN
			UPDATE @clientInfo SET ownerName=ownerName+','+@owners WHERE clientId=@clientId AND ownerType = 0
		END
		ELSE
			INSERT INTO @clientInfo VALUES(@owners, @clientId, 0)
		FETCH FROM ClientInfoCursor INTO @owners, @clientId
	END
	CLOSE ClientInfoCursor
	DEALLOCATE ClientInfoCursor
	DECLARE CallSPCursor CURSOR
	FOR SELECT ownerName, clientId, ownerType FROM @clientInfo
	OPEN CallSPCursor
	FETCH FROM CallSPCursor INTO @owners, @clientId, @ownerType
	WHILE @@FETCH_STATUS = 0
	BEGIN
        -- INSERT INTO #tempRes
        EXEC DM2UpdateWBAClientOwners_Silent @clientId, @owners, 3, @ownerType --delete
		FETCH FROM CallSPCursor INTO @owners, @clientId, @ownerType
	END
	CLOSE CallSPCursor
	DEALLOCATE CallSPCursor
END
	-- For auditing, get the current state of all clients that are processed
	INSERT INTO @clientTablePostUpdate
	SELECT OT.clientId, OT.userId , OT.userGroupId, OT.externalGroupId , UU.login, (SELECT CASE WHEN OT.userGroupId<>0 THEN UG.name
																					WHEN OT.externalGroupId<>0 THEN (UD.domainName+'\'+UG.name)
																					ELSE NULL END)
		FROM sec_getClientOwnersExpandUG OT
			LEFT OUTER JOIN UMUsers UU  WITH(NOLOCK)
				ON UU.id=OT.userId
			LEFT OUTER JOIN UMGroups UG  WITH(NOLOCK)
				ON (UG.id=OT.userGroupId) OR (UG.id=OT.externalGroupId)
			LEFT JOIN UMDSProviders UD  WITH(NOLOCK)
				ON UD.id=UG.umdsProviderId
	WHERE OT.clientId IN (SELECT clientId FROM  @clientTablePreUpdate CT GROUP BY CT.clientId)
	-- Now Audit changes wherever applicable
	DECLARE @callerId INT =(SELECT TOP 1 UG.userId
	                             FROM UMUserGroup UG WITH(NOLOCK)
	                             INNER JOIN UMGroups G WITH(NOLOCK) ON G.id = UG.groupId
	                             INNER JOIN UMUsers U WITH(NOLOCK) ON U.id = UG.userId
	                             AND G.allAssociations = 1
	                             AND G.allCapabilities = 1
	                             AND G.selfAssociation = 1
	                             AND U.enabled = 1
	                         )
DECLARE @opMsgId            INTEGER = (631 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId          INTEGER
	DECLARE @opId               INTEGER
	DECLARE @paramMsgId         INTEGER
	DECLARE @paramData          NVARCHAR(1024)
	DECLARE @dataIsEvent        INTEGER = 0
	DECLARE @preUserNames       NVARCHAR(MAX)
	DECLARE @preUserGroupNames  NVARCHAR(MAX)
	DECLARE @postUserNames      NVARCHAR(MAX)
	DECLARE @postUserGroupNames NVARCHAR(MAX)
	DECLARE @clientName			NVARCHAR(MAX)
	DECLARE CallAuditCursor CURSOR
	FOR SELECT clientId FROM @clientTablePreUpdate group by clientId
	OPEN CallAuditCursor
	FETCH FROM CallAuditCursor INTO @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @clientName = (SELECT displayName FROM APP_Client  WITH(NOLOCK) where id=@clientId)
		SELECT @preUserNames=ISNULL(STUFF(( SELECT ','+ CT.userName
											FROM @clientTablePreUpdate CT
										FOR XML PATH('')
										),1,1,''), ''),
			@preUserGroupNames = ISNULL(STUFF(( SELECT ','+ CT.groupName
											FROM @clientTablePreUpdate CT
										FOR XML PATH('')
										),1,1,''), '')
		SELECT @postUserNames=ISNULL(STUFF(( SELECT ','+ CT.userName
											FROM @clientTablePostUpdate CT
										FOR XML PATH('')
										),1,1,''), ''),
			@postUserGroupNames = ISNULL(STUFF(( SELECT ','+ CT.groupName
											FROM @clientTablePostUpdate CT
										FOR XML PATH('')
										),1,1,''), '')
		IF (@preUserNames<>@postUserNames)
		BEGIN
				EXEC EvGuiAuditSetOperation @opMsgId, @callerId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1706 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @preUserNames, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @postUserNames, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
		END
		IF (@preUserGroupNames <> @postUserGroupNames)
		BEGIN
				EXEC EvGuiAuditSetOperation @opMsgId, @callerId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1707 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @preUserGroupNames, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @postUserGroupNames, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
END
		FETCH FROM CallAuditCursor INTO @clientId
	END
	CLOSE CallAuditCursor
	DEALLOCATE CallAuditCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	--Close cursor
	IF ( CURSOR_STATUS('global', 'ClientInfoCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'ClientInfoCursor') >= 0 )
	CLOSE ClientInfoCursor
	IF ( CURSOR_STATUS('global','ClientInfoCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','ClientInfoCursor') = -1 )
	DEALLOCATE ClientInfoCursor
	IF ( CURSOR_STATUS('global', 'CallSPCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'CallSPCursor') >= 0 )
	CLOSE CallSPCursor
	IF ( CURSOR_STATUS('global','CallSPCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','CallSPCursor') = -1 )
	DEALLOCATE CallSPCursor
END CATCH
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
PROC_EXIT:
SET @o_xmlMsg = ( SELECT @errorCode '@errorCode', @errorStr '@errorMessage'
FOR XML PATH('App_GenericResp'))
	--SELECT @o_xmlMsg AS [o_xmlMsg]
	SET @i_xmlText = @o_xmlMsg
GO

IF EXISTS (select * from GxQscripts where name = 'DM2UpdateWBAClientOwnersXML')
	delete from GxQscripts where name = 'DM2UpdateWBAClientOwnersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateWBAClientOwnersXML')
	delete from GXDBVersions where aliasname = 'DM2UpdateWBAClientOwnersXML'
GO

insert into GXDBVersions values(2, 'DM2UpdateWBAClientOwnersXML',  '00000000000000000000', 'DM2UpdateWBAClientOwnersXML', '00000000000000000000')
GO

