

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2UpdateWBAClientOwners.sp] ---------- 

   --  +========================================================================+
   --  | Name:  DM2UpdateWBAClientOwners
   --  | Description: Takes clientId and list of owners and populates the UMUserandGroupEntityAssociation table.
   --  | In case any owner does not have login already, new user is added to UMUsers table if he is a valid AD user
   --  +========================================================================+
   SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2UpdateWBAClientOwners')
BEGIN
	print '>>> Drop Stored Procedure: DM2UpdateWBAClientOwners <<<'
	drop procedure DM2UpdateWBAClientOwners
END
IF EXISTS (select * from GxQscripts where name='DM2UpdateWBAClientOwners')
	delete from GxQscripts where name = 'DM2UpdateWBAClientOwners'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateWBAClientOwners')
	delete from GXDBVersions where aliasname = 'DM2UpdateWBAClientOwners'
GO
print '... Creating Procedure: DM2UpdateWBAClientOwners'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2UpdateWBAClientOwners
  @clientId bigint,
  @owners nvarchar(max),
  @operationType int=1,
  @ownerType int=0,
  @execUserId int = 0
-- operationType = OVERRIDE(1), ADD(2), DELETE(3)
-- ownerType =  0 (APPMGR_CLIENT_OWNERS_TYPE::USERS), 1 (APPMGR_CLIENT_OWNERS_TYPE::USER_GROUPS)
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr varchar(255)
	DECLARE @pos int
	DECLARE @ownername nvarchar (1024)
	DECLARE @extAuthUserGroupId int = 0
--  +========================================================================+
--  | Name:  DM2UpdateWBAClientOwners
--  | Description: Takes clientId and list of owners and populates the UMUserandGroupEntityAssociation table.
--  | If a non-existing AD user is given as client owner, that user will be created(if domain is registered).
--	| If a non-existing simpana user is given, it will be skipped but the valid users will be saved.
--	| If an externally authenticated user (like vcloud user) is given, a user will be created and added to the special user group @extAuthUserGroupId.
--	| All the user entries which were not saved will be returned in o_errorStr with o_errorCode=0(since we should continue in spite of this error)
--  +========================================================================+
    SET ANSI_NULLS ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
     SET @o_errorCode = 0
     SET @o_errorStr = 'Success'
     DECLARE @client_Locked INT= 0
     DECLARE @SecurityModel INT=0
     DECLARE @activated_mode INT=0
     DECLARE @IsInValidClient INT=0
     SELECT @SecurityModel = dbo.isNewSecurity()
     IF @clientId <= 0
         BEGIN
             SET @o_errorCode = 1
             SET @o_errorStr = 'Error:[clientId is wrong]'
     END
         ELSE
     IF NOT EXISTS
     (
         SELECT 1
         FROM App_Client WITH (READUNCOMMITTED)
         WHERE id = @clientId
     )
         BEGIN
             SET @o_errorCode = 1
             SET @o_errorStr = 'Error:[No rows found in App_Client for the given clientId]'
             SET @IsInValidClient=1
     END
         ELSE  -- if clientId is valid
	    BEGIN
		   SET @activated_mode = (ISNULL((SELECT attrval FROM APP_CLIENTPROP WITH(NOLOCK) WHERE componentNameId = @clientId AND
(attrName = 'Activated Mode' ) AND modified = 0),0))
IF @activated_mode = 2 -- SHARED LAPTOP
		    BEGIN
			    SET @o_errorCode = 1
			    SET @o_errorStr = 'Error. Client owner(s) modification is restricted on a shared laptop.'
                SET @IsInValidClient=1
		    END
		ELSE
	     BEGIN
             SET @client_locked = (ISNULL(
                                         (
SELECT CASE attrVal WHEN 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
												ELSE 0
												END
											FROM APP_CLIENTPROP
											WHERE componentNameId = @clientId
AND attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND modified = 0
                                         ), 0))
            IF(@client_locked = 1) AND @o_errorCode = 0
            BEGIN
IF @ownerType = 1
                 BEGIN
                     SET @o_errorCode = 1
                     SET @o_errorStr = 'Error.User group client owner(s) modification is restricted on a locked client.'
                  END
                IF dbo.IsClientOwner(@clientId, @execUserId) = 0
                 BEGIN
                     SET @o_errorCode = 1
                     SET @o_errorStr = 'Error.Only an owner can associate/remove an owner for a locked client.'
                   END
            END
        END
     END   -- 	ELSE   if clientId is valid
     IF @o_errorCode = 0
         BEGIN
           IF(OBJECT_ID('tempdb.dbo.#tOwners') IS NOT NULL)
                 DROP TABLE #tOwners
		    SET @owners = LTRIM(RTRIM(@owners))+','
             SET @pos = CHARINDEX(',', @owners, 1)
          CREATE TABLE #tOwners
			(id               INT IDENTITY(1, 1) PRIMARY KEY ,
			 ownername        NVARCHAR(1024),
			 Domain           NVARCHAR(510),
			 LoginorGroupName NVARCHAR(510),
             ownerEmail		  NVARCHAR(510) DEFAULT '',
			 ProviderID		  INT DEFAULT 0 ,
			 GroupID          INT DEFAULT 0,
			 Errcode          INT DEFAULT 0 ,
			 ErrString        NVARCHAR(max)
			)
			IF REPLACE(@owners, ',', '') <> ''
                 BEGIN
                     WHILE @pos > 0
                         BEGIN
                             SET @ownername = LTRIM(RTRIM(LEFT(@owners, @pos-1)))
                             IF @ownername <> ''
                                AND LEN(@ownername) <> 0
                                 BEGIN
                                     INSERT INTO #tOwners(ownername)
                                 VALUES(@ownername)
                             END
                             SET @owners = RIGHT(@owners, LEN(@owners) - @pos)
                             SET @pos = CHARINDEX(',', @owners, 1)
						 END
				END
             DECLARE @owner NVARCHAR(1024)
             DECLARE @row INT
             DECLARE @userid INT
             DECLARE @groupid INT
             DECLARE @providerId INT
             DECLARE @loginname NVARCHAR(512)
             DECLARE @domainname NVARCHAR(512)
             DECLARE @isExtAuthUser INT= 0
             DECLARE @localUsersGroupId INT=0
       --Delete Owner for Operation type 3
IF(@operationType = 1
                AND @SecurityModel = 1)
                 BEGIN
                          DELETE FROM UMOwners
                         WHERE entityId = @clientId
                               AND entityType = 3
                 END
	 -- Break Down Domain and Username where applicable
             UPDATE #tOwners
               SET
                   Domain = CASE
                                WHEN CHARINDEX('\', ownername) > 0
                                THEN LEFT(ownername, CHARINDEX('\', ownername)-1)
								WHEN ownername like '%_@_%._%'
                                THEN RIGHT(ownername, LEN(ownername)-CHARINDEX('@', ownername, 1))
								ELSE NULL  -- Where Domain does not exists
							END,
                   LoginorGroupName = CASE
                                          WHEN CHARINDEX('\', ownername) > 0
                                          THEN RIGHT(ownername, LEN(ownername)-CHARINDEX('\', ownername, 1))
					  					  WHEN ownername like '%_@_%._%'
					  					  THEN LEFT(ownername, CHARINDEX('@', ownername)-1)
                                          ELSE ownername
                                      END,
		  			ownerEmail = CASE
                                          WHEN ownername like '%_@_%._%'
					  					  THEN ownername
					  					  ELSE ownerEmail
                                      END
									  WHERE ownername is not NULL
	-- update user Domain and LoginorGroupName from email id
		UPDATE #tOwners
		     SET   ownerEmail =TBL.ownername,
                           LoginorGroupName = CASE WHEN provider.id > 0 THEN LEFT(TBL.ownername, CHARINDEX('@', TBL.ownername)-1) ELSE Users.login END,
                           ProviderID = Users.umDSproviderId,
			   			   ownername = CASE WHEN provider.id > 0 THEN ownername ELSE Users.login END,
                           Domain = CASE WHEN provider.id > 0 THEN provider.domainName ELSE NULL END
                     FROM #tOwners TBL
                     INNER JOIN UMUsers Users
                           ON Users.email=TBL.ownername
                     INNER JOIN UMDSProviders provider
                           ON provider.id=Users.umDSproviderId
                     WHERE
                           TBL.ownername like '%_@_%._%'
     -- update saml users Domain and LoginorGroupName  from email id
		UPDATE #tOwners
			SET ownerEmail =TBL.ownername,
                Domain = provider.domainName,
				LoginorGroupName = LEFT(TBL.ownername, CHARINDEX('@', TBL.ownername)-1),
				ProviderID = provider.id
			FROM #tOwners TBL, App_ThirdPartyApp saml, APP_ComponentProp redirect, UMDSProviders provider
			WHERE
				TBL.ownername like '%_@_%._%' and
				(';' + RTRIM(redirect.stringVal) + ';') like ('%;'+ RIGHT(TBL.ownername, LEN(TBL.ownername)-CHARINDEX('@', TBL.ownername, 1))  +';%') and	--searching domain of email in one of the redirect rule
				redirect.componentType = 112 and
				redirect.longVal = saml.id and
				redirect.componentId = provider.id
	 -- update AD usergroups Domain and ProviderID from email id
		UPDATE #tOwners
		     SET ProviderID = UMg.umDSproviderId,
                 Domain = provider.domainName
            FROM #tOwners TBL
            INNER JOIN UMDSGROUPS UMg
                ON UMg.email=TBL.ownername
            INNER JOIN UMDSProviders provider
                ON provider.id=UMg.umDSproviderId
            WHERE
                TBL.ownername IS NOT NULL AND TBL.ownername <>'' AND TBL.ownername like '%_@_%._%' AND TBL.ProviderID = 0
	-- Update Errocode and Error String when a) user is not domain user and is not a valid user in umusers, UmGroups
 UPDATE O            -- Update error for  invalid CV user or group update error string, ignore AD
               SET
                   Errstring = CASE WHEN (o.ownername = o.owneremail) THEN owneremail ELSE LoginorGroupName END,
                   Errcode =  CASE WHEN  isnull(o.domain,'') ='EXT_AUTH_USER' AND  @ownerType=0 THEN 0 ELSE 1 END
             FROM #tOwners O
                  LEFT JOIN UmUsers U ON U.login = o.ownername AND  @ownerType=0
                  LEFT JOIN UmGroups Ug ON Ug.name = o.ownername AND @ownerType=1
  OUTER APPLY
								(SELECT ID FROM UMDSProviders Up   WHERE (Up.domainname = o.Domain OR Up.hostname = o.Domain)
								 UNION
								 SELECT id FROM APP_ADVANCESETTINGS WITH (NOLOCK)
												WHERE entityId = @clientId and keyName = 'sLaptopUserDomain'
												and enabled = 1 and entityType = 3  and cast(value as nvarchar(64)) = o.domain and @ownerType=0
												) Usr
												 WHERE (Usr.Id IS NULL)  and
                  (U.Id IS NULL   AND Ug.id IS NULL)
			SELECT @o_errorCode=@@rowcount          --Supress this error string if Client is locked and
			 IF @o_errorCode>0
				SET   @o_errorStr=null
	--Check if the User belongs to a Group (AD,CV) ,Update Provider for AD Users
             UPDATE #tOwners
               SET
                   ProviderID = ISNUll(u.id,0),
GroupID= CASE WHEN @ownerType = 1 THEN  COALESCE(UgAD.ID,Ugcv.ID) ELSE 0 END
             FROM  #tOwners o
                   LEFT JOIN UMDSProviders U  ON(u.domainname = o.Domain
                                     OR U.hostname = o.Domain)
            	   LEFT JOIN UMGroups UgAD  ON UgAD.Name =o.Loginorgroupname AND UgAD.umdsProviderId = U.ID
                   LEFT JOIN UMGroups Ugcv  ON Ugcv.Name = o.Loginorgroupname AND Ugcv.umdsProviderId =0
             WHERE
                     isnull(Errcode,0) <> 1
	--Set login name for AD users
			UPDATE #tOwners
			SET
				Domain = u.domainname,
				OwnerName = u.domainname + '\' + LoginorGroupName
			FROM  #tOwners o
			    LEFT JOIN UMDSProviders U  ON(u.domainname = o.Domain OR U.hostname = o.Domain)
			WHERE
                o.ProviderID > 0 and isnull(Errcode,0) <> 1
IF @operationType = 3-- 3
                 BEGIN
IF @ownerType = 0
                         BEGIN
                            --FLAG_CLIENT_OWNERS_USERS
                             DELETE Uo
                             FROM UMOwners Uo
                                  JOIN UMUSERS U ON uo.userOrGroupId = u.id
     								   CROSS APPLY ( Select id FROM #tOwners o WHERE  o.ownername = u.login and o.ProviderID>0 And isnull(o.Errcode,0) <> 1
													UNION
												  SELECT id FROM #tOwners o1 WHERE o1.LoginorGroupName = u.login and o1.ProviderID=0 and  isnull(o1.Errcode,0) <> 1	) Owners
                             WHERE entityId = @clientId
                                   AND entityType = 3
                                   AND isUser = 1
                     END
IF @ownerType = 1
                         BEGIN
                             DELETE UO
                             FROM UMOwners UO
                                  JOIN #tOwners o ON UO.userOrGroupId = o.groupid
                             WHERE entityId = @clientId
                                   AND entityType = 3
                                   AND isUser = 0
                                   AND isnull(Errcode,0) <> 1
                     END
                     SET @o_errorCode = 0
                     SET @o_errorStr = 'Success'
             END
                 ELSE --Operation <>3
                 BEGIN   --
IF @ownerType = 0  --Handing user CLIENT_OWNER_USER
					-- IF the AD User Exist re enable the user
                         BEGIN
							 -- Do not update owner password, the password will be validated by corresponding provider depending on the provider type
							 -- Otherwise, this statement updates passwords for organization users as there is no check for provider type.
                             UPDATE UMUsers
                               SET
								[login] = CASE WHEN o.ProviderID=0 THEN O.LoginorGroupName
									ELSE [ownername] END,
                                   flags = 1,
                                   enabled = 1,
                                   --password = '2ALXqLLXNLLX0LLXcLLXxLL', -- pwd='admin'
                                   umDSproviderId = O.providerId
                             FROM UMUsers U , #tOwners O
                             WHERE (u.login like O.ownername+'(Deleted,%' or   U.login=O.OwnerName)
                                   AND ISNULL(Errcode,0) <> 1
                                   AND ISNULL(GroupID,0)=0
								   AND (ISNULL(O.providerId,0)>0 OR   (LEN(O.Domain) >0 and o.ProviderID=0))
                                   AND U.id =
                             (
                                 SELECT MAX(u1.ID)
                                 FROM UMUSERS U1
                                 WHERE U1.[login] = u.[login]
                              )
							--Insert If the AD User that does not exists
                             DECLARE @UserOutputValue TABLE
                             (id             INT PRIMARY KEY ,
                              Name           NVARCHAR(510),
                              umDSproviderId INT
                             )   --reoptimize
                             INSERT INTO UMUsers
                             ([name],
                              [description],
                              [login],
                              [password],
                              [email],
                              [datePasswordSet],
                              [dateExpires],
                              [policy],
                              [enabled],
                              [flags],
                              [modified],
                              [pVer],
                              [Pager],
                              [lastLogInTime],
                              [credSetTime],
                              [umDSproviderId],
                              [userGuid],
                              [origUserGuid]
                             )
                             OUTPUT Inserted.ID,
                                    Inserted.login,
                                    Inserted.UMDSProviderID
                                    INTO @UserOutputValue
                                    SELECT O.LoginorGroupName, --name
                                           'WBA Client Owner', -- description
                                           CASE WHEN o.ProviderID=0 THEN O.LoginorGroupName
																	ELSE [ownername] END , -- owner
                                           '2ALXqLLXNLLX0LLXcLLXxLL', -- password
                                           o.ownerEmail, --email
                                           0, --datePWDset
                                           0, --dateExpires
                                           0, --policy
                                           1, --enabled
                                           1, --flags
                                           0, --modified
                                           0, --pVer
                                           0, --Pager
                                           0, --lastLogInTime
                                           0, --credSetTime
                                           o.providerId, --umDSproviderId
                                           '', --userGUID
                                           '' --origUserGuid)
                                    FROM #tOwners o
                                    WHERE     ISNULL(Errcode,0) <> 1
                                          AND ISNULL(GroupID,0) = 0
                                          AND CHARINDEX('(Deleted,%', ownername , 0) = 0
										  	  AND (ISNULL(O.providerId,0)>0 OR (LEN(O.Domain) >0 and o.ProviderID=0))
                                          AND NOT EXISTS
                                    (
                                        SELECT 1
                                        FROM UMUsers U
                                         WHERE (U.[login] = O.ownername or  (U.umDSproviderId=0  and U.[login]=O.LoginorGroupName  ))
                                    )
                       --Checking for EXT_AUTH_USER
					   IF EXISTS(SELECT id  FROM #tOwners O  WHERE LEN(O.Domain) >0 and o.ProviderID=0)
						BEGIN
							SELECT @localUsersGroupId = id
							FROM UMGROUPS WITH (NOLOCK)
							WHERE name =
							(
								SELECT CAST(value AS NVARCHAR(64))
								FROM APP_ADVANCESETTINGS WITH (NOLOCK)
								WHERE entityId = @clientId
									  AND keyName = 'DefaultUserGroupName'
									  AND enabled = 1
									  AND entityType = 3
							)
							IF @localUsersGroupId >0
							SET @extAuthUserGroupId = @localUsersGroupId
							IF @extAuthUserGroupId>0
								INSERT INTO UMUserGroup
									(userId,
									 groupId,
									 flag
									)
								   SELECT uo.ID,
										  @extAuthUserGroupId,
										  0
								   FROM #tOwners o
									,@UserOutputValue Uo WHERE  UO.[name] = O.LoginorGroupName   AND (LEN(O.Domain) >0 and o.ProviderID=0)
									AND NOT EXISTS
                                    (
                                        SELECT 1
                                        FROM UMUserGroup Ug
                                         WHERE (Ug.userid = uo.id and groupId =@extAuthUserGroupId and flag=0  )
                                    )
						END
                        --Add SAML users to UMUserGroup
						INSERT INTO UMUserGroup
							(
							 userId,
							 groupId,
							 flag
							)
						SELECT temp.userID,temp.groupId,0
						FROM
							(
								SELECT DISTINCT usr.id as userID, UG.id as groupId
									FROM #tOwners O
										INNER JOIN UMUsers usr
											ON O.ownerEmail = usr.email
										INNER JOIN UMDSProviders samlApp
											ON samlApp.id=dbo.AppGetCompanyForProvider(O.ProviderID) AND usr.umdsProviderId=O.ProviderID
										INNER JOIN UMGroups UG
ON UG.umdsProviderId=samlApp.id AND UG.name='Tenant Users'
									WHERE
										o.owneremail IS NOT NULL AND o.owneremail<>'' AND O.ownerEmail like '%_@_%._%'
							) as temp  LEFT OUTER JOIN  UMUserGroup UG ON temp.userID=UG.userId and temp.groupId=UG.groupId
						WHERE UG.userId IS NULL
                        --Check Email Present for Locked Client , if email absent , owner should not be set.
						 IF @client_locked = 1 AND EXISTS(SELECT 1 FROM UMUSERS U JOIN  #tOwners O
															ON U.login = O.ownername WHERE
                                (email = '' or email = 'Email Disabled' or email='No Email' or enabled = 0) and   LEN(Domain) > 0   AND isnull(Errcode,0) <> 1)
							BEGIN
								 UPDATE O
								   SET
									   ErrCode = 1,
									   ErrString = 'Error.User should be enabled and have an email id set to be an owner of a locked client.'
								 FROM #tOwners O
									  JOIN Umusers U ON U.login = O.ownername
														AND isnull(O.GroupID,0) = 0
								 WHERE(U.email = ''
									   OR email = 'Email Disabled'
									   OR email = 'No Email'
									   OR U.enabled = 0)
									  AND @client_locked = 1
									  AND LEN(Domain) > 0
									  AND isnull(Errcode,0) <> 1
							END
					   -- Set Owners , Users
                             IF @SecurityModel = 1
                                 BEGIN
                                     INSERT INTO UMOwners
                                     (entityType,
                                      entityId,
                                      userOrGroupId,
                                      isUser,
                                      authorId
                                     )
                                            SELECT 3,
                                                   @clientId,
                                                   usr.ID,
                                                   1,
                                                   @execUserID
                                            FROM #tOwners O
                                               CROSS APPLY ( Select ID FROM  Umusers U WHERE  U.login = O.ownername and o.ProviderID>0
															 UNION
															 SELECT ID FROM UmUsers U1 WHERE u1.login =o.LoginorGroupName and o.ProviderID=0) Usr
                                                                  -- THis will set  all owners except the ones that dont have email.
                                            WHERE NOT EXISTS
                                            (
                                                SELECT 1
                                                FROM UMOwners WITH (READUNCOMMITTED)
                                                WHERE userOrGroupID = usr.id
                                                      AND isUser = 1
                                                      AND entityId = @clientId
                                                      AND entityType = 3
                                            ) AND isnull(O.GroupID,0) = 0 AND isnull(Errcode,0)<>1
                             END
                     END  -- Owner Type Group
IF @Ownertype = 1 -- Create  Groups (AD Groups)
                         BEGIN
                             DECLARE @GrpOutputValue TABLE
                             (Groupid    INT,
                              ProviderID INT,
                              GroupName  VARCHAR(510)
                             )
                             DELETE FROM @GrpOutputValue
                             INSERT INTO UMGroups
                             (umdsProviderId,
                              groupFlags,
                              allCapabilities,
                              allAssociations,
                              selfAssociation,
                              name,
                              description,
                              email,
                              origCCId,
                              GUID,
                              lastCredSetTime
                             )
                             OUTPUT INSERTED.Id,
                                    INSERTED.umdsProviderID,
                                    INSERTED.name
                                    INTO @GrpOutputValue
                                    SELECT providerid,
                                           1,
                                           0,
                                           0,
                                           1,
                                           LoginorGroupName,
                                           'Added via Client Owners Security',
                                           '',
                                           2,
                                           NEWID(),
                                           0
                                    FROM #tOwners O
                                    WHERE NOT EXISTS
                                    (
                                        SELECT ID
                                        FROM UMGROUPS UG
                                        WHERE UG.umdsProviderId = O.ProviderID
                                              AND Ug.Name = O.LoginorGroupName
                                    )
                                          AND isnull(Errcode,0) <> 1
										  AND isnull(ProviderID,0)>0
								--Insert add AD Groups
                             INSERT INTO UMDSGROUPS
                             (ID,
                              umdsProviderId,
                              enabled,
                              name,
                              description,
                              email,
                              oldid,
                              lastCredSetTime
                             )
                                    SELECT Groupid,
                                           ProviderID,
                                           1,
                                           GroupName,
                                           'Added via Client Owner Security',
                                           '',
                                           0,
                                           0
                                    FROM @GrpOutputValue
				      --SetOwners
                             IF @SecurityModel = 1
                                 BEGIN
                                     INSERT INTO UMOwners
                                     (entityType,
                                      entityId,
                                      userOrGroupId,
                                      isUser,
                                      authorId
                                     )
                                            SELECT 3,
                                                   @clientId,
                                                   u.ID,
                                                   0,
                                                   @execUserID
                                            FROM #tOwners O
                                                 JOIN UMGroups U ON U.name = O.LoginorGroupName  --Asumption All CV and AD groups will have enrtry in umgroups
                                                                       AND U.umdsProviderId=O.ProviderID
                                                                       AND isnull(Errcode,0) <> 1
                                            WHERE NOT EXISTS
                                            (
                                                SELECT 1
                                                FROM UMOwners WITH (READUNCOMMITTED)
                                                WHERE userOrGroupID = u.id
                                                      AND isUser = 0
                                                      AND entityId = @clientId
                                                      AND entityType = 3
                                            )
                             END
                     END
             END
  --This check makes sure that there s atleast owner for a locked client
             IF(@client_locked = 1)
                 BEGIN
                     IF @SecurityModel = 1
                            AND NOT EXISTS
                           (
                               SELECT 1
                               FROM UMOwners
                               WHERE entityId = @clientId
                                     AND entityType = 3
                           )
                         BEGIN
                             SET @o_errorCode = 1
                             SET @o_errorStr = 'Error.Cannot Delete the last owner of a locked client.'
                         END
				END
	 END -- END @o_errorCode = 0
				If @SecurityModel=1 AND @IsInValidClient=0
                 BEGIN
                     DELETE App_SyncCloudConfig
                     WHERE NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = EA.userOrGroupID
                                                                                    AND EA.isUser = 1
                         WHERE entityType = 3
                               AND entityID = clientId
                     ) -- USER
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              INNER JOIN UMUserGroup UM WITH (READUNCOMMITTED) ON EA.userOrGroupId = UM.groupId
                                                                                  AND EA.isUser = 0
                              INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
                         WHERE entityType = 3
                               AND entityId = clientId
                     ) -- USER PART OF INTERNAL GROUP
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM UMOwners EA WITH (READUNCOMMITTED)
                              INNER JOIN UMDSGroupMaps GM WITH (READUNCOMMITTED) ON EA.userOrGroupId = GM.umgroupId
                                                                                    AND EA.isUser = 0
                              INNER JOIN UMDSUserGroup UM WITH (READUNCOMMITTED) ON GM.umDSgroupId = UM.groupId
                              INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
                         WHERE entityType = 3
                               AND entityId = clientId
                     ) -- USER PART OF EXTERNAL GROUP LINKED TO INTERNAL GROUP WHICH IS AN OWNER
                         AND EXISTS
                     (
                         SELECT 1
                         FROM App_SyncCloudFolder CF WITH (READUNCOMMITTED)
                         WHERE CF.syncWebFolderId = syncWebFolderId
                     )
                         AND NOT EXISTS
                     (
                         SELECT 1
                         FROM App_Client C WITH (READUNCOMMITTED)
                         WHERE C.id = clientId
                               AND status&0x10000000 <> 0
                     ) -- Ignore Edge Clients
					 AND NOT EXISTS
                     (
SELECT 1 FROM APP_IDAName I WITH (READUNCOMMITTED) WHERE I.clientId = clientId AND I.appTypeId = 137
                     ) -- Ignore Exchange mailbox share clients
             END
	 IF (@o_errorCode<>0 AND @o_errorStr is null )
	 BEGIN
				SELECT @o_errorStr=COALESCE(@o_errorStr+ ',', '')+Errstring,@o_errorCode=1   FROM  #tOwners O WHERE   isnull(Errcode,0) = 1 order by ID asc
				IF @@CURSOR_ROWS  <>0
				SELECT @o_errorCode=0 -- reset errorcode to handle outside cursor loop
	 END
          IF(OBJECT_ID('tempdb.dbo.#tOwners') IS NOT NULL)
                 DROP TABLE #tOwners
	SELECT "ReturnCode"=@o_errorCode,"ErrorString"=@o_errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'DM2UpdateWBAClientOwners')
	delete from GxQscripts where name = 'DM2UpdateWBAClientOwners'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateWBAClientOwners')
	delete from GXDBVersions where aliasname = 'DM2UpdateWBAClientOwners'
GO

insert into GXDBVersions values(2, 'DM2UpdateWBAClientOwners',  '00000000000000000000', 'DM2UpdateWBAClientOwners', '00000000000000000000')
GO

