

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2UpdateSearchServerCoreInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2UpdateSearchServerCoreInfo
--  | Description:  Add new Search Server Core
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2UpdateSearchServerCoreInfo.sp,v $ $Id: DM2UpdateSearchServerCoreInfo.sp,v 1.12.32.8 2020/08/20 15:15:23 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2UpdateSearchServerCoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: DM2UpdateSearchServerCoreInfo <<<'
	drop procedure DM2UpdateSearchServerCoreInfo
END
IF EXISTS (select * from GxQscripts where name='DM2UpdateSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2UpdateSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2UpdateSearchServerCoreInfo'
GO
print '... Creating Procedure: DM2UpdateSearchServerCoreInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2UpdateSearchServerCoreInfo
  @i_ClientId integer,
  @i_CoreId integer,
  @i_CoreName nvarchar(256) = '',
  @i_ServiceLink nvarchar(1000),
  @i_SoftState integer = -1,
  @i_Enabled integer = -1,
  @i_Attributes integer = -1,
  @i_CoreRoles integer = 0,
  @i_CollectionSize bigint = 0,
  @i_FreeSpace bigint = -1,
  @i_OccupiedSpace bigint = 0,
  @i_Description nvarchar(max),
  @i_skippedItems bigint = 0,
  @i_failedItems bigint = 0,
  @i_numFiles bigint = 0,
  @i_numEmails bigint = 0,
  @i_cloudType int = 0,
  @i_totalSpace bigint = 0,
  @i_cloudId int = 0
AS
  DECLARE @o_errorCode INT = 0;
  DECLARE @o_errorString VARCHAR(MAX) = 'Search Server Core Update Successfully';
SET NOCOUNT ON
	DECLARE @CloudId	integer
	DECLARE @CommCellId	integer
	DECLARE @opMsgId INTEGER
	DECLARE @userId INTEGER
	DECLARE @opEvMsgId INTEGER
	DECLARE @opId INTEGER
	DECLARE @paramMsgId INTEGER
	DECLARE @paramData NVARCHAR(max)
	DECLARE @dataIsEvent INTEGER
	IF (@i_CoreId IS NULL OR @i_CoreId <= 0)
	BEGIN
		SELECT
			TOP 1 @i_CoreId = ISNULL(CoreId, 0)
		FROM
			DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
		WHERE
			ClientId = @i_ClientId
AND ((CoreRoles & 8 = 8) OR (CoreRoles & 16 = 16))
			AND cloudType = @i_cloudType
			AND (@i_cloudId =0 OR cloudId = @i_cloudId)
	END
	SELECT	@CloudId = ISNULL(CloudId, 0), @CommCellId = ISNULL(CommCellId, 2)
	FROM	DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
	WHERE	CoreId = @i_CoreId
	IF @CloudId IS NULL OR @CloudId = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Failed to find Search Server Core in database for id [' + CAST(@i_CoreId as varchar(10)) + '] or Client ID [' + CAST(@i_ClientId as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
	IF @i_cloudType = 3  --App_CloudServerType::SearchEngine
	BEGIN
		-- MR 89391 Implement a lock for number of documents to CI per node
		-- Mark node as READ ONLY if freespace < 50% of Index size / node is disabled / Max Doc Limit reached
		DECLARE @freeSpaceLimitToIndexSizePercent INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'FreeSpaceLimitToIndexSizePercent' AND modified =0), 50)
		DECLARE @CIIndexSpaceLimitGB INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'CIIndexSpaceLimitGB' AND modified =0), 10 *1024)  --10 TB default index space limit
		--
		IF ( (@i_CollectionSize + @i_failedItems)  > ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'CINumDocumentMaxLimit' AND modified =0), 30000000))
		OR ( @i_FreeSpace < (@i_OccupiedSpace * @freeSpaceLimitToIndexSizePercent / 100 ))
		OR ( (@i_OccupiedSpace / (1024*1024*1024)) > @CIIndexSpaceLimitGB)
		OR EXISTS ( SELECT coreId FROM DM2SearchServerCoreInfo WHERE CoreId = @i_CoreId and Enabled = 0)
		BEGIN
IF EXISTS ( SELECT coreId FROM DM2SearchServerCoreInfo WHERE CoreId = @i_CoreId and (CoreRoles & 16) = 16)
				begin
				--Remove Index role of search engine which  have reached the MAX doc count limit
				UPDATE	DM2SearchServerCoreInfo
SET		CoreRoles = CoreRoles & (~16)
				WHERE	CoreId = @i_CoreId
				UPDATE APP_ComponentProp
SET longVal = longVal & (~16)
				WHERE propertyTypeId = 1009 AND  modified = 0 AND
					componentId = (SELECT id FROM APP_ComponentProp
									WHERE propertyTypeId = 1008 and longVal = @i_ClientId AND modified = 0)
				-- Set Gui Audit Operation
SET @opMsgId = (439 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				SET @userId = 1
				EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- Set Gui Audit Parameter
SET @paramMsgId = (1166 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = isnull((SELECT name FROM App_Client  WHERE id =@i_ClientId),'')
				SET @dataIsEvent = 0
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				IF ( (@i_CollectionSize + @i_failedItems)  > ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'CINumDocumentMaxLimit' AND modified =0), 30000000))
					EXEC EvGuiAuditSetParamData @opId, 'Max document limit is reached', @dataIsEvent
				ELSE IF ( @i_FreeSpace < (@i_OccupiedSpace * @freeSpaceLimitToIndexSizePercent / 100 ))
					EXEC EvGuiAuditSetParamData @opId, 'Free Space limit is reached', @dataIsEvent
				ELSE IF ((@i_OccupiedSpace / (1024*1024*1024)) > @CIIndexSpaceLimitGB)
					EXEC EvGuiAuditSetParamData @opId, 'CI Index space limit is reached', @dataIsEvent
				ELSE IF EXISTS ( SELECT coreId FROM DM2SearchServerCoreInfo WHERE ClientId = @i_ClientId and Enabled = 0)
					EXEC EvGuiAuditSetParamData @opId, 'Node was disabled', @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
		END
		ELSE
		BEGIN
IF EXISTS ( SELECT coreId FROM DM2SearchServerCoreInfo WHERE CoreId = @i_CoreId and (CoreRoles & 16) = 0)
			begin
				--Add Index role of search engine which have NOT reached the MAX doc count limit
				UPDATE	DM2SearchServerCoreInfo
SET		CoreRoles = (CoreRoles | 16)
				WHERE	CoreId = @i_CoreId
				UPDATE APP_ComponentProp
SET longVal = (longVal | 16)
				WHERE propertyTypeId = 1009 AND  modified = 0 AND
					componentId = (SELECT id FROM APP_ComponentProp
									WHERE propertyTypeId = 1008 and longVal = @i_ClientId AND modified = 0)
				-- Set Gui Audit Operation
SET @opMsgId = (439 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				SET @userId = 1
				EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1167 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = isnull((SELECT name FROM App_Client  WHERE id =@i_ClientId),'')
				SET @dataIsEvent = 0
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			end
		END
		-- Make sure there is only one admin core for each cloud
		IF @i_CoreRoles IS NOT NULL AND @i_CoreRoles != 0
		BEGIN
IF @i_CoreRoles & 4 > 0
			BEGIN
				UPDATE	DM2SearchServerCoreInfo
SET		CoreRoles = CoreRoles & (~4)
				WHERE	CloudId = @CloudId
				AND		CommCellId = @CommCellId
				AND		CoreId != @i_CoreId
			END
			-- Choose a new admin core
ELSE IF @i_CoreRoles & 4 = 0 AND
					EXISTS (SELECT CoreId FROM DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
							WHERE	CoreId = @i_CoreId
AND		CoreRoles & 4 > 0
							)
			BEGIN
					UPDATE	DM2SearchServerCoreInfo
SET		CoreRoles = CoreRoles | 4
					WHERE	CoreID = (
										SELECT
											TOP 1 CoreId
										FROM
											DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
										WHERE
											CoreId != @i_CoreId
										AND		CloudId = @CloudId
										AND		CommCellId = @CommCellId
AND ((CoreRoles & 8 = 8) OR (CoreRoles & 16 = 16))
										ORDER BY
											CollectionSize DESC, OccupiedSpace DESC, FreeSpace
									)
			END
		END
	END
	UPDATE	DM2SearchServerCoreInfo
	SET		CoreName		= CASE WHEN @i_CoreName IS NULL OR LEN(@i_CoreName) = 0 THEN CoreName ELSE @i_CoreName END,
			ServiceLink		= CASE WHEN @i_ServiceLink IS NULL OR LEN(@i_serviceLink) = 0 THEN ServiceLink ELSE @i_ServiceLink END,
			SoftState		= CASE WHEN @i_SoftState IS NULL OR @i_SoftState = -1 THEN SoftState ElSE @i_SoftState END,
			Enabled			= CASE WHEN @i_Enabled IS NULL OR @i_Enabled = -1 THEN Enabled ELSE @i_Enabled END,
			Attributes		= CASE WHEN @i_Attributes IS NULL OR @i_Attributes = -1 THEN Attributes ELSE @i_Attributes END,
			CoreRoles		= CASE WHEN @i_CoreRoles IS NULL OR @i_CoreRoles = 0 THEN CoreRoles ELSE @i_CoreRoles END,
			CollectionSize 	= CASE WHEN @i_CollectionSize IS NULL THEN CollectionSize ELSE @i_CollectionSize END,
			FreeSpace		= CASE WHEN @i_FreeSpace IS NULL OR @i_FreeSpace = 0 THEN FreeSpace ELSE @i_FreeSpace END,
			OccupiedSpace	= CASE WHEN @i_OccupiedSpace IS NULL OR @i_OccupiedSpace = 0 THEN OccupiedSpace ELSE @i_OccupiedSpace END,
			Description		= CASE WHEN @i_Description IS NULL OR LEN(@i_Description) = 0THEN Description ELSE @i_Description END,
			skippedItems	= CASE WHEN @i_skippedItems IS NULL THEN skippedItems ELSE @i_skippedItems END,
			failedItems		= CASE WHEN @i_failedItems IS NULL THEN failedItems ELSE @i_failedItems END,
			numFiles		= CASE WHEN @i_numFiles IS NULL THEN numFiles ELSE @i_numFiles END,
			numEmails		= CASE WHEN @i_numEmails IS NULL THEN numEmails ELSE @i_numEmails END,
			TotalSpace		= CASE WHEN @i_totalSpace IS NULL OR @i_totalSpace = 0 THEN TotalSpace ELSE @i_totalSpace END
	WHERE	CoreId = @i_CoreId
	SELECT @o_errorCode = @@ERROR
	IF @o_errorCode != 0
	BEGIN
		SET @o_errorString = 'Failed to update Search Server Core due to database error [' + CAST(@o_errorCode as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
	SET @o_errorString = 'Search Server Core Update Successfully for ID [' + CAST(@i_CoreId as varchar(10)) + ']'
EXIT_AND_RETURN:
	SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2UpdateSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2UpdateSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2UpdateSearchServerCoreInfo'
GO

insert into GXDBVersions values(2, 'DM2UpdateSearchServerCoreInfo',  '00010012003200080000', 'DM2UpdateSearchServerCoreInfo', '00010012003200080000')
GO

