

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2UpdateLegalHold.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2UpdateLegalHold()
--  | Description:  Update LegalHold
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2UpdateLegalHold.sp,v $ $Id: DM2UpdateLegalHold.sp,v 1.9.88.2 2018/03/27 08:48:20 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2UpdateLegalHold <<<'

IF EXISTS (select * from sysobjects where name='DM2UpdateLegalHold')
	drop procedure DM2UpdateLegalHold
IF EXISTS (select * from GxQscripts where name='DM2UpdateLegalHold')
	delete from GxQscripts where name = 'DM2UpdateLegalHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateLegalHold')
	delete from GXDBVersions where aliasname = 'DM2UpdateLegalHold'
GO
print '... Creating Procedure: DM2UpdateLegalHold'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2UpdateLegalHold
@CompPolicyName 	nvarchar(256),
@CompPolicyDesc	nvarchar(max) = null,
@RetainUntil	 	datetime = null,
@Attribute 			integer = null,
@UserGUID 			varchar(36),
@ModifiedTime		datetime,
@emailIds	nvarchar(max)='',
@flags	integer = null
AS
SET NOCOUNT ON
DECLARE		@CompPolicyID 			varchar(36)
DECLARE		@OldCompPolicyDesc	nvarchar(max)
DECLARE		@OldRetainUntil			datetime
DECLARE		@OldAttribute 			int
DECLARE		@HistoryNotes				nvarchar(max)
DECLARE		@BackupSetId 				int
DECLARE		@pinTime		 				int
DECLARE 	@retentionModified	int
DECLARE		@userId int = null
DECLARE		@legalHoldId INT
DECLARE		@entityType INT = 9505
DECLARE 	@oldFlags	INT
SET @HistoryNotes = ''
SET @pinTime = 0
SET @retentionModified = 1
SET @userId = ( SELECT id FROM UMUsers WHERE userGuid = @UserGUID )
IF ( @userId = 0 OR @userId IS null )
BEGIN
	PRINT 'DM2UpdateLegalHold : Invalid User Name'
	RETURN
END
IF EXISTS (SELECT * FROM DM2CompliancePolicy WHERE CompPolicyName = @CompPolicyName)
BEGIN
	SELECT 	@legalHoldId=id, @CompPolicyID=CompPolicyID, @OldCompPolicyDesc=CompPolicyDesc, @OldRetainUntil=RetainUntil, @OldAttribute=Attribute, @BackupSetId = BackupSetId, @oldFlags = flags
	FROM 		DM2CompliancePolicy
	WHERE 	CompPolicyName = @CompPolicyName
	DECLARE	@o_canEditEntityType int = 0
	EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @userId,
		@i_entityType = @entityType,
		@i_entityId = @legalHoldId,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
	IF ( @o_canEditEntityType <> 1 )
	BEGIN
		PRINT 'User does not have Edit Legal Hold Rights'
		RETURN
	END
	IF (@RetainUntil IS NOT NULL AND CONVERT(CHAR(10), @RetainUntil, 101) <> '12/31/9999' AND DATEPART(YEAR, @RetainUntil) >= 2038)
	BEGIN
		PRINT 'RetainUntil Date not supported.'
		RETURN
	END
	IF @CompPolicyDesc IS NOT null AND @CompPolicyDesc != @OldCompPolicyDesc
		SET @HistoryNotes = @HistoryNotes + 'Modified Description.'
	ELSE
		SET @CompPolicyDesc = @OldCompPolicyDesc
	IF @RetainUntil IS NOT null
	BEGIN
		-- Infinite retention
		IF CONVERT(CHAR(10), @RetainUntil, 101) = '12/31/9999'
			SET	@pinTime = -1
		ELSE IF CONVERT(CHAR(10), @RetainUntil, 101) = '01/01/1900'
			SET	@pinTime = 0
		ELSE
			SET @pinTime = dbo.getUnixTime(dbo.ClientLocalToUTCTime(@RetainUntil, 2))
	END
	ELSE
		SET @pinTime = 0
	IF @RetainUntil IS NOT null AND @OldRetainUntil IS NOT null AND @RetainUntil != @OldRetainUntil
		SET @HistoryNotes = @HistoryNotes + 'Modified Retention - Old Retention Date: ' + CONVERT(VARCHAR(10), @OldRetainUntil, 110) + '.'
	ELSE IF @RetainUntil IS NOT null AND @OldRetainUntil IS null
		SET @HistoryNotes = @HistoryNotes + 'Modified Retention - Old Retention Date: NO RETENTION.'
	ELSE IF @RetainUntil IS null AND @OldRetainUntil IS NOT null
		SET @HistoryNotes = @HistoryNotes + 'Modified Retention - Old Retention Date: ' + CONVERT(VARCHAR(10), @OldRetainUntil, 110) + '.'
	ELSE
	BEGIN
		SET @RetainUntil = @OldRetainUntil
		SET @retentionModified = 0
	END
	IF @Attribute IS NOT null AND @Attribute != @OldAttribute
		SET @HistoryNotes = @HistoryNotes + 'Modified Properties.'
	ELSE
		SET @Attribute = @OldAttribute
	IF @retentionModified = 1
		EXEC archPinLHJobsOnPrimaryCopy @BackupSetId, 0, 0, 0, @pinTime
	--if input flags is null, then use same value in db
	IF @flags IS NULL
		SET @flags = @oldFlags
  UPDATE DM2CompliancePolicy
  SET CompPolicyDesc = @CompPolicyDesc,
  RetainUntil = @RetainUntil,
  Attribute = @Attribute,
  ModifiedTime = @ModifiedTime,
  emailIds = @emailIds,
  flags = @flags
	WHERE 	CompPolicyName = @CompPolicyName
  IF (@HistoryNotes <> '')
  BEGIN
	INSERT INTO DM2CompliancePolicyAudit (CompPolicyID, ModifiedTime, ModifiedUserGUID, Notes)
	VALUES (@CompPolicyID, @ModifiedTime, @UserGUID, @HistoryNotes)
	-- SET GUI AUDIT OPERATION
	DECLARE @opEvMsgId          INT
	DECLARE @opId               INT
DECLARE  @opMsgId			INT = (209 | (CAST(POWER(2, 24) AS BIGINT) * 84))
DECLARE  @paramMsgId 		INT = (412 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- SET GUI AUDIT PARAMETER
	EXEC EvGuiAuditSetParamData @opId, @CompPolicyName, 0
	IF (@OldRetainUntil IS NOT null)
		IF @OldRetainUntil = '12-31-9999'
			EXEC EvGuiAuditSetParamData @opId, 'Infinite', 0
		ELSE
			EXEC EvGuiAuditSetParamData @opId, @OldRetainUntil, 0
	ELSE
		EXEC EvGuiAuditSetParamData @opId, 'Default', 0
	IF (@retainUntil IS NOT null)
		IF @retainUntil = '12-31-9999'
			EXEC EvGuiAuditSetParamData @opId, 'Infinite', 0
		ELSE
			EXEC EvGuiAuditSetParamData @opId, @retainUntil, 0
	ELSE
		EXEC EvGuiAuditSetParamData @opId, 'Default', 0
	EXEC EvGuiAuditSetParamData @opId, @OldCompPolicyDesc, 0
	EXEC EvGuiAuditSetParamData @opId, @CompPolicyDesc, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2UpdateLegalHold')
	delete from GxQscripts where name = 'DM2UpdateLegalHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2UpdateLegalHold')
	delete from GXDBVersions where aliasname = 'DM2UpdateLegalHold'
GO

insert into GXDBVersions values(2, 'DM2UpdateLegalHold',  '00010009008800020000', 'DM2UpdateLegalHold', '00010009008800020000')
GO

