

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2SetCloudIdForReviewSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2SetCloudIdForReviewSet
--  | Description:   Updates cloudid into DM2Container for specified container (review set)
--  |
--  | Input:
--  |			@i_containerGuid: 		containerGUID of container for which cloudid to be updated
--  |			@o_cloudId: 			cloudId to be updated provided no other thread updated it to non zero value
--  |									if some other thread has updated it concurrently to a different value, that value will be fetch and returned using this variable
--  |			@i_containerId			if client program does not know containerGUID and instead it knows the containerId, then this input can be supplied and hence is an optional input
--  |
--  |
--  |Question and answers about this stored procedure
--  |Why don't we use containerGUID in where clause of update statement?
--  |Ans: as there is no index, SQL server may attempt lock all rows in table and cause dead locks
--  |Why ContainerId is preferred in where clause when updating row?
--  |Ans: ContainerId has clustered index and hence only will lock this particular row and help avoid dead locks
--  |Why we are fetching cloudId again some times from DB when it is already supplied as input?
--  |Input cloudId could be ignroed by UPDATE statement in case some other concurrent thread has already updated it to a different non zero value
--  |In that case, we need to read from DB and return cloudId that was updated by other thread for the requested container
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2SetCloudIdForReviewSet <<<'

IF EXISTS (select * from sysobjects where name='DM2SetCloudIdForReviewSet')
	drop procedure DM2SetCloudIdForReviewSet
IF EXISTS (select * from GxQscripts where name='DM2SetCloudIdForReviewSet')
	delete from GxQscripts where name = 'DM2SetCloudIdForReviewSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SetCloudIdForReviewSet')
	delete from GXDBVersions where aliasname = 'DM2SetCloudIdForReviewSet'
GO
print '... Creating Procedure: DM2SetCloudIdForReviewSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2SetCloudIdForReviewSet
  @i_containerGuid char(36),
  @o_cloudId int OUTPUT,
  @i_containerId int = 0
AS
BEGIN
	IF ISNULL(@i_containerId, 0) <= 0
	BEGIN
		SELECT @i_containerId = ContainerId FROM DM2Container WITH(NOLOCK)
		WHERE containerGuid = @i_containerGuid
	END
	UPDATE DM2Container SET cloudId = @o_cloudId WHERE containerId = @i_containerId and cloudId = 0
	IF @@ROWCOUNT = 0
	BEGIN
		SELECT @o_cloudId = CLOUDID FROM DM2Container WITH(NOLOCK) WHERE ContainerId = @i_containerId
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2SetCloudIdForReviewSet')
	delete from GxQscripts where name = 'DM2SetCloudIdForReviewSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SetCloudIdForReviewSet')
	delete from GXDBVersions where aliasname = 'DM2SetCloudIdForReviewSet'
GO

insert into GXDBVersions values(2, 'DM2SetCloudIdForReviewSet',  '00000000000000000000', 'DM2SetCloudIdForReviewSet', '00000000000000000000')
GO

