

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2SearchEngineHealthInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2SearchEngineHealthInfo
--  | Description:  Add new Search Server Core
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2SearchEngineHealthInfo.sp,v $ $Id: DM2SearchEngineHealthInfo.sp,v 1.5.66.1 2018/03/22 02:58:53 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2SearchEngineHealthInfo <<<'

IF EXISTS (select * from sysobjects where name='DM2SearchEngineHealthInfo')
	drop procedure DM2SearchEngineHealthInfo
IF EXISTS (select * from GxQscripts where name='DM2SearchEngineHealthInfo')
	delete from GxQscripts where name = 'DM2SearchEngineHealthInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SearchEngineHealthInfo')
	delete from GXDBVersions where aliasname = 'DM2SearchEngineHealthInfo'
GO
print '... Creating Procedure: DM2SearchEngineHealthInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2SearchEngineHealthInfo
  @i_statsInfoStr NVARCHAR(MAX)
AS
  DECLARE @o_errorCode INT = 0;
  DECLARE @o_errorString VARCHAR(MAX) = 'Search Server Health Information inserted Successfully';
SET NOCOUNT ON
	DECLARE @retentionDays as int
	DECLARE @nowtime as int
	SET @nowtime = dbo.GetUnixTime (GetUTCDate())
	--Delete entries older than 10 days for each client
	SET @retentionDays = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'CV_SOLR_HEALTH_STATS_RETENTION_DAYS'), 10)
	IF @retentionDays < 1
		SET @retentionDays = 1
	DELETE FROM DM2SearchServerhealthInfo WHERE created < (dbo.getunixtime(GETUTCDATE())- @retentionDays*24*60*60)
	--insert rows for client
	INSERT INTO DM2SearchServerhealthInfo (clientId, collectId, attrName, attrType, attrVal, created, modified)
	EXECUTE sp_executeSql @i_statsInfoStr
	SELECT @o_errorCode = @@ERROR
	IF @o_errorCode != 0
	BEGIN
		SET @o_errorString = 'Failed to insert row for Search Server Health info due to database error [' + CAST(@o_errorCode as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
EXIT_AND_RETURN:
	SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2SearchEngineHealthInfo')
	delete from GxQscripts where name = 'DM2SearchEngineHealthInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SearchEngineHealthInfo')
	delete from GXDBVersions where aliasname = 'DM2SearchEngineHealthInfo'
GO

insert into GXDBVersions values(2, 'DM2SearchEngineHealthInfo',  '00010005006600010000', 'DM2SearchEngineHealthInfo', '00010005006600010000')
GO

