

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2SaveCaseInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2SaveCaseInfo()
--  | Description:  Save case information into DM2CaseInfo table.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2SaveCaseInfo.sp,v $ $Id: DM2SaveCaseInfo.sp,v 1.4.60.5 2018/05/09 02:33:11 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2SaveCaseInfo <<<'

IF EXISTS (select * from sysobjects where name='DM2SaveCaseInfo')
	drop procedure DM2SaveCaseInfo
IF EXISTS (select * from GxQscripts where name='DM2SaveCaseInfo')
	delete from GxQscripts where name = 'DM2SaveCaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SaveCaseInfo')
	delete from GXDBVersions where aliasname = 'DM2SaveCaseInfo'
GO
print '... Creating Procedure: DM2SaveCaseInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2SaveCaseInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_CaseName VARCHAR(255),
  @i_CaseNotes NVARCHAR(MAX),
  @i_CaseNumber nvarchar(255),
  @i_RefCopyClientId INT,
  @i_ArchGroupId INT,
  @i_Status INT,
  @i_Flags INT,
  @i_ExtraProps XML,
  @i_SavedBy INT,
  @i_RetentionTime datetime,
  @o_CaseId INT OUTPUT
AS
  DECLARE @o_CaseName NVARCHAR(2048)
  DECLARE @o_EMailId NVARCHAR(1024)
  DECLARE @o_IsAdded INT
  DECLARE @o_IsRemoved INT
BEGIN
	SET NOCOUNT ON
	DECLARE @ErrorCode INT
	DECLARE @ErrorMsg nvarchar(max)
	DECLARE @locCaseId INT
	IF object_id('tempdb.dbo.#tblCaseUserInfo') IS NOT null DROP TABLE #tblCaseUserInfo
	CREATE TABLE #tblCaseUserInfo
	(
		UserGUID NVARCHAR(64), IsAdded int default 1, IsRemoved int default 0,  CaseName NVARCHAR(2048), EMailId NVARCHAR(1024)
	)
	SELECT TOP 1 @locCaseId = CaseId FROM DM2CaseInfo WITH(NOLOCK)
	WHERE (@o_CaseId > 0 AND CaseId = @o_CaseId) OR (ISNULL(@i_CaseName,'')<>'' AND CaseName = @i_CaseName)
	IF @i_RefCopyClientId = 0
		SET @i_RefCopyClientId = NULL
	IF @i_ArchGroupId = 0
		SET @i_ArchGroupId = NULL
	IF @i_RefCopyClientId is not null
	BEGIN
		IF EXISTS (
			SELECT TOP 1 CaseId FROM DM2CaseInfo
			WHERE (@locCaseId = 0 OR (@locCaseId > 0 AND CaseId <> @locCaseId)) AND RefCopyClientId = @i_RefCopyClientId
		)
		BEGIN
			RAISERROR('Reference copy client already associated with different case.', 15, 1)
		END
	END
	ELSE IF ISNULL(@locCaseId, 0) > 0 AND @i_Status = 1
	BEGIN
		-- if case status is open and there is no reference copy client id specified for case in updation, then we have to fail it
		IF EXISTS (SELECT TOP 1 CaseId FROM DM2CaseInfo WHERE CaseId = @locCaseId AND RefCopyClientId IS NOT NULL)
		BEGIN
			RAISERROR('Case cannot have open status with no reference copy client', 15, 1)
		END
	END
	BEGIN TRY
		IF @i_Status <> 4 -- When we delete reference copy client itself, no need to synchronize reviewer users/groups with owner list
		BEGIN
			DECLARE @tblReviewers TABLE (EntityId int, EntityName nvarchar(255), EntityType int, OpType int)
			DECLARE @tblExReviewers TABLE (EntityId int, EntityName nvarchar(255), EntityType int, OpType int)
			INSERT INTO @tblReviewers (EntityId, EntityName, EntityType, OpType)
			SELECT T.ref.value('@userId', 'int') EntityId, T.ref.value('@userName', 'NVARCHAR(256)') EntityName, T.ref.value('@_type_', 'int') EnitityType,
			0 as OpType FROM @i_ExtraProps.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/user') T(ref)
			INSERT INTO @tblReviewers
			SELECT T.ref.value('@userGroupId', 'int') EntityId, T.ref.value('@userGroupName', 'NVARCHAR(256)') EntityName, T.ref.value('@_type_', 'int') EnitityType,
			0 as OpType FROM @i_ExtraProps.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/group') T(ref)
			if(@o_CaseId > 0)
			BEGIN
				;WITH ExistingGroups
				AS
				(
					SELECT T.ref.value('@userGroupId', 'int') UserGroupId, T.ref.value('@userGroupName', 'NVARCHAR(256)') UserGroupName, T.ref.value('@_type_', 'int') EntityType
					FROM DM2CaseInfo C WITH(NOLOCK)
					CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/group') T(ref)
					WHERE C.CaseId = @o_CaseId
				)
				INSERT INTO @tblExReviewers (EntityId, EntityName, EntityType, OpType)
				SELECT EX.UserGroupId, EX.UserGroupName, EX.EntityType, 0 AS OpType FROM ExistingGroups EX
				;WITH ExistingUsers
				AS
				(
					SELECT T.ref.value('@userId', 'int') Userid, T.ref.value('@userName', 'NVARCHAR(256)') userName, T.ref.value('@_type_', 'int') EntityType
					FROM DM2CaseInfo C WITH(NOLOCK)
					CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/user') T(ref)
					WHERE C.CaseId = @o_CaseId
				)
				INSERT INTO @tblExReviewers (EntityId, EntityName, EntityType, OpType)
				SELECT EX.Userid, EX.UserName, EX.EntityType, 0 as OpType FROM ExistingUsers EX
			END
			--
			-- Any reviewer coming in input and not already exists in DB, we will add them as owners on ref copy client
			--
			UPDATE A
			SET OpType = 2 -- Add
			FROM @tblReviewers A
			LEFT JOIN @tblExReviewers B ON A.EntityType = B.EntityType AND A.EntityName = B.EntityName
			WHERE b.EntityName IS NULL
			--
			-- Any reviewer exists in DB but missing in input, we will remove them from owners of ref copy client
			--
			IF @o_CaseId > 0
			BEGIN
				INSERT INTO @tblReviewers (EntityType, EntityId, EntityName, OpType)
				SELECT A.EntityType, A.EntityId, A.EntityName, 3 OpType -- Delete
				FROM @tblExReviewers A
				LEFT JOIN @tblReviewers B ON A.EntityType = B.EntityType AND A.EntityName = B.EntityName
				WHERE B.EntityName IS NULL
			END
			--These rows are unknown to COMMSERV which means set or delete owner operation will fail
			--for now skip them when updating ownership
			--Also these rows will give us a way to consolidate a warning message in future when saving case.
			--
			UPDATE A SET A.OpType = 4 FROM @tblReviewers A WHERE a.EntityId = 0
			--DECLARE @UnknownReviewersToCS nvarchar(max) = ''
			-- collect reviewer names not known to CommServ
			--SELECT @UnknownReviewersToCS = @UnknownReviewersToCS + char(13) + EntityName FROM @tblReviewers WHERE OpType = 4
			-- PRINT 'Following reviewers never registered or logged-into CommCell. Skiping them when setting owners on reference copy client: ' + @UnknownReviewersToCS
			--
			-- Retain records which either needs Add Or Delete owner so that
			-- we can build necessary XML for setting owners
			--
			DELETE @tblReviewers WHERE ISNULL(OpType, 0) NOT IN (2, 3)
			--
			DECLARE @AddOperationXML XML
			DECLARE @DeleteOperationXML XML
			/* Creating necessary XML for Adding or Deleting ownership of partakers on reference copy client, when being added/removed as partakers on the case. */
			IF EXISTS (SELECT 1 FROM @tblReviewers WHERE OpType = 2)
			BEGIN
				SET @AddOperationXML = (
					SELECT
					(
						SELECT OpType '@ownersOperationType',
						(
							SELECT T._TYPE_ AS '@_type_', UserId '@userId', UserName '@userName', userGroupId '@userGroupId', userGroupName '@userGroupName'
							FROM
							(
							SELECT 13 as _type_, EntityId as UserId, EntityName as UserName, NULL AS userGroupId, NULL AS userGroupName FROM @tblReviewers I WHERE I.OpType = 2 AND EntityType  IN (13, 125)
							UNION
							SELECT EntityType as _type_, NULL as UserId, NULL as UserName, EntityId AS userGroupId, EntityName as userGroupName FROM @tblReviewers I WHERE I.OpType = 2 AND EntityType IN (15, 62)
							) T
							FOR XML PATH('owners'), TYPE
						)
						FROM @tblReviewers A
						WHERE A.OpType = 2
						GROUP BY OpType
						FOR XML PATH('ownerAssociations'), TYPE
					)
					FOR XML PATH('App_SecurityAssociationForEntityList')
					)
			END
			--
			IF EXISTS (SELECT 1 FROM @tblReviewers WHERE OpType = 3)
			BEGIN
				SET @DeleteOperationXML = (
					SELECT
					(
						SELECT A.OpType '@ownersOperationType',
						(
							SELECT T._TYPE_ AS '@_type_', UserId '@userId', UserName '@userName', userGroupId '@userGroupId', userGroupName '@userGroupName'
							FROM
							(
							SELECT 13 as _type_, EntityId as UserId, EntityName as UserName, NULL AS userGroupId, NULL AS userGroupName FROM @tblReviewers I WHERE I.OpType = 3 AND EntityType  IN (13, 125)
							UNION
							SELECT EntityType as _type_, NULL as UserId, NULL as UserName, EntityId AS userGroupId, EntityName as userGroupName FROM @tblReviewers I WHERE I.OpType = 3 AND EntityType IN (15, 62)
							) T
							FOR XML PATH('owners'), TYPE
						)
						FROM @tblReviewers A
						WHERE A.OpType = 3
						GROUP BY A.OpType
						FOR XML PATH('ownerAssociations'), TYPE
					)
					FOR XML PATH('App_SecurityAssociationForEntityList')
					)
			END
		END
		/* Creation of ownership XML for sake of partakers done. */
		--
		-- Now, save case information to DM2CaseInfo table
		--
		BEGIN TRAN
	IF ISNULL(@locCaseId, 0) = 0
	BEGIN
		INSERT INTO DM2CaseInfo(CaseName, CaseNotes, CaseNumber, RefCopyClientId, ArchGroupId, Status, Flags, CaseXML, CreateTime, CreatedBy, RetentionDateTime)
		SELECT @i_CaseName, @i_CaseNotes, @i_CaseNumber, @i_RefCopyClientId, @i_ArchGroupId, @i_Status, @i_Flags, @i_ExtraProps, GETUTCDATE(), @i_SavedBy, @i_RetentionTime
		SET @o_CaseId = @@IDENTITY
		--MR 140832: Case Manager reference copy jobs should get picked for Content Indexing automatically
		IF EXISTS (SELECT TOP 1 * FROM archContentIndexingApp WHERE archGroupId = @i_ArchGroupId)
		INSERT INTO archContentIndexingApp (archGroupId, clientId, appTypeId, instanceId, backupSetId, subClientId)
		VALUES (@i_ArchGroupId,@i_RefCopyClientId,0,0,0,0)
	END
	ELSE
	BEGIN
		--STORE previous user guids
		INSERT INTO #tblCaseUserInfo (UserGUID, IsRemoved, IsAdded, EMailId, CaseName)
		SELECT T.ref.value('@userGUID', 'varchar(512)') , 1, 0, T.ref.value('@userName', 'varchar(1024)'), @i_CaseName
		FROM DM2CaseInfo C WITH (NOLOCK)
		CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/userAssets/userOrGroup') T(ref)
		where CaseId = @locCaseId
		UPDATE DM2CaseInfo
		SET CaseName = @i_CaseName, CaseNotes = @i_CaseNotes, CaseNumber = @i_CaseNumber, ArchGroupId = @i_ArchGroupId, CaseXML = @i_ExtraProps,
		ModifiedBy = @i_SavedBy, ModifiedTime = GETUTCDATE(), Status = @i_Status, Flags = @i_Flags, RetentionDateTime = @i_RetentionTime,
		RefCopyClientId = @i_RefCopyClientId
		WHERE CaseId = @locCaseId
		IF @@ROWCOUNT = 0 OR @@ERROR > 0
			SET @o_CaseId = 0
	END
		-- uncomment when needed to debug
		--if @AddOperationXML is not null
		--begin
		--	print 'adding...'
		--	print convert(varchar(max), @AddOperationXML)
		--end
		/*  Case partakers need full permission on the case and be able to do all operations, so set them as owners on reference copy client */--
		IF @AddOperationXML IS NOT NULL
		BEGIN
			exec sec_setSecurityAssociationsFromEntity @AddOperationXML --input XML
			, @i_SavedBy			--logged in user Id
			, 0						--isCommandLineRequest
			, 0						--Skip security check before configuring owners
			, 3						--Entity type (CLIENT_ENTITY)
			, @i_RefCopyClientId    --Entity Id (Client ID)
			, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 -- 0 for non Ida entities. (EntityType / EntityId combo of following Apptype, instance, backupset and subclients)
		END
		-- Uncomment for debugging
		--if @DeleteOperationXML is not null
		--begin
		--	print 'deleting...'
		--	print convert(varchar(max), @DeleteOperationXML)
		--end
		if @DeleteOperationXML is not null
		BEGIN
			exec sec_setSecurityAssociationsFromEntity @DeleteOperationXML --input XML
			, @i_SavedBy			--logged in user Id
			, 0						--isCommandLineRequest
			, 0						--Skip security check before configuring owners
			, 3						--Entity type (CLIENT_ENTITY)
			, @i_RefCopyClientId    --Entity Id (Client ID)
			, 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 -- 0 for non Ida entities. (EntityType / EntityId combo of following Apptype, instance, backupset and subclients)
		END
		/*  Setting permission for Case partakers on reference copy client done */
		--
		-- If we are here with no exception, it means we can commit and make all data updates permanent.
		--
		COMMIT TRAN
	END TRY
	BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMsg = ERROR_MESSAGE(), @ErrorCode = ERROR_NUMBER()
		RAISERROR(@ErrorMsg, 15, 50)
	END CATCH
	IF @i_Status <> 4 --DELETED
	BEGIN
		--compare with newer users list & older users list
		--check if new users are Added or Removed
		MERGE #tblCaseUserInfo DT
		USING
		(
			 SELECT T.ref.value('@userGUID', 'varchar(512)') userGUID, T.ref.value('@userName', 'varchar(512)') emailId, @i_CaseName casename
			FROM DM2CaseInfo C WITH (NOLOCK)
			CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/userAssets/userOrGroup') T(ref)
			where CaseId = @locCaseId OR caseid = @o_CaseId
		) AS TV
		ON  TV.UserGUID = DT.userGUID
		WHEN MATCHED THEN
			  DELETE
		 WHEN NOT MATCHED BY TARGET
					THEN INSERT ([userGUID], emailid, casename )
					VALUES(userGUID, emailid, casename );
	END
	--emailid
	UPDATE #tblCaseUserInfo
	SET EMailId= (CASE when CHARINDEX( '(',EMailId,0) >0 then
				SUBSTRING( EMailId, CHARINDEX( '(',EMailId,0)+1, CHARINDEX( ')',EMailId,0) -CHARINDEX( '(',EMailId,0) -1) else EMailId end)
	--OUTPUT
	SELECT CaseName, EMailId, IsAdded, IsRemoved
	FROM  #tblCaseUserInfo
	IF object_id('tempdb.dbo.#tblCaseUserInfo') IS NOT null DROP TABLE #tblCaseUserInfo
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2SaveCaseInfo')
	delete from GxQscripts where name = 'DM2SaveCaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2SaveCaseInfo')
	delete from GXDBVersions where aliasname = 'DM2SaveCaseInfo'
GO

insert into GXDBVersions values(2, 'DM2SaveCaseInfo',  '00010004006000050000', 'DM2SaveCaseInfo', '00010004006000050000')
GO

