

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2ResetArchFileStatusByOperationType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: Bhushan Kharabe
--  Date:   07/18/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2ResetArchFileStatusByOperationType.sp,v $ $Id: DM2ResetArchFileStatusByOperationType.sp,v 1.1.2.1 2018/08/13 16:12:47 bkharabe Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2ResetArchFileStatusByOperationType <<<'

IF EXISTS (select * from sysobjects where name='DM2ResetArchFileStatusByOperationType')
	drop procedure DM2ResetArchFileStatusByOperationType
IF EXISTS (select * from GxQscripts where name='DM2ResetArchFileStatusByOperationType')
	delete from GxQscripts where name = 'DM2ResetArchFileStatusByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ResetArchFileStatusByOperationType')
	delete from GXDBVersions where aliasname = 'DM2ResetArchFileStatusByOperationType'
GO
print '... Creating Procedure: DM2ResetArchFileStatusByOperationType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2ResetArchFileStatusByOperationType
  @inputXML XML
AS
DECLARE @outputXML XML
DECLARE @clientId INT
DECLARE @appTypeId INT
DECLARE @opType INT
DECLARE @bitmap INT
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
BEGIN TRANSACTION
BEGIN TRY
    SELECT @clientId = ISNULL(T.c.value('@clientId', 'int'), 0),
        @appTypeId = ISNULL(T.c.value('@appTypeId', 'int'), 0),
        @opType = ISNULL(T.c.value('@opType', 'int'), 0)
    FROM   @inputXML.nodes('/DM2ContentIndexing_ResetArchFileStatusByOperationTypeReq[1]') T(c)
    IF @clientId = 0 OR @appTypeId = 0 OR @opType = 0
    BEGIN
        SET @errorCode = 2
        SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', N'Invalid input.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
        GOTO SP_EXIT
    END
IF @opType = 1
    BEGIN
SET @bitmap = (~496) --CVA_AF_CI_RESET_BITMAP
    END
ELSE IF @opType = 2
    BEGIN
SET @bitmap = (~251658240) --CVA_AF_EE_RESET_BITMAP
    END
    ELSE
    BEGIN
        SET @errorCode = 2
        SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', N'Invalid operation type.' AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
        GOTO SP_EXIT
    END
    IF object_id('tempdb.dbo.#tmpSubClientWithLatestCycle') IS NOT null DROP TABLE #tmpSubClientWithLatestCycle
        create table #tmpSubClientWithLatestCycle(
            appId                  int ,
            commcellId                int,
            latestCycle               int)
    IF object_id('tempdb.dbo.#tmpJobsToBePickedInLatestCycle') IS NOT null DROP TABLE #tmpJobsToBePickedInLatestCycle
        create table #tmpJobsToBePickedInLatestCycle(
            jobId                  int ,
            commcellId                int)
    INSERT INTO #tmpSubClientWithLatestCycle
    SELECT distinct SC.id, sc.origCCId, 0
    FROM APP_Application SC WITH (NOLOCK)
    WHERE SC.clientId = @clientId AND SC.appTypeId = @appTypeId AND SC.origCCId = 2
    DELETE #tmpSubClientWithLatestCycle
    FROM #tmpSubClientWithLatestCycle SC, APP_SubClientProp SP WITH (NOLOCK)
    WHERE SC.appId = SP.componentNameId
     AND SP.attrName IN ('DDB Backup', 'Index SubClient')
     AND SP.attrVal = '1'
     AND SP.modified = 0
    UPDATE SC
        SET latestCycle = M.fullCycleNum
    FROM
    (SELECT SC.appId, SC.commcellId, J.fullCycleNum, RANK()
    OVER (PARTITION BY J.appId ORDER BY J.fullCycleNum  DESC) N
    FROM JMBkpStats J WITH (NOLOCK)
	INNER JOIN  JMJobDataStats JDS WITH (NOLOCK)
	ON J.jobId = JDS.jobId AND J.commcellId = JDS.commcellId  AND JDS.disabled & 256 = 0
    INNER JOIN #tmpSubClientWithLatestCycle SC WITH (NOLOCK)
    ON J.appId = SC.appId AND J.status in (1, 3, 14) /* JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
	AND J.dataStatus = 0 AND J.bkpLevel IN (1, 64)
    )M
    INNER JOIN #tmpSubClientWithLatestCycle SC
    ON M.N = 1 AND SC.appId = M.appId AND SC.commcellId = M.commcellId
    INSERT  INTO #tmpJobsToBePickedInLatestCycle
    SELECT J.jobId, J.commcellId
    FROM #tmpSubClientWithLatestCycle SC
    INNER JOIN JMBkpStats J WITH (NOLOCK)
    ON SC.appId = J.appId AND SC.commcellId = J.commCellId AND SC.latestCycle = J.fullCycleNum
    UPDATE AF
        SET flags = (flags & @bitmap)
    FROM #tmpJobsToBePickedInLatestCycle J
    INNER JOIN archFile AF
    ON J.jobId = AF.jobId
    AND J.commcellId = AF.commCellId AND AF.isValid = 1 AND AF.fileType = 1
    IF object_id('tempdb.dbo.#tmpSubClientWithLatestCycle') IS NOT null DROP TABLE #tmpSubClientWithLatestCycle
    IF object_id('tempdb.dbo.#tmpJobsToBePickedInLatestCycle') IS NOT null DROP TABLE #tmpJobsToBePickedInLatestCycle
    -- return success response
    SELECT @outputXML = (SELECT 0 AS N'@errorCode', NULL AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
    SELECT @outputXML = (SELECT @errorCode AS N'@errorCode', @errorString AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
END CATCH
SP_EXIT:
IF @errorCode = 0
BEGIN
    COMMIT TRANSACTION
END
ELSE
BEGIN
    ROLLBACK TRANSACTION
END
SELECT @outputXML;
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'DM2ResetArchFileStatusByOperationType')
	delete from GxQscripts where name = 'DM2ResetArchFileStatusByOperationType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ResetArchFileStatusByOperationType')
	delete from GXDBVersions where aliasname = 'DM2ResetArchFileStatusByOperationType'
GO

insert into GXDBVersions values(2, 'DM2ResetArchFileStatusByOperationType',  '00010001000200010000', 'DM2ResetArchFileStatusByOperationType', '00010001000200010000')
GO

