

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformTagOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformTagOperation()
--  | Description:  Performs operations on Tag (ADD,DISABLE,UPDATE, ...)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformTagOperation.sp,v $ $Id: DM2PerformTagOperation.sp,v 1.19.60.5 2020/08/18 21:46:07 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformTagOperation')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformTagOperation <<<'
	drop procedure DM2PerformTagOperation
END
IF EXISTS (select * from GxQscripts where name='DM2PerformTagOperation')
	delete from GxQscripts where name = 'DM2PerformTagOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformTagOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformTagOperation'
GO
print '... Creating Procedure: DM2PerformTagOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformTagOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_operation		INT
	DECLARE @i_tagValue			NVARCHAR(255)
	DECLARE @i_tagDesc			NVARCHAR(MAX)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @i_tagID			VARCHAR(36)
	DECLARE @i_containerGuid	VARCHAR(36)
	DECLARE @i_UserGuid			VARCHAR(36)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opMsgId			INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @i_id					INT
	DECLARE @c_id					INT
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @ownerIdTable TABLE ( t_userId int)
	DECLARE @isOwner INT = 0
DECLARE @entityType INT = 9504
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @i_containerGuid = ''
BEGIN TRY
BEGIN TRAN
	--USE ADMIN AS DEFAULT ID
	SET	@i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_TagOperationReq') R(ref)), '')
	IF ( @i_userGUID IS NOT null AND @i_userGUID <> '' )
	BEGIN
		SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
	END
	ELSE IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_capability = 27
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq') R ( ref ) ), 0)
	SET @i_tagValue = ISNULL(( SELECT ref.value('@name', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq/tag') R ( ref ) ), '')
	SET @i_tagDesc = ISNULL(( SELECT ref.value('@description', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq/tag') R ( ref ) ), '')
	SET @i_tagID = ISNULL(( SELECT ref.value('@id', 'nvarchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq/tag') R ( ref ) ), '')
	SET @i_id = ISNULL(( SELECT ref.value('@tagId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq/tag') R ( ref ) ), 0)
	SET @i_containerGuid = ISNULL(( SELECT ref.value('@containerGuid', 'varchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagOperationReq/container') R ( ref ) ), '')
	SET @c_id = ISNULL((SELECT containerId FROM DM2Container WHERE containerGuid = @i_containerGuid), 0)
	INSERT INTO @t_userCaps
	EXECUTE GetUserCapabilities @i_userId
	SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
	-- Keep things simple going forward
	-- No tag managemnet, don't allow add/delete/edit tag operations
	--
IF (@userCaps & CONVERT(bigint, (POWER(2.0, 27-1))) = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User need to have Tag management rights.'
		GOTO EXIT_ERROR
	END
	-- Further if user owner or admin or if appropriate sharing capability on the container or tagset exists, then allow operation
	--
	DECLARE @canManageEntityType int = 0
	DECLARE @isAdmin int = 0
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
	SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @c_id)
	-- Owners or admin we allow operation
	if (@isAdmin = 1 OR @isOwner = 1)
	begin
		SET @canManageEntityType = 1
	end
	else
	begin
		if @i_operation = 2 -- Delete
			set @i_capability = 35 -- delete capability
		else -- if operation is Add / Modify / Disable / Enable / Hide / UnHide Tag
			set @i_capability = 34 -- add/append capability
		EXECUTE dbo.sec_checkPermissionOnEntity @userId = @i_userId, @permissionIdList = @i_capability, @isAllowed = @canManageEntityType output,
		@entityType1 = @entityType, @entityId1 = @c_id
	end
	IF ( @canManageEntityType <> 1 )
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have necessary rights'
		GOTO EXIT_ERROR
	END
	IF ( @i_operation = 1 )	--ADD
	BEGIN
		IF LEN(@i_containerGuid) = 0
		BEGIN
			SET @o_errorCode = 8
			SET @o_errorString = 'containerGuid not specified'
			GOTO EXIT_ERROR
		END
		--CHECK FOR TAG ALREADY EXISTING
		IF EXISTS(SELECT * FROM DM2DocTags WHERE TagValue = @i_tagValue AND containerGuid = @i_containerGuid)
		BEGIN
			SET @o_errorCode = 7
			SET @o_errorString = 'Tag already exists'
			GOTO EXIT_ERROR
		END
		SET @i_tagID = NEWID()
		INSERT INTO DM2DocTags (TagID, TagValue, TagDesc, CreatedBy, Attribute, ownerUserId, containerGuid)
		VALUES (@i_tagID, @i_tagValue, @i_tagDesc, @i_UserName, 0x0000, @i_userId, @i_containerGuid)
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			DECLARE @categoryValue NVARCHAR(255)
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (190 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_tagDesc, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_UserName, @dataIsEvent
			SET @paramMsgId = (399 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 3	--MODIFY
	BEGIN
		DECLARE @oldDesc NVARCHAR(MAX)
		IF ISNULL(@i_tagID, '') = ''
		BEGIN
			IF ISNULL(@i_id, 0) = 0
			BEGIN
			    SET @o_errorCode = 3
			    SET @o_errorString = 'Missing tag id during modify operation'
			    GOTO EXIT_ERROR
			END
			ELSE
			BEGIN
				SELECT @i_tagID = TAGID FROM DM2DocTags WHERE id = @i_id
			END
		END
		--THIS ERROR SHOULD NOT HAPPEN
		IF (NOT EXISTS (SELECT * FROM DM2DocTags WHERE TagID = @i_tagID))
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorString = 'Tag id not found during modify operation'
			GOTO EXIT_ERROR
		END
		SET @oldDesc = (SELECT TagDesc FROM DM2DocTags WHERE TagID = @i_tagID)
		UPDATE DM2DocTags SET TagDesc = @i_tagDesc, TagValue = CASE WHEN ISNULL(@i_tagValue, '') <> '' AND Attribute & 2 = 0 THEN @i_tagValue ELSE TagValue END WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (191 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldDesc, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_tagDesc, @dataIsEvent
			SET @paramMsgId = (400 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 4	--DISABLE
	BEGIN
		IF @i_tagID = ''
		BEGIN
			SET @o_errorCode = 4
			SET @o_errorString = 'Missing tag id during disable operation'
			GOTO EXIT_ERROR
		END
UPDATE DM2DocTags SET Attribute = Attribute|CAST(0x0008 as INT) WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (195 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			SET @paramMsgId = (403 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 5	--ENABLE
	BEGIN
		IF @i_tagID = ''
		BEGIN
			SET @o_errorCode = 5
			SET @o_errorString = 'Missing tag id during enable operation'
			GOTO EXIT_ERROR
		END
UPDATE DM2DocTags SET Attribute = (Attribute & ~CAST(0x0008 as INT)) WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (194 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			SET @paramMsgId = (404 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 6	--CLONE
	BEGIN
		DECLARE @cloningTag	NVARCHAR(255)
		IF @i_tagID = ''
		BEGIN
			SET @o_errorCode = 6
			SET @o_errorString = 'Missing tag id during clone operation'
			GOTO EXIT_ERROR
		END
		INSERT INTO DM2DocTags (TagID, TagValue, TagDesc, CreatedBy, Attribute, ownerUserId, containerGuid)
		SELECT NEWID(), @i_tagValue, TagDesc, CreatedBy, Attribute, ownerUserId, containerGuid FROM DM2DocTags
		WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			SET @cloningTag = (SELECT TagValue FROM DM2DocTags WHERE TagID = @i_tagID)
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (192 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloningTag, @dataIsEvent
			SET @paramMsgId = (401 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 10	--UNHIDE ITEMS
	BEGIN
		IF @i_tagID = ''
		BEGIN
			SET @o_errorCode = 5
			SET @o_errorString = 'Missing tag id during un-hide items operation'
			GOTO EXIT_ERROR
		END
		UPDATE DM2DocTags SET Attribute = (Attribute & ~CAST(0x0010 as INT)) WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (194 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			SET @paramMsgId = (404 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 9	--HIDE ITEMS
	BEGIN
		IF @i_tagID = ''
		BEGIN
			SET @o_errorCode = 5
			SET @o_errorString = 'Missing tag id during hide items operation'
			GOTO EXIT_ERROR
		END
		UPDATE DM2DocTags SET Attribute = (Attribute | CAST(0x0010 as INT)) WHERE TagID = @i_tagID
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (194 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
			SET @paramMsgId = (404 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 9
		SET @o_errorString = 'Operation Type is missing'
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN;
	END
END CATCH;
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		ROLLBACK TRAN;
	END
	ELSE
	BEGIN
		SET @i_xmlText = (SELECT DISTINCT
			T.id '@tagId', T.TagID '@id', T.TagValue '@name', T.TagDesc '@description', T.Attribute '@attribute'
			FROM DM2DocTags AS T WHERE @i_tagID = T.TagID
			FOR XML PATH('tag'), ROOT('DM2ContentIndexing_TagOperationResp'))
		IF @i_xmlText IS null
			SET @i_xmlText = '<DM2ContentIndexing_TagOperationResp/>'
		SELECT @i_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformTagOperation')
	delete from GxQscripts where name = 'DM2PerformTagOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformTagOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformTagOperation'
GO

insert into GXDBVersions values(2, 'DM2PerformTagOperation',  '00010019006000050000', 'DM2PerformTagOperation', '00010019006000050000')
GO

