

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformTagDelete.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformTagDelete()
--  | Description:  Performs deletion of Tag
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformTagDelete.sp,v $ $Id: DM2PerformTagDelete.sp,v 1.20.60.4 2018/12/02 01:57:08 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformTagDelete')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformTagDelete <<<'
	drop procedure DM2PerformTagDelete
END
IF EXISTS (select * from GxQscripts where name='DM2PerformTagDelete')
	delete from GxQscripts where name = 'DM2PerformTagDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformTagDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformTagDelete'
GO
print '... Creating Procedure: DM2PerformTagDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformTagDelete
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_operation		INT
	DECLARE @i_tagValue			NVARCHAR(255)
	DECLARE @i_tagDesc			NVARCHAR(MAX)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @i_userGuid			VARCHAR(50)
	DECLARE @tmpErrorString		NVARCHAR(MAX)
	DECLARE @opMsgId			INT
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @TagTable TABLE (id INT,
							 tagId VARCHAR(36),
							 containerId INT
							)
	DECLARE @entityType int = 9504
	DECLARE @i_id int = 0
BEGIN TRY
	DELETE @TagTable
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @tmpErrorString = ''
	--GET PARAM INPUTS
	SET @i_userGuid = ISNULL(( SELECT ref.value('@userGuid', 'VARCHAR(50)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagDeleteRequest') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_TagDeleteRequest') R ( ref ) ), 0)
	INSERT INTO @TagTable
	SELECT ref.value('@tagId', 'INT'),ref.value('@id', 'VARCHAR(36)'), 0
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_TagDeleteRequest/tags') R(ref)
	UPDATE @TagTable SET containerId = C.containerId
	FROM @TagTable T INNER JOIN DM2DocTags DT
		ON DT.id = T.id OR DT.TagID = T.tagId
		INNER JOIN DM2Container C
		ON C.containerGuid = DT.containerGuid
	IF (@@ROWCOUNT = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Tag list is empty'
		GOTO EXIT_ERROR
	END
	IF LEN(@i_userGuid) > 0
	BEGIN
		SET @i_userId = ISNULL((SELECT id FROM UMUSERS WHERE userGuid = @i_userGuid), @i_userId)
	END
	IF @i_userId IS null OR @i_userId = 0
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorString = 'Invalid user information passed!'
		GOTO EXIT_ERROR
	END
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_capability = 25
	-- check if user is the admin
	DECLARE @isAdmin int = 0
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
	-----------------
	--DELETE TAGS
	-----------------
	DECLARE @ownerName		NVARCHAR(255)
	DECLARE @tagId			VARCHAR(36)
	DECLARE @id				INT
    DECLARE @cId			INT
	DECLARE @isOwner INT = 0
	DECLARE	@o_canDeleteEntityType int = 0
BEGIN TRAN
	DECLARE	GetTagIdCursor	CURSOR FOR
	SELECT id,tagId, containerId FROM @TagTable
	OPEN GetTagIdCursor
	FETCH GetTagIdCursor INTO @id,@tagId, @cId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET @i_tagValue = (SELECT TagValue FROM DM2DocTags WHERE TagID = @tagId)
		IF @i_operation = 2 	--DELETE
		BEGIN
			-- delete permission should be checked in case of delete operation only
			IF ( @isAdmin <> 1 )
			BEGIN
				SET @o_canDeleteEntityType  = 0
				EXEC sec_canDeleteDM2EntityType
					@i_commcellId = null,
					@i_userId = @i_userId,
					@i_entityType = @entityType,
					@i_entityId = @cId,
					@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
				IF ( @o_canDeleteEntityType <> 1 )
				BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'User cannot perform operation on Tag id [' + @i_tagValue + ']'
					RAISERROR (@o_errorString, -- Message text.
								16, -- Severity.
								1 -- State.
								)
				END
			END
			IF EXISTS(SELECT * FROM SchedAdminComplianceXmlOptions
				WHERE xmlValue.exist('/director/options/tags[@tagId=sql:variable("@tagId")]') = 1 AND status & 1 <> 1)
			BEGIN
				DECLARE @policyName NVARCHAR(1024)
				SET @policyName = (SELECT TOP 1 policyName FROM SchedAdminComplianceXmlOptions WHERE xmlValue.exist('/director/options/tags[@tagId=sql:variable("@tagId")]') = 1 AND status & 1 <> 1)
				SET @o_errorString = 'Cannot perform operation on Tag [' + @i_tagValue + '] it is being used by compliance policy [' + @policyName + ']'
				SET @o_errorCode = 4
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
			DELETE DM2DocTags WHERE TagID = @tagId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (193 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
				SET @paramMsgId = (402 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 4	--DISABLE
		BEGIN
			IF ( @isAdmin <> 1 )
			BEGIN
				SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @cid)
				IF @isOwner = 0
				BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'User cannot perform operation on Tag id [' + @i_tagValue + ']'
					RAISERROR (@o_errorString, -- Message text.
							   16, -- Severity.
							   1 -- State.
							   )
				END
			END
			UPDATE DM2DocTags SET Attribute = Attribute|0x0008 WHERE TagID = @tagId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (195 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
				SET @paramMsgId = (403 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 5	--ENABLE
		BEGIN
			IF ( @isAdmin <> 1 )
			BEGIN
				SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @cid)
				IF @isOwner = 0
				BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'User cannot perform operation on Tag id [' + @i_tagValue + ']'
					RAISERROR (@o_errorString, -- Message text.
							   16, -- Severity.
							   1 -- State.
							   )
				END
			END
			UPDATE DM2DocTags SET Attribute = (Attribute & ~CAST(0x0008 as INT)) WHERE TagID = @tagId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (194 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_tagValue, @dataIsEvent
				SET @paramMsgId = (404 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		FETCH GetTagIdCursor INTO @id,@tagId, @cId
	END
	CLOSE GetTagIdCursor
	DEALLOCATE GetTagIdCursor
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetTagIdCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetTagIdCursor') >= 0 )
	CLOSE GetTagIdCursor
	IF ( CURSOR_STATUS('global','GetTagIdCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetTagIdCursor') = -1 )
	DEALLOCATE GetTagIdCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN
	END
END CATCH;
EXIT_ERROR:
	SELECT	1					as TAG,
		0					as Parent,
		@o_errorCode			as [CVGui_GenericResp!1!errorCode],
		@o_errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformTagDelete')
	delete from GxQscripts where name = 'DM2PerformTagDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformTagDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformTagDelete'
GO

insert into GXDBVersions values(2, 'DM2PerformTagDelete',  '00010020006000040000', 'DM2PerformTagDelete', '00010020006000040000')
GO

