

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformSyncTags.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformSyncTags')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformSyncTags <<<'
	drop procedure DM2PerformSyncTags
END
IF EXISTS (select * from GxQscripts where name='DM2PerformSyncTags')
	delete from GxQscripts where name = 'DM2PerformSyncTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformSyncTags')
	delete from GXDBVersions where aliasname = 'DM2PerformSyncTags'
GO
print '... Creating Procedure: DM2PerformSyncTags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformSyncTags
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0
AS
SET NOCOUNT ON
BEGIN
DECLARE @o_errorCode        INT
SET @o_errorCode = 0
SET @i_userId = ISNULL (( SELECT ref.value('@userID', 'INT')
                              FROM @i_xmlText.nodes ('Indexing_SyncTagsReq') R(ref)), 0)
DECLARE @ExchangeRetentionContainerGuid varchar(42)= '26A29909-9168-405C-B989-92A8EE243D35'
DECLARE @AzureInformationProtectionContainerGuid varchar(42)= '222CAD52-86D3-4316-889D-2D8804AAF898'
IF NOT EXISTS (select * from DM2Container where (containerName  = 'RetentionTags'))
BEGIN
      INSERT INTO DM2Container
      (containerGuid ,
        containerName ,
        containerType ,
        userId ,
        attribute ,
        comment ,
        origCommcellID,
        createTime)
    VALUES
        ( @ExchangeRetentionContainerGuid,
        'RetentionTags',
        9504,
        1,
        0,
        'Exchange retention tag set',
        0,
        GETUTCDATE())
END
IF NOT EXISTS(select containerId from DM2Container where containerGuid = @AzureInformationProtectionContainerGuid )
BEGIN
	INSERT INTO DM2Container (containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime)
    VALUES (@AzureInformationProtectionContainerGuid, 'AzureInformationProtectionTags', 9504, 1, 0, 'Azure Information Protection Tag', 0, GETUTCDATE())
END
--Populate tag entries from request in tmp table
DECLARE @tmpTagValues table (tagID VARCHAR(36), tagName NVARCHAR(MAX), tagValue INT, tagType int, containerGuid VARCHAR(36), description NVARCHAR(max))
INSERT INTO @tmpTagValues (tagID, tagName, tagValue, tagType, description)
	(SELECT ref.value('@tagGUID', 'VARCHAR(36)'), ref.value('@tagName', 'NVARCHAR(MAX)'), ref.value('@tagValue', 'INT'),
		ISNULL(ref.value('@tagType', 'INT'), 1), ISNULL(ref.value('@desc', 'NVARCHAR(MAX)'), '')
		FROM @i_xmlText.nodes ('Indexing_SyncTagsReq/tags') R(ref) )
--Update containerGuids in tmp table
UPDATE @tmpTagValues SET containerGuid =
							(CASE WHEN tagType = 1 THEN @ExchangeRetentionContainerGuid
							WHEN TagType = 2 THEN @AzureInformationProtectionContainerGuid
							ELSE @ExchangeRetentionContainerGuid END )
MERGE DM2DocTagsValues DT
USING
(
      SELECT tagId, containerGuid, tagValue FROM @tmpTagValues
) AS TV
ON  TV.tagID = DT.TagID
WHEN MATCHED THEN
      UPDATE SET DT.tagValue = TV.tagValue
WHEN NOT MATCHED THEN
	INSERT (TagID, containerGuid, TagValue)
	VALUES (TV.tagId, tv.containerGuid, tv.tagValue);
--Update the Retention tag name in Dm2DocTags if found
MERGE DM2DocTags DT
USING
(
      SELECT tagId, tagName, tagValue, containerGuid, description FROM @tmpTagValues
) AS TV
ON  TV.tagID = DT.TagID
WHEN MATCHED THEN
      UPDATE SET DT.tagValue = TV.tagName
WHEN NOT MATCHED THEN
INSERT (TagID, TagValue, ownerUserId, CreatedBy, containerGuid, TagDesc, Attribute)
VALUES(tv.tagId, tv.tagValue, 1, 'Administrator', tv.containerGuid, tv.description, 0);
SET @o_errorCode = @@error
IF (@o_errorCode = 0)
BEGIN
      DECLARE @o_xmlText XML = '<TEST />'
      select @o_xmlText
END
ELSE
      select '<ERROR />'
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformSyncTags')
	delete from GxQscripts where name = 'DM2PerformSyncTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformSyncTags')
	delete from GXDBVersions where aliasname = 'DM2PerformSyncTags'
GO

insert into GXDBVersions values(2, 'DM2PerformSyncTags',  '00000000000000000000', 'DM2PerformSyncTags', '00000000000000000000')
GO

