

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformRecordConnectorOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformRecordCenterDelete()
--  | Description:  Performs deletion of Record Center
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformRecordConnectorOperation.sp,v $ $Id: DM2PerformRecordConnectorOperation.sp,v 1.7.60.3 2018/09/21 04:49:11 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2PerformRecordConnectorOperation <<<'

IF EXISTS (select * from sysobjects where name='DM2PerformRecordConnectorOperation')
	drop procedure DM2PerformRecordConnectorOperation
IF EXISTS (select * from GxQscripts where name='DM2PerformRecordConnectorOperation')
	delete from GxQscripts where name = 'DM2PerformRecordConnectorOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordConnectorOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordConnectorOperation'
GO
print '... Creating Procedure: DM2PerformRecordConnectorOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformRecordConnectorOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_operation		INT
	DECLARE @i_rcName			NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @tmpErrorString		NVARCHAR(MAX)
	DECLARE @isAdmin			INT
	DECLARE @opMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opEvMsgId			INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @entityType			INT = 9506
	DECLARE @RecordConnectorTable TABLE (rcId INT)
BEGIN TRY
BEGIN TRAN
	DELETE @RecordConnectorTable
	SET @isAdmin = 0
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @tmpErrorString = ''
	INSERT INTO @RecordConnectorTable
	SELECT ref.value('@id', 'INT')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorDeleteReq/recordConnectors') R(ref)
	IF (@@ROWCOUNT = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Record Center list is empty'
		GOTO EXIT_ERROR
	END
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorDeleteReq') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorDeleteReq') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorDeleteReq') R ( ref ) ), 2)
	-- check if user is the admin
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
	---------------------------------------
	--PERFORM OPERATION ON RECORD CENTER
	---------------------------------------
	DECLARE @ownerName		NVARCHAR(255)
	DECLARE @rcId			INT
	DECLARE	@o_canDeleteEntityType int = 0
	DECLARE @isOwner int
	DECLARE	GetRecordConnectorCursor	CURSOR FOR
	SELECT rcId FROM @RecordConnectorTable
	OPEN GetRecordConnectorCursor
	FETCH GetRecordConnectorCursor INTO @rcId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET @i_rcName = (SELECT connectorName FROM DM2RecordCenterConnector WHERE id = @rcId)
		IF @i_operation = 2 	--DELETE
		BEGIN
			IF ( @isAdmin <> 1 )
			BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'Only administrators can perform delete operation on Record Connector [' + @i_rcName + ']'
					RAISERROR (@o_errorString, -- Message text.
								16, -- Severity.
								1 -- State.
								)
				END
			IF EXISTS(SELECT * FROM SchedAdminComplianceXmlOptions
				WHERE xmlValue.exist('/director/options/moss[@recordConnectorId=sql:variable("@rcId")]') = 1 AND status & 1 <> 1)
			BEGIN
				DECLARE @policyName NVARCHAR(1024)
				SET @policyName = (SELECT TOP 1 policyName FROM SchedAdminComplianceXmlOptions WHERE xmlValue.exist('/director/options/moss[@recordConnectorId=sql:variable("@rcId")]') = 1 AND status & 1 <> 1)
				SET @o_errorString = 'Cannot perform operation on Record Connector [' + @i_rcName + '] it is being used by compliance policy [' + @policyName + ']'
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
			DELETE DM2RecordCenterConnector WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (259 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (492 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 4	--DISABLE
		BEGIN
			IF ( @isAdmin <> 1 )
			BEGIN
				SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @rcId)
				IF @isOwner = 0
				BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'User cannot perform operation on Record Connector [' + @i_rcName + ']'
					RAISERROR (@o_errorString, -- Message text.
							   16, -- Severity.
							   1 -- State.
							   )
				END
			END
			UPDATE DM2RecordCenterConnector SET status = status|0x0008 WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (261 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (493 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 5	--ENABLE
		BEGIN
			IF ( @isAdmin <> 1 )
			BEGIN
				SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @rcId)
				IF @isOwner = 0
				BEGIN
					SET @o_errorCode = 3
					SET @o_errorString = 'User cannot perform operation on Record Connector [' + @i_rcName + ']'
					RAISERROR (@o_errorString, -- Message text.
							   16, -- Severity.
							   1 -- State.
							   )
				END
			END
			UPDATE DM2RecordCenterConnector SET status = (status & ~CAST(0x0008 as INT)) WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (260 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (494 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		FETCH GetRecordConnectorCursor INTO @rcId
	END
	CLOSE GetRecordConnectorCursor
	DEALLOCATE GetRecordConnectorCursor
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetRecordConnectorCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetRecordConnectorCursor') >= 0 )
	CLOSE GetRecordConnectorCursor
	IF ( CURSOR_STATUS('global','GetRecordConnectorCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetRecordConnectorCursor') = -1 )
	DEALLOCATE GetRecordConnectorCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	SELECT	1					as TAG,
		0					as Parent,
		@o_errorCode			as [CVGui_GenericResp!1!errorCode],
		@o_errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
	IF (@o_errorCode <> 0)
		ROLLBACK TRANSACTION;
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformRecordConnectorOperation')
	delete from GxQscripts where name = 'DM2PerformRecordConnectorOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordConnectorOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordConnectorOperation'
GO

insert into GXDBVersions values(2, 'DM2PerformRecordConnectorOperation',  '00010007006000030000', 'DM2PerformRecordConnectorOperation', '00010007006000030000')
GO

