

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformRecordConnectorCreate.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformRoutingRoulesCreate()
--  | Description:  Performs operations on Record Center (ADD,DISABLE,UPDATE, ...)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformRecordConnectorCreate.sp,v $ $Id: DM2PerformRecordConnectorCreate.sp,v 1.11.60.2 2018/03/27 09:09:32 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2PerformRecordConnectorCreate <<<'

IF EXISTS (select * from sysobjects where name='DM2PerformRecordConnectorCreate')
	drop procedure DM2PerformRecordConnectorCreate
IF EXISTS (select * from GxQscripts where name='DM2PerformRecordConnectorCreate')
	delete from GxQscripts where name = 'DM2PerformRecordConnectorCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordConnectorCreate')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordConnectorCreate'
GO
print '... Creating Procedure: DM2PerformRecordConnectorCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformRecordConnectorCreate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_conId			INT
	DECLARE @i_rcId			INT
	DECLARE @i_operation		INT
	DECLARE @i_mossOption		XML
	DECLARE @i_connectName		NVARCHAR(255)
	DECLARE @i_recDesc			NVARCHAR(MAX)
	DECLARE @i_rcName				NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @categoryID			VARCHAR(36)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @opMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opEvMsgId			INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
DECLARE @entityType			INT = 9506
	DECLARE @userGUID			NVARCHAR(36)
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @i_domainName = ''
	SET @userGUID = ''
BEGIN TRY
BEGIN TRAN
	--CHECK FOR THE USERGUID
	SET @userGUID = ISNULL(( SELECT ref.value('@userGuid', 'NVARCHAR(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation') R ( ref ) ), '')
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--ASSIGN ID WITH RESPECTIVE USER , IF EXISTS
	IF @userGUID is not null AND LEN (@userGUID ) = 36
		SET @i_userId = ISNULL((SELECT TOP(1) id FROM UMUSERS WHERE userGuid = @userGUID),@i_userId)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterDeleteReq') R ( ref ) ), '')
	SET @i_rcName = ISNULL(( SELECT ref.value('@recordCenterName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@type', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation') R ( ref ) ), 0)
	SET @i_conId = ISNULL(( SELECT ref.value('@id', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), 0)
	SET @i_rcId = ISNULL(( SELECT ref.value('@recordCenterId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), 0)
	SET @i_connectName = ISNULL(( SELECT ref.value('@name', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), '')
	SET @i_recDesc = ISNULL(( SELECT ref.value('@description', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorOperation/rcInfo') R ( ref ) ), '')
	SET @i_mossOption = (SELECT (SELECT ref.query('.')FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorOperation/rcInfo/moss') R(ref))
		FOR XML PATH(''))
	IF @i_operation = 1 	--ADD
	BEGIN
		INSERT INTO @t_userCaps
		EXECUTE GetUserCapabilities @i_userId
		SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ((@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0)
		)
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorString = 'User does not have Compliance search rights'
			GOTO EXIT_ERROR
		END
		IF (EXISTS (SELECT * FROM DM2RecordCenterConnector WHERE connectorName = @i_connectName))
		BEGIN
			SET @o_errorCode = 2
			SET @o_errorString = 'Record connector ['+@i_connectName+'] already exists'
			GOTO EXIT_ERROR
		END
		INSERT INTO DM2RecordCenterConnector (connectorName, recordId, recordName, description, xmlValue, status, ownerUserId, createTime)
		VALUES (@i_connectName, @i_rcId, @i_rcName, @i_recDesc, @i_mossOption, 0x0000, @i_userId, GETUTCDATE())
		SET @o_errorCode = @@error
		SET @i_conId = @@IDENTITY
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (256 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_connectName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_recDesc, @dataIsEvent
			SET @paramMsgId = (489 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			SET @i_xmlText = (SELECT @i_conId '@id'
				FOR XML PATH('DM2ContentIndexing_RecordConnectorResp'))
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 3	--MODIFY
	BEGIN
		DECLARE @oldName NVARCHAR(MAX)
		DECLARE @oldRC NVARCHAR(MAX)
		DECLARE @oldDesc NVARCHAR(MAX)
		IF @i_conId = 0
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorString = 'Missing record center id during modify operation'
			GOTO EXIT_ERROR
		END
		DECLARE	@o_canEditEntityType int = 0
		EXEC sec_canEditDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @i_conId,
			@o_canEditEntityType = @o_canEditEntityType OUTPUT
		IF ( @o_canEditEntityType <> 1 )
		BEGIN
			SET @o_errorCode = -1
			SET @o_errorString = 'User does not have Edit ERM Rights'
			GOTO EXIT_ERROR
		END
		--THIS ERROR SHOULD NOT HAPPEN
		IF (NOT EXISTS (SELECT * FROM DM2RecordCenterConnector WHERE id = @i_conId))
		BEGIN
			SET @o_errorCode = 4
			SET @o_errorString = 'Record connector id ['+CAST(@i_conId AS NVARCHAR(10))+'] not found duting modify operation'
			GOTO EXIT_ERROR
		END
		SELECT @oldName=connectorName, @oldRC=recordName, @oldDesc=description
		FROM DM2RecordCenterConnector WHERE id = @i_conId
		UPDATE DM2RecordCenterConnector SET  connectorName=@i_connectName, recordId=@i_rcId,
		recordName=@i_rcName, xmlValue = @i_mossOption, description = @i_recDesc
		WHERE id = @i_conId
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (257 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_connectName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldRC, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldDesc, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_recDesc, @dataIsEvent
			SET @paramMsgId = (490 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			SET @i_xmlText = (SELECT @i_conId '@id'
				FOR XML PATH('DM2ContentIndexing_RecordConnectorResp'))
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 9
		SET @o_errorString = 'Operation Type is missing'
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		--ROLLBACK TRANSACTION;
	END
	ELSE
	BEGIN
		SELECT @i_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformRecordConnectorCreate')
	delete from GxQscripts where name = 'DM2PerformRecordConnectorCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordConnectorCreate')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordConnectorCreate'
GO

insert into GXDBVersions values(2, 'DM2PerformRecordConnectorCreate',  '00010011006000020000', 'DM2PerformRecordConnectorCreate', '00010011006000020000')
GO

