

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformRecordCenterOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformRecordCenterDelete()
--  | Description:  Performs deletion of Record Center
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformRecordCenterOperation.sp,v $ $Id: DM2PerformRecordCenterOperation.sp,v 1.7.60.2 2018/03/27 09:16:29 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2PerformRecordCenterOperation <<<'

IF EXISTS (select * from sysobjects where name='DM2PerformRecordCenterOperation')
	drop procedure DM2PerformRecordCenterOperation
IF EXISTS (select * from GxQscripts where name='DM2PerformRecordCenterOperation')
	delete from GxQscripts where name = 'DM2PerformRecordCenterOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordCenterOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordCenterOperation'
GO
print '... Creating Procedure: DM2PerformRecordCenterOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformRecordCenterOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_operation		INT
	DECLARE @i_rcName			NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @tmpErrorString		NVARCHAR(MAX)
	DECLARE @opMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opEvMsgId			INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @entityType			INT = 9506
	DECLARE @RecordCenterTable TABLE (rcId VARCHAR(36))
BEGIN TRY
BEGIN TRAN
	DELETE @RecordCenterTable
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @tmpErrorString = ''
	INSERT INTO @RecordCenterTable
	SELECT ref.value('@id', 'VARCHAR(36)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordCenterDeleteReq/recordCenters') R(ref)
	IF (@@ROWCOUNT = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Record Center list is empty'
		GOTO EXIT_ERROR
	END
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterDeleteReq') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterDeleteReq') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterDeleteReq') R ( ref ) ), 2)
	--GET USER RIGHTS
	DECLARE @canManageEntityType int = 0
	EXEC	[dbo].[sec_canManageDM2EntityType]
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = 0,
			@o_canManageEntityType = @canManageEntityType OUTPUT
	IF ( @canManageEntityType <> 1 )
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have ERM Management Rights'
		GOTO EXIT_ERROR
	END
	---------------------------------------
	--PERFORM OPERATION ON RECORD CENTER
	---------------------------------------
	DECLARE @ownerName		NVARCHAR(255)
	DECLARE @rcId			VARCHAR(36)
	DECLARE	GetRecordCenterCursor	CURSOR FOR
	SELECT rcId FROM @RecordCenterTable
	OPEN GetRecordCenterCursor
	FETCH GetRecordCenterCursor INTO @rcId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET @i_rcName = (SELECT recordName FROM DM2RecordCenter WHERE id = @rcId)
		IF @i_operation = 2 	--DELETE
		BEGIN
			IF EXISTS(SELECT * FROM DM2RecordCenterConnector WHERE recordId = @rcId)
			BEGIN
				DECLARE @connectorName NVARCHAR(1024)
				SET @connectorName = (SELECT TOP 1 connectorName FROM DM2RecordCenterConnector WHERE recordId = @rcId)
				SET @o_errorString = 'Cannot perform operation on Record Center [' + @i_rcName + '] it is being used by record connector [' + @connectorName + ']'
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
			DELETE DM2RecordCenter WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (199 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (408 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 4	--DISABLE
		BEGIN
			UPDATE DM2RecordCenter SET status = status|0x0008 WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (201 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (409 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 5	--ENABLE
		BEGIN
			UPDATE DM2RecordCenter SET status = (status & ~CAST(0x0008 as INT)) WHERE id = @rcId
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (200 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @i_rcName, @dataIsEvent
				SET @paramMsgId = (410 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		FETCH GetRecordCenterCursor INTO @rcId
	END
	CLOSE GetRecordCenterCursor
	DEALLOCATE GetRecordCenterCursor
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetRecordCenterCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetRecordCenterCursor') >= 0 )
	CLOSE GetRecordCenterCursor
	IF ( CURSOR_STATUS('global','GetRecordCenterCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetRecordCenterCursor') = -1 )
	DEALLOCATE GetRecordCenterCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	SELECT	1					as TAG,
		0					as Parent,
		@o_errorCode			as [CVGui_GenericResp!1!errorCode],
		@o_errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
	IF (@o_errorCode <> 0)
		ROLLBACK TRANSACTION;
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformRecordCenterOperation')
	delete from GxQscripts where name = 'DM2PerformRecordCenterOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordCenterOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordCenterOperation'
GO

insert into GXDBVersions values(2, 'DM2PerformRecordCenterOperation',  '00010007006000020000', 'DM2PerformRecordCenterOperation', '00010007006000020000')
GO

