

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformRecordCenterCreate.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformRecordCenterOperation()
--  | Description:  Performs operations on Record Center (ADD,DISABLE,UPDATE, ...)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformRecordCenterCreate.sp,v $ $Id: DM2PerformRecordCenterCreate.sp,v 1.25.60.2 2018/03/27 09:16:18 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2PerformRecordCenterCreate <<<'

IF EXISTS (select * from sysobjects where name='DM2PerformRecordCenterCreate')
	drop procedure DM2PerformRecordCenterCreate
IF EXISTS (select * from GxQscripts where name='DM2PerformRecordCenterCreate')
	delete from GxQscripts where name = 'DM2PerformRecordCenterCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordCenterCreate')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordCenterCreate'
GO
print '... Creating Procedure: DM2PerformRecordCenterCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformRecordCenterCreate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML,
  @i_passWord NVARCHAR(255)
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_rcId				INT
	DECLARE @i_operation		INT
	DECLARE @i_recName			NVARCHAR(255)
	DECLARE @i_recDesc			NVARCHAR(MAX)
	DECLARE @i_rcUserName		NVARCHAR(255)
	DECLARE @i_UserPassword		NVARCHAR(1024)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @i_url				NVARCHAR(MAX)
	DECLARE @i_type				INT
	DECLARE @categoryID			VARCHAR(36)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @opMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opEvMsgId			INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @pos				INT
	DECLARE @i_mossRules		XML
	DECLARE @rcType				NVARCHAR(1024)
	DECLARE @paramData			NVARCHAR(1024)
DECLARE @entityType			INT = 9506
	DECLARE @i_isRefreshRequest	INT = 0
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @i_domainName = ''
	SET @rcType = 'MOSS'
BEGIN TRY
BEGIN TRAN
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET PARAM INPUTS
	SET @i_rcUserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter/userPassword') R ( ref ) ), '')
	IF ISNULL(@i_rcUserName,'') = ''
	BEGIN
		SET @i_rcUserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter/userAccount') R ( ref ) ), '')
	END
	--PASSWORD IS ENCRYPTED BY GUI USING A DIFFERENT KEY, IT CANNOT BE USED
	--SET @i_UserPassword = ISNULL(( SELECT ref.value('@password', 'nvarchar(255)')
	--					FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter/userPassword') R ( ref ) ), '')
	--DOMAIN NAME IT IS NOW SENT WITH THE USER NAME
	--SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
	--					FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter/userPassword') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@type', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation') R ( ref ) ), 0)
	SET @i_rcId = ISNULL(( SELECT ref.value('@id', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter') R ( ref ) ), 0)
	SET @i_recName = ISNULL(( SELECT ref.value('@name', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter') R ( ref ) ), '')
	SET @i_recDesc = ISNULL(( SELECT ref.value('@description', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter') R ( ref ) ), '')
	SET @i_url = ISNULL(( SELECT ref.value('@url', 'nvarchar(MAX)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter') R ( ref ) ), '')
	SET @i_type = ISNULL(( SELECT ref.value('@type', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation/recordCenter') R ( ref ) ), 1)
	SET @i_isRefreshRequest = ISNULL(( SELECT ref.value('@isRefreshRequest', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_RecordCenterOperation') R ( ref ) ), 0)
	SET @i_mossRules = (SELECT ref.query('mossRules')
		FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordCenterOperation/recordCenter') R(ref)
		FOR XML PATH('DM2ContentIndexing_GetRecordRoutingRulesResp'))
	IF @i_mossRules IS null
		SET @i_mossRules = ''
	SET @pos = CHARINDEX('\', @i_rcUserName)
	IF @pos <> 0
	BEGIN
		SET @i_domainName = SUBSTRING(@i_rcUserName, 0, @pos)
		SET @i_rcUserName = SUBSTRING(@i_rcUserName, @pos+1, LEN(@i_rcUserName))
	END
	INSERT INTO @t_userCaps
	EXECUTE GetUserCapabilities @i_userId
	SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ((@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0)
	)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have Compliance search rights'
		GOTO EXIT_ERROR
	END
	IF @i_operation = 1 	--ADD
	BEGIN
		IF (EXISTS (SELECT * FROM DM2RecordCenter WHERE recordName = @i_recName))
		BEGIN
			SET @o_errorCode = 2
			SET @o_errorString = 'Record center ['+@i_recName+'] already exists'
			GOTO EXIT_ERROR
		END
		INSERT INTO DM2RecordCenter (url, recordName, userName, password, domain, type, description, xmlValue, status)
		VALUES (@i_url, @i_recName, @i_rcUserName, @i_passWord, @i_domainName, @i_type, @i_recDesc, @i_mossRules, 0x0000)
		SET @o_errorCode = @@error
		SET @i_rcId = @@IDENTITY
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (196 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_recName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_url, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_rcUserName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_domainName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @rcType, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_recDesc, @dataIsEvent
			SET @paramMsgId = (405 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			SET @i_xmlText = (SELECT @i_rcId '@recordCenterId'
				FOR XML PATH('DM2ContentIndexing_RecordCenterCreateResp'))
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 3	--MODIFY
	BEGIN
		DECLARE @oldUrl NVARCHAR(MAX)
		DECLARE @oldName NVARCHAR(MAX)
		DECLARE @oldDesc NVARCHAR(MAX)
		IF @i_rcId = 0
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorString = 'Missing record center id during modify operation'
			GOTO EXIT_ERROR
		END
		--THIS ERROR SHOULD NOT HAPPEN
		IF (NOT EXISTS (SELECT * FROM DM2RecordCenter WHERE id = @i_rcId))
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorString = 'Record center id ['+CAST(@i_rcId AS NVARCHAR(10))+'] not found duting modify operation'
			GOTO EXIT_ERROR
		END
		SELECT @oldName=recordName, @oldUrl=url, @oldDesc=description
		FROM DM2RecordCenter WHERE id = @i_rcId
		IF @i_passWord <> ''
		BEGIN
			UPDATE DM2RecordCenter SET url=@i_url, userName=@i_rcUserName, password=@i_passWord,
			domain = @i_domainName, description = @i_recDesc, recordName = @i_recName
			WHERE id = @i_rcId
		END
		ELSE
		BEGIN
			UPDATE DM2RecordCenter SET url=@i_url, userName=@i_rcUserName,
			domain = @i_domainName, description = @i_recDesc, recordName = @i_recName
			WHERE id = @i_rcId
		END
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0 AND @i_isRefreshRequest = 1)
		BEGIN
			UPDATE DM2RecordCenter SET xmlValue = @i_mossRules
			WHERE id = @i_rcId
			SET @o_errorCode = @@error
		END
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (197 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @oldName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_recName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldUrl, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_url, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @oldDesc, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_recDesc, @dataIsEvent
			SET @paramMsgId = (506 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			SET @i_xmlText = (SELECT @i_rcId '@recordCenterId'
				FOR XML PATH('DM2ContentIndexing_RecordCenterCreateResp'))
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE IF @i_operation = 6	--CLONE
	BEGIN
		DECLARE @cloningRC	NVARCHAR(255)
		IF @i_rcId = 0
		BEGIN
			SET @o_errorCode = 6
			SET @o_errorString = 'Missing record center id during clone operation'
			GOTO EXIT_ERROR
		END
		INSERT INTO DM2RecordCenter (url, recordName, userName, password, domain, type, description, xmlValue, status)
		SELECT url, @i_recName, userName, password, domain, type, description, xmlValue, status FROM DM2RecordCenter
		WHERE id = @i_rcId
		SET @o_errorCode = @@error
		SET @i_rcId = @@IDENTITY
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			SET @cloningRC = (SELECT recordName FROM DM2RecordCenter WHERE id = @i_rcId)
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (198 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId , @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_recName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloningRC, @dataIsEvent
			SET @paramMsgId = (407 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			SET @i_xmlText = (SELECT @i_rcId '@recordCenterId'
				FOR XML PATH('DM2ContentIndexing_RecordCenterCreateResp'))
		END
		ELSE
		BEGIN
			SET @o_errorString = ERROR_MESSAGE()
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 9
		SET @o_errorString = 'Operation Type is missing'
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		--ROLLBACK TRANSACTION;
	END
	ELSE
	BEGIN
		SELECT @i_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformRecordCenterCreate')
	delete from GxQscripts where name = 'DM2PerformRecordCenterCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformRecordCenterCreate')
	delete from GXDBVersions where aliasname = 'DM2PerformRecordCenterCreate'
GO

insert into GXDBVersions values(2, 'DM2PerformRecordCenterCreate',  '00010025006000020000', 'DM2PerformRecordCenterCreate', '00010025006000020000')
GO

