

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformLegalHoldOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformLegalHoldOperation()
--  | Description:  Performs operations on LegalHold (ADD,DISABLE,UPDATE, ...)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformLegalHoldOperation.sp,v $ $Id: DM2PerformLegalHoldOperation.sp,v 1.27.60.2 2018/03/27 09:18:03 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2PerformLegalHoldOperation <<<'

IF EXISTS (select * from sysobjects where name='DM2PerformLegalHoldOperation')
	drop procedure DM2PerformLegalHoldOperation
IF EXISTS (select * from GxQscripts where name='DM2PerformLegalHoldOperation')
	delete from GxQscripts where name = 'DM2PerformLegalHoldOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformLegalHoldOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformLegalHoldOperation'
GO
print '... Creating Procedure: DM2PerformLegalHoldOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformLegalHoldOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_operation		INT
	DECLARE @i_lhValue			NVARCHAR(255)
	DECLARE @i_lhDesc			NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @i_CompPolicyID 	VARCHAR(36)
	DECLARE @i_CompPolicyName	NVARCHAR(256)
	DECLARE @i_CompPolicyDesc	NVARCHAR(MAX)
	DECLARE @i_RetainUntil		INT
	DECLARE @i_BackupsetId		INT
	DECLARE @i_Attribute 		INT
	DECLARE @i_UserGUID 		VARCHAR(36)
	DECLARE @i_CreateTime		INT
	DECLARE @i_ModifiedTime		INT
	DECLARE @i_StoragePolicy	INT
	DECLARE @storatePolicyName	NVARCHAR(256)
	DECLARE @xmlText			XML
	DECLARE @errorHandled		INT
	DECLARE @opMsgId			INT
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @i_LegalHoldId		INT
	DECLARE @i_emailIds			NVARCHAR(MAX)
	DECLARE @i_receiveOutput	INT
	DECLARE @i_isReferenceCopy	INT
	DECLARE @flags				INT
	DECLARE @userObjects	TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @backupSet	TABLE (backupSetId	integer,
						subClientId		integer,
						errorString		NVARCHAR(MAX) )
DECLARE @entityType INT = 9505
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @errorHandled = 0
BEGIN TRY
BEGIN TRAN
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_capability = 25
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq') R ( ref ) ), 0)
	SET @i_CompPolicyID = ISNULL(( SELECT ref.value('@id', 'varchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), NEWID())
	SET @i_CompPolicyName = ISNULL(( SELECT ref.value('@name', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), '')
	SET @i_CompPolicyDesc = ISNULL(( SELECT ref.value('@description', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), '')
	SET @i_RetainUntil = ISNULL(( SELECT ref.value('@retentionPeriod', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), null)
	--SET @i_BackupsetId = ISNULL(( SELECT ref.value('@backupsetId', 'INT')
	--					FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), 0)
	SET @i_Attribute = ISNULL(( SELECT ref.value('@attribute', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), 0)
	SET @i_UserGUID = ISNULL(( SELECT ref.value('@userId', 'varchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), '')
	SET @i_CreateTime = ISNULL(( SELECT ref.value('@createTime', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), 0)
	SET @i_ModifiedTime = ISNULL(( SELECT ref.value('@modifiedTime', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), 0)
	SET @i_StoragePolicy = ISNULL(( SELECT ref.value('@storagePolicy', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), 0)
	SET @i_LegalHoldId = ISNULL(( SELECT ref.value('@legalHoldId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), '')
	SET @i_emailIds = ISNULL(( SELECT ref.value('@emailIds', 'NVARCHAR(MAX)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) ), '')
	SET @i_isReferenceCopy = ( SELECT ref.value('@isReferenceCopy', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldOperationReq/legalHold') R ( ref ) )
	IF (@i_isReferenceCopy IS NOT NULL AND @i_isReferenceCopy = 1)
SET @flags = 2
	ELSE
SET @flags = 1
	SET @storatePolicyName = (SELECT name FROM ArchGroup WHERE id=@i_StoragePolicy)
	DECLARE @retainUntil	DATETIME
	DECLARE @createTime		DATETIME
	IF (@i_RetainUntil IS NOT null)
	BEGIN
		--SET @retainUntil = DATEADD(DAY, @i_RetainUntil, GETDATE())
		IF (@i_RetainUntil = -1)
			SET @retainUntil = '12/31/9999'
		ELSE IF (@i_RetainUntil = 0)
			SET @retainUntil = null
		ELSE
			SET @retainUntil = dbo.getdatetime(@i_RetainUntil)
	END
		SET @createTime = GETUTCDATE()
	IF @i_operation = 1 	--ADD
	BEGIN
		INSERT INTO @t_userCaps
		EXECUTE GetUserCapabilities @i_userId
		SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ( (@userCaps & CONVERT(bigint, (POWER(2.0, 29-1))) = 0) OR
(@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0)
		)
		BEGIN
			SET @o_errorCode = -1
			SET @o_errorString = 'User does not have both Legal Hold Management and Compliance search rights'
			GOTO EXIT_ERROR
		END
		IF EXISTS(SELECT * FROM DM2CompliancePolicy WHERE CompPolicyName=@i_CompPolicyName)
		BEGIN
			SET @o_errorCode = -2
			SET @o_errorString = 'Cannot create Legal Hold. Name ['+@i_CompPolicyName+'] already exists.'
			GOTO EXIT_ERROR
		END
		SET @xmlText = '<CVGui_CreateOnDemandBackupSetReq dataArchGrpId="'+CAST(@i_StoragePolicy AS VARCHAR(256))+
		'" webServerClientId="2" backupSetName="'+@i_CompPolicyName+'" />'
		INSERT INTO @backupSet
			EXEC AppCreateOnDemandBackupSet @xmlText
		--SET @o_errorString = (SELECT errorString FROM @backupSet)
		SET @i_BackupsetId = (SELECT backupSetId FROM @backupSet)
		IF @i_BackupsetId > 0
		BEGIN
			SET @i_receiveOutput = 0
			EXEC DM2AddLegalHold @i_CompPolicyID, @i_CompPolicyName, @i_CompPolicyDesc, @retainUntil,
				@i_BackupsetId, @i_Attribute, @i_UserGUID, @createTime, @createTime,@i_emailIds,@i_receiveOutput,@flags
			-- SET GUI AUDIT OPERATION
			SET @opMsgId = (208 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @i_CompPolicyName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @storatePolicyName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_UserName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_domainName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @i_CompPolicyDesc, @dataIsEvent
			IF (@retainUntil IS NOT null)
				EXEC EvGuiAuditSetParamData @opId, @retainUntil, @dataIsEvent
			ELSE
				EXEC EvGuiAuditSetParamData @opId, 0, @dataIsEvent
			SET @paramMsgId = (411 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
			SET @o_errorCode = @i_BackupsetId
			SET @o_errorString = (SELECT errorString FROM @backupSet)
			GOTO EXIT_ERROR
		END
	END
	ELSE IF @i_operation = 3	--MODIFY
	BEGIN
		DECLARE	@o_canEditEntityType int = 0
		EXEC sec_canEditDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @i_LegalHoldId,
			@o_canEditEntityType = @o_canEditEntityType OUTPUT
		IF ( @o_canEditEntityType <> 1 )
		BEGIN
			SET @o_errorCode = -1
			SET @o_errorString = 'User does not have Edit Legal Hold Rights'
			GOTO EXIT_ERROR
		END
		DECLARE @oldDesc NVARCHAR(MAX)
		DECLARE @oldRetainUntil	DATETIME
		IF @i_CompPolicyName = ''
		BEGIN
			SET @o_errorCode = -3
			SET @o_errorString = 'Missing compliance policy name during update operation'
			GOTO EXIT_ERROR
		END
		IF @i_CompPolicyID = ''
		BEGIN
			SET @o_errorCode = -4
			SET @o_errorString = 'Missing compliance policy id during update operation'
			GOTO EXIT_ERROR
		END
		IF NOT EXISTS(SELECT * FROM DM2CompliancePolicy WHERE CompPolicyID = @i_CompPolicyID)
		BEGIN
			SET @o_errorCode = -5
			SET @o_errorString = 'Could not find compliance policy id ['+ @i_CompPolicyID+']'
			GOTO EXIT_ERROR
		END
		SELECT @oldDesc= CompPolicyDesc, @oldRetainUntil=RetainUntil FROM DM2CompliancePolicy WHERE CompPolicyID = @i_CompPolicyID
		--if the input value is not provided, pass null for flags.
		IF( @i_isReferenceCopy IS NULL)
			SET @flags = NULL
		EXEC DM2UpdateLegalHold @i_CompPolicyName, @i_CompPolicyDesc, @retainUntil, @i_Attribute, @i_UserGUID, @createTime , @i_emailIds, @flags
		-- SET GUI AUDIT OPERATION
		SET @opMsgId = (209 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- SET GUI AUDIT PARAMETER
		EXEC EvGuiAuditSetParamData @opId, @i_CompPolicyName, @dataIsEvent
		IF (@oldRetainUntil IS NOT null)
			EXEC EvGuiAuditSetParamData @opId, @oldRetainUntil, @dataIsEvent
		ELSE
			EXEC EvGuiAuditSetParamData @opId, 0, @dataIsEvent
		IF (@retainUntil IS NOT null)
			EXEC EvGuiAuditSetParamData @opId, @retainUntil, @dataIsEvent
		ELSE
			EXEC EvGuiAuditSetParamData @opId, 0, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @oldDesc, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @i_CompPolicyDesc, @dataIsEvent
		SET @paramMsgId = (412 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	END
	ELSE
	BEGIN
		SET @o_errorCode = -9
		SET @o_errorString = 'Operation Type is missing'
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		SET @errorHandled = 1
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		IF @errorHandled = 0
			ROLLBACK TRANSACTION;
	END
	ELSE
	BEGIN
		DECLARE @Retain			INT
		SET @retainUntil = (SELECT RetainUntil DM2CompliancePolicy FROM DM2CompliancePolicy  WHERE CompPolicyName = @i_CompPolicyName)
		IF (@retainUntil = '12/31/9999')
			SET @Retain = -1
		ELSE
			SET @Retain = dbo.getunixtime(@retainUntil)
		SET @i_xmlText = (SELECT DISTINCT
			C.id '@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description', @Retain '@retentionPeriod',
			A.dataArchGrpId '@storagePolicy', C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
			dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',C.emailIds '@emailIds',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy'
			FROM APP_Application AS A, DM2CompliancePolicy AS C WHERE C.CompPolicyName = @i_CompPolicyName AND A.backupSet = C.BackupSetId
			FOR XML PATH('legalHold'), ROOT('DM2ContentIndexing_LegalHoldOperationResp'))
		IF @i_xmlText IS null
			SET @i_xmlText = '<DM2ContentIndexing_LegalHoldOperationResp/>'
		SELECT @i_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformLegalHoldOperation')
	delete from GxQscripts where name = 'DM2PerformLegalHoldOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformLegalHoldOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformLegalHoldOperation'
GO

insert into GXDBVersions values(2, 'DM2PerformLegalHoldOperation',  '00010027006000020000', 'DM2PerformLegalHoldOperation', '00010027006000020000')
GO

