

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformLegalHoldDelete.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformLegalHoldDelete()
--  | Description:  Performs deletion of legal hold
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformLegalHoldDelete.sp,v $ $Id: DM2PerformLegalHoldDelete.sp,v 1.20.12.4 2018/12/02 01:57:12 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformLegalHoldDelete')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformLegalHoldDelete <<<'
	drop procedure DM2PerformLegalHoldDelete
END
IF EXISTS (select * from GxQscripts where name='DM2PerformLegalHoldDelete')
	delete from GxQscripts where name = 'DM2PerformLegalHoldDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformLegalHoldDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformLegalHoldDelete'
GO
print '... Creating Procedure: DM2PerformLegalHoldDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformLegalHoldDelete
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_operation		INT
	DECLARE @i_tagValue			NVARCHAR(255)
	DECLARE @i_tagDesc			NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @tmpErrorString		NVARCHAR(MAX)
	DECLARE @opMsgId			INT
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @paramData			NVARCHAR(1024)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @entityType INT = 9505
	DECLARE @id INT
	DECLARE @LHTable TABLE (id INT,
							lhId VARCHAR(36))
	DELETE @LHTable
	SET @dataIsEvent = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @tmpErrorString = ''
	--GET LEGAL HOLD TO DELETE
	INSERT INTO @LHTable
	SELECT ref.value('@legalHoldId', 'INT'), ref.value('@id', 'VARCHAR(36)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_LegalHoldDeleteRequest/legalHolds') R(ref)
	IF (@@ROWCOUNT = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Tag list is empy'
		GOTO EXIT_ERROR
	END
BEGIN TRY
BEGIN TRAN
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldDeleteRequest') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldDeleteRequest') R ( ref ) ), '')
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_LegalHoldDeleteRequest') R ( ref ) ), 0)
-- check if user is the admin
	DECLARE @isAdmin int = 0
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
	-----------------
	--DELETE LEGAL HOLDS
	-----------------
	DECLARE @legalHoldId 	VARCHAR(36)
	DECLARE	@o_canDeleteEntityType int = 0
	DECLARE	GetlhIdCursor	CURSOR FOR
	SELECT id,lhId FROM @LHTable
	OPEN GetlhIdCursor
	FETCH GetlhIdCursor INTO @id,@legalHoldId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		DECLARE @compPolicyName	NVARCHAR(256)
		DECLARE @userGUID		VARCHAR(36)
		DECLARE @compPolicyDesc	NVARCHAR(MAX)
		DECLARE @backupSetId	INT
		DECLARE @xmlOper		XML
		DECLARE @attribute		INT
		DECLARE @retainUntil	DATETIME
		DECLARE @modifyTime		DATETIME
		DECLARE @emailIds		NVARCHAR(MAX)
		DECLARE @isOwner INT = 0
		SELECT @compPolicyName = CompPolicyName, @userGUID= UserGUID, @compPolicyDesc=CompPolicyDesc,
		@retainUntil=RetainUntil, @attribute=Attribute, @backupSetId=BackupSetId ,@emailIds = emailIds
		FROM DM2CompliancePolicy
		WHERE CompPolicyID = @legalHoldId
		--allow OWNER of LH to perform Legal Hold operation based on gxglobalParam key
         DECLARE @allowOwnerForLHOperation INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'AllowOwnerForLHOperation' AND modified =0), 0)
		 IF @allowOwnerForLHOperation = 1
SELECT @isOwner = dbo.IsUserCreator(@i_userId, 9505, @id) -- @id is for legalHoldId and @legalHoldId is for guid
		--IF @i_operation = 2 	--DELETE
		--BEGIN
			IF ( @isAdmin <> 1  AND @isOwner <> 1)
			BEGIN
				SET @o_errorCode = 2
				SET @o_errorString = 'Only administrators can perform delete operation on Legal Hold [' + @compPolicyName + ']'
					RAISERROR (@o_errorString, -- Message text.
								16, -- Severity.
								1 -- State.
								)
				END
			IF EXISTS(SELECT * FROM SchedAdminComplianceXmlOptions
				WHERE xmlValue.exist('/director/options/legalHold[@legalHoldName=sql:variable("@compPolicyName")]') = 1 AND status & 1 <> 1)
			BEGIN
				DECLARE @policyName NVARCHAR(1024)
				SET @policyName = (SELECT TOP 1 policyName FROM SchedAdminComplianceXmlOptions WHERE xmlValue.exist('/director/options/legalHold[@legalHoldName=sql:variable("@compPolicyName")]') = 1 AND status & 1 <> 1)
				SET @o_errorString = 'Cannot perform operation on Legal Hold [' + @compPolicyName + '] it is being used by compliance policy [' + @policyName + ']'
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
			EXEC DM2PruneLegalHold @compPolicyName, @userGUID
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				SET @xmlOper = (SELECT @backupSetId '@backupSetId', @i_UserName '@userName', 1 '@useXml'
					FOR XML PATH('CVGui_DeleteBackupSetReq'))
				EXECUTE AppDeleteBackupSet @xmlOper
				SET @o_errorCode = ISNULL(( SELECT ref.value('@errorCode', 'INT')
											FROM @xmlOper . nodes('CVGui_DeleteBackupSetResp') R ( ref ) ), 0)
				SET @o_errorString = ISNULL(( SELECT ref.value('@errorString', 'NVARCHAR(1024)')
											FROM @xmlOper . nodes('CVGui_DeleteBackupSetResp') R ( ref ) ), 0)
				IF (@o_errorCode = 0)
				BEGIN
					-- SET GUI AUDIT OPERATION
					SET @opMsgId = (211 | (CAST(POWER(2, 24) AS BIGINT) * 84))
					EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @compPolicyName, @dataIsEvent
					SET @paramMsgId = (413 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				END
			END
			IF (@o_errorCode <> 0)
			BEGIN
				IF @o_errorString = ''
					SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		--END
		IF @i_operation = 4	--DISABLE
		BEGIN
			SET @attribute = (@attribute | 0x0008 )
			EXEC DM2UpdateLegalHold @compPolicyName, @compPolicyDesc, @retainUntil, @attribute, @userGUID, @modifyTime,@emailIds
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (213 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @compPolicyName, @dataIsEvent
				SET @paramMsgId = (414 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		ELSE IF @i_operation = 5	--ENABLE
		BEGIN
			SET @attribute = (@attribute & ~CAST(0x0008 as INT))
			EXEC DM2UpdateLegalHold @compPolicyName, @compPolicyDesc, @retainUntil, @attribute, @userGUID, @modifyTime, @emailIds
			SET @o_errorCode = @@error
			IF (@o_errorCode = 0)
			BEGIN
				-- SET GUI AUDIT OPERATION
				SET @opMsgId = (212 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
				-- SET GUI AUDIT PARAMETER
				EXEC EvGuiAuditSetParamData @opId, @compPolicyName, @dataIsEvent
				SET @paramMsgId = (415 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
			END
			ELSE
			BEGIN
				SET @o_errorString = ERROR_MESSAGE()
				RAISERROR (@o_errorString, -- Message text.
							16, -- Severity.
							1 -- State.
							)
			END
		END
		FETCH GetlhIdCursor INTO @id,@legalHoldId
	END
	CLOSE GetlhIdCursor
	DEALLOCATE GetlhIdCursor
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetlhIdCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetlhIdCursor') >= 0 )
	CLOSE GetlhIdCursor
	IF ( CURSOR_STATUS('global','GetlhIdCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetlhIdCursor') = -1 )
	DEALLOCATE GetlhIdCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	SELECT	1					as TAG,
		0					as Parent,
		@o_errorCode			as [CVGui_GenericResp!1!errorCode],
		@o_errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformLegalHoldDelete')
	delete from GxQscripts where name = 'DM2PerformLegalHoldDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformLegalHoldDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformLegalHoldDelete'
GO

insert into GXDBVersions values(2, 'DM2PerformLegalHoldDelete',  '00010020001200040000', 'DM2PerformLegalHoldDelete', '00010020001200040000')
GO

