

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformContainerOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformContainerOperation()
--  | Description:  Performs operations on Container (ADD,DISABLE,UPDATE, ...)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformContainerOperation.sp,v $ $Id: DM2PerformContainerOperation.sp,v 1.14.2.9 2020/08/18 21:46:13 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformContainerOperation')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformContainerOperation <<<'
	drop procedure DM2PerformContainerOperation
END
IF EXISTS (select * from GxQscripts where name='DM2PerformContainerOperation')
	delete from GxQscripts where name = 'DM2PerformContainerOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformContainerOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformContainerOperation'
GO
print '... Creating Procedure: DM2PerformContainerOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformContainerOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_userGUID			VARCHAR(36)
	DECLARE @i_operation		INT
	DECLARE @i_containerName			NVARCHAR(MAX)
	DECLARE @i_comment			NVARCHAR(MAX)
	DECLARE @i_containerGuid			VARCHAR(36)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @i_containerId					INT
	DECLARE @isOwner INT = 0
	DECLARE @entityType		INT
	DECLARE @o_xmlText XML
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
	DECLARE @userHasShareFolder	INT = 0
	DECLARE @cloudId			INT = 0
	DECLARE @permissionsList 	NVARCHAR(MAX)
	DECLARE @deDuplicateFields VARCHAR(MAX)
	DECLARE @Attribute			INT = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
BEGIN TRY
BEGIN TRAN
	SET	@i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerOperationReq') R(ref)), '')
	IF ( @i_userGUID IS NOT null AND @i_userGUID <> '' )
	BEGIN
		SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
	END
	ELSE IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET PARAM INPUTS
	SET @i_operation = ISNULL(( SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ContainerOperationReq') R ( ref ) ), 0)
	SET @i_containerName = ISNULL(( SELECT ref.value('@containerName', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ContainerOperationReq/container') R ( ref ) ), '')
	SET @i_comment = ISNULL(( SELECT ref.value('@comment', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ContainerOperationReq/container') R ( ref ) ), '')
	SET @i_containerGuid = ISNULL(( SELECT ref.value('@containerGuid', 'nvarchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ContainerOperationReq/container') R ( ref ) ), '')
	SET @i_containerId = ISNULL(( SELECT ref.value('@containerId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ContainerOperationReq/container') R ( ref ) ), 0)
	SET @entityType = ISNULL (( SELECT ref.value('@entityType', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerOperationReq') R(ref)), 0)
	SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerOperationReq/container') R(ref)), 0)
	SET @Attribute = ISNULL((SELECT ref.value('@attribute', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerOperationReq/container') R(ref)), 0)
	--
	-- Name of fields (comma separated) on which review set may be allowed to be de-duplicated
	--
	SET @deDuplicateFields = ISNULL (( SELECT ref.value('@deDuplicateFields', 'VARCHAR(MAX)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerOperationReq/container') R(ref)), '')
	DECLARE @canManageEntityType int = 0
	IF ( @i_operation = 1 )
	BEGIN
		INSERT INTO @t_userCaps
		EXECUTE GetUserCapabilities @i_userId
		SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ((@entityType = 9501) OR
(@entityType = 9502) OR
(@entityType = 9503) OR
(@entityType = 9514)
		)
		BEGIN
			--ALLOW FOR USE WITH SHARED FOLDER
			EXEC AppSharingDoesUserHaveSharedFolder @i_userId, @userHasShareFolder OUTPUT
IF ((@userCaps & CONVERT(bigint, (POWER(2.0, 24-1))) = 0) AND
(@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0) AND
(@userCaps & CONVERT(bigint, (POWER(2.0, 13-1))) = 0) AND
				@userHasShareFolder = 0)
			BEGIN
				SET @o_errorCode = -1
				SET @o_errorString = 'User does not have Compliance search or End user search or Browse rights'
				GOTO EXIT_ERROR
			END
		END
ELSE IF (@entityType = 9504)
		BEGIN
IF (@userCaps & CONVERT(bigint, (POWER(2.0, 27-1))) = 0) OR
((@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0) AND (@userCaps & CONVERT(bigint, (POWER(2.0, 24-1))) = 0))
			BEGIN
				SET @o_errorCode = -1
				SET @o_errorString = 'User need to have Tag management along with compliance or end user search rights.'
				GOTO EXIT_ERROR
			END
		END
		ELSE
		BEGIN
			SET @o_errorCode = -2
			SET @o_errorString = 'Invalid entity type passed.'
			GOTO EXIT_ERROR
		END
		SET @canManageEntityType = 1
	END
	ELSE
	BEGIN
		EXEC	[dbo].[sec_canManageDM2EntityType]
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @i_containerId,
			@o_canManageEntityType = @canManageEntityType OUTPUT
	END
	-- For create review set, legal hold etc, sec_canManageEntityType has corresponding checks
	-- For Modify operation, check is done using SP sec_canEditDM2EntityType little later below
	IF ( @i_operation = 1 AND @canManageEntityType <> 1 )
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have Container Management Rights'
		GOTO EXIT_ERROR
	END
	-- check if user is the admin
	DECLARE @isAdmin int = 0
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
	-- check if the user is the owner
	IF ( @isAdmin = 0 AND @i_operation <> 1 )
	BEGIN
		SELECT @isOwner = dbo.IsUserCreator(@i_userId, @entityType, @i_containerId)
	END
	IF ( @i_operation = 1 )	--ADD
	BEGIN
		--CHECK FOR TAG ALREADY EXISTING
		IF EXISTS(SELECT * FROM DM2Container WHERE containerName = @i_containerName and containerType = @entityType and userId = @i_userId)
		BEGIN
			SET @o_errorCode = 7
			SET @o_errorString = 'Container already exists'
			GOTO EXIT_ERROR
		END
		SET @i_containerGuid = NEWID()
		INSERT INTO DM2Container (containerGuid,containerName,containerType,userId,attribute,comment,origCommcellID, createTime, cloudId)
		VALUES (@i_containerGuid, @i_containerName, @entityType, @i_userId, @Attribute, @i_comment, 0, GETUTCDATE(), @cloudId)
		SET @o_errorCode = @@error
		IF @o_errorCode = 0
		BEGIN
			SELECT @i_containerId = SCOPE_IDENTITY()
			--
			-- Provide Change Security Settings and other owner permissions so that Share feature works with new security model
			--
SET @permissionsList = CAST(107 as nvarchar(10))
			EXEC sec_setDM2CreatorOwner @entityType, @i_userId, @i_containerId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
			--
			-- insert into DCEntityProperty for custom review set here..
			--
			if LEN(@deDuplicateFields) > 0
			BEGIN
				INSERT INTO DCEntityProperty (EntityType, EntityId, PropertyName, PropertyValue)
				SELECT @entityType, @i_containerId, 'DeduplicateFields', @deDuplicateFields
			END
		END
	END
	ELSE IF @i_operation = 3	--MODIFY
	BEGIN
		IF ( @isAdmin <> 1 AND @isOwner <> 1 )
		BEGIN
			DECLARE	@o_canEditEntityType int = 0
			EXEC sec_canEditDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @i_containerId,
			@o_canEditEntityType = @o_canEditEntityType OUTPUT
			IF ( @o_canEditEntityType <> 1 )
			BEGIN
				SET @o_errorCode = 1
				SET @o_errorString = 'User does not have Edit Container Rights'
				GOTO EXIT_ERROR
			END
		END
		--THIS ERROR SHOULD NOT HAPPEN
		IF (NOT EXISTS (SELECT * FROM DM2Container WHERE ContainerID = @i_containerId and containerType = @entityType))
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorString = 'Container id not found during modify operation'
			GOTO EXIT_ERROR
		END
		--
		-- System created sets (attribute with bit = 2 set) will not be allowed to be renamed
		--
		UPDATE DM2Container SET comment = @i_comment, containerName = CASE WHEN ISNULL(@i_containerName, '') <> '' AND attribute & 2 = 0 THEN @i_containerName ELSE containerName END WHERE ContainerID = @i_containerId
		SET @o_errorCode = @@error
	END
	ELSE
	BEGIN
		SET @o_errorCode = 9
		SET @o_errorString = 'Operation Type is missing'
	END
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
	END
	ELSE
	BEGIN
		-- if only id is given and guid not available, fetch from the table
		--
		IF ISNULL(@i_containerGuid, '') = '' and ISNULL(@i_containerId, 0) > 0
		BEGIN
			SELECT @i_containerGuid = ContainerGuid FROM DM2Container
			WHERE ContainerId = @i_containerId
		END
		SET @o_xmlText = (SELECT DISTINCT
			T.containerId '@containerId', T.ContainerGuid '@containerGuid', T.containerName '@containerName' , T.containerType '@containerType', T.Attribute '@attribute' , T.comment '@comment' , 1 '@containerOwnerType'
			FROM DM2Container AS T WHERE T.ContainerGuid = case when @i_containerGuid is null or @i_containerGuid = '' then newid() else @i_containerGuid end -- worst case scenario case statement helps not let a cast exception to occur here
			FOR XML PATH('container'), ROOT('DM2ContentIndexing_ContainerOperationResp'))
		IF @o_xmlText IS null
			SET @o_xmlText = '<DM2ContentIndexing_ContainerOperationResp/>'
		SELECT @o_xmlText
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformContainerOperation')
	delete from GxQscripts where name = 'DM2PerformContainerOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformContainerOperation')
	delete from GXDBVersions where aliasname = 'DM2PerformContainerOperation'
GO

insert into GXDBVersions values(2, 'DM2PerformContainerOperation',  '00010014000200090000', 'DM2PerformContainerOperation', '00010014000200090000')
GO

