

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2PerformContainerDelete.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2PerformContainerDelete()
--  | Description:  Performs deletion of Container
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2PerformContainerDelete.sp,v $ $Id: DM2PerformContainerDelete.sp,v 1.9.60.4 2020/08/18 21:46:10 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2PerformContainerDelete')
BEGIN
	print '>>> Drop Stored Procedure: DM2PerformContainerDelete <<<'
	drop procedure DM2PerformContainerDelete
END
IF EXISTS (select * from GxQscripts where name='DM2PerformContainerDelete')
	delete from GxQscripts where name = 'DM2PerformContainerDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformContainerDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformContainerDelete'
GO
print '... Creating Procedure: DM2PerformContainerDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2PerformContainerDelete
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
      DECLARE @i_userGUID                 VARCHAR(36)
      DECLARE @i_containerName                  NVARCHAR(255)
      DECLARE @o_errorCode          INT
      DECLARE @o_errorString        NVARCHAR(MAX)
      DECLARE @tmpErrorString       NVARCHAR(MAX)
      DECLARE @ContainerTable TABLE (id INT,
                                           containerId VARCHAR(36))
      DECLARE @entityType int
      DECLARE @i_id int = 0
BEGIN TRY
BEGIN TRAN
      SET @o_errorCode = 0
      SET @o_errorString = ''
      SET @tmpErrorString = ''
      INSERT INTO @ContainerTable
      SELECT ref.value('@containerId', 'INT'),ref.value('@containerGuid', 'VARCHAR(36)')
      FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerDeleteRequest/containers') R(ref)
      IF (@@ROWCOUNT = 0)
      BEGIN
            SET @o_errorCode = 1
            SET @o_errorString = 'Container list is empty'
            GOTO EXIT_ERROR
      END
      SET   @i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
                              FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerDeleteRequest/userInfo') R(ref)), '')
      IF ( @i_userGUID IS NOT null AND len(@i_userGUID) > 0 )
      BEGIN
            SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
      END
      ELSE IF @i_userId IS null OR @i_userId = 0
            BEGIN
            SET @o_errorCode = 2
            SET @o_errorString = 'Cannot determine the user id'
            GOTO EXIT_ERROR
      END
      --GET PARAM INPUTS
      SET @entityType = ISNULL (( SELECT ref.value('@entityType', 'INT')
            FROM  @i_xmlText.nodes ('DM2ContentIndexing_ContainerDeleteRequest') R(ref)), 0)
      -- check if user is the admin
      DECLARE @isAdmin int = 0
      EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isAdmin  OUTPUT
      -----------------
      --DELETE CONTAINERS
      -----------------
      DECLARE @containerId                VARCHAR(36)
      DECLARE @id INT
      DECLARE     @o_canDeleteEntityType int = 0
      DECLARE @attr INT = 0
      DECLARE     GetContainerIdCursor    CURSOR FOR
      SELECT id,containerId FROM @ContainerTable
      OPEN GetContainerIdCursor
      FETCH GetContainerIdCursor INTO @id,@containerId
      WHILE @@FETCH_STATUS = 0
      BEGIN
	    IF ISNULL(@containerId, '') = '' AND ISNULL(@id, 0) > 0
	    BEGIN
		SELECT @containerId = ContainerGuid FROM DM2Container WHERE containerid = @id
	    END
            SELECT @i_containerName = ContainerName, @attr = attribute FROM DM2Container WHERE containerGuid = @containerId
	    IF @attr & 2 = 2
	    BEGIN
		SET @o_errorCode = 4
		SET @o_errorString = 'User not allowed to delete system created container [' + @i_containerName + ']'
		RAISERROR (@o_errorString, -- Message text.
				  16, -- Severity.
				  1 -- State.
				  )
	    END
            IF ( @isAdmin <> 1 )
            BEGIN
                  SET @o_canDeleteEntityType  = 0
                  EXEC sec_canDeleteDM2EntityType
                        @i_commcellId = null,
                        @i_userId = @i_userId,
                        @i_entityType = @entityType,
                        @i_entityId = @id,
                        @o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
                  IF ( @o_canDeleteEntityType <> 1 )
                  BEGIN
                        SET @o_errorCode = 3
                        SET @o_errorString = 'User cannot perform operation on Container id [' + @i_containerName + ']'
                        RAISERROR (@o_errorString, -- Message text.
                                          16, -- Severity.
                                          1 -- State.
                                          )
                  END
            END
IF @entityType = 9504
			BEGIN
				DELETE DM2DocTags WHERE containerGuid = @containerId
			END
			DELETE DCEntityProperty WHERE entityId = @id and entityType = @entityType
            DELETE DM2Container WHERE containerGuid = @containerId
            SET @o_errorCode = @@error
            IF (@o_errorCode <> 0)
            BEGIN
                  SET @o_errorString = ERROR_MESSAGE()
                  RAISERROR (@o_errorString, -- Message text.
                                    16, -- Severity.
                                    1 -- State.
                                    )
            END
            FETCH GetContainerIdCursor INTO @id,@containerId
      END
      CLOSE GetContainerIdCursor
      DEALLOCATE GetContainerIdCursor
      COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
      -- Call procedure to print error information.
      -- Call procedure to get error information.
      EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT
      --Close cursor
      IF ( CURSOR_STATUS('global', 'GetContainerIdCursor') >= 0  /* cursor is open */
            OR CURSOR_STATUS('local', 'GetContainerIdCursor') >= 0 )
      CLOSE GetContainerIdCursor
      IF ( CURSOR_STATUS('global','GetContainerIdCursor') = -1  /* cursor is closed */
            OR CURSOR_STATUS('local','GetContainerIdCursor') = -1 )
      DEALLOCATE GetContainerIdCursor
      -- Rollback any active or uncommittable transactions before
      -- inserting information in the ErrorLog
      IF XACT_STATE() <> 0
      BEGIN
            ROLLBACK TRAN;
      END
END CATCH;
EXIT_ERROR:
      SELECT      1                             as TAG,
            0                             as Parent,
            @o_errorCode                  as [CVGui_GenericResp!1!errorCode],
            @o_errorString                as [CVGui_GenericResp!1!errorMessage]
      FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2PerformContainerDelete')
	delete from GxQscripts where name = 'DM2PerformContainerDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2PerformContainerDelete')
	delete from GXDBVersions where aliasname = 'DM2PerformContainerDelete'
GO

insert into GXDBVersions values(2, 'DM2PerformContainerDelete',  '00010009006000040000', 'DM2PerformContainerDelete', '00010009006000040000')
GO

