

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2MigrateWebServerSetting.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2MigrateWebServerSetting.sp,v $ $Id: DM2MigrateWebServerSetting.sp,v 1.1.2.1 2020/06/25 03:54:05 sgolla Exp $";
--	+===================================================================================+
--	|  					  DM2MigrateWebServerSetting								|
--	|  Migrate web server setting that was stored in DMSetting to the advance setting at web server client level.
--	|  If setting already found, this procedure does nothing and returns existing value of setting.
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2MigrateWebServerSetting')
BEGIN
	print '>>> Drop Stored Procedure: DM2MigrateWebServerSetting <<<'
	drop procedure DM2MigrateWebServerSetting
END
IF EXISTS (select * from GxQscripts where name='DM2MigrateWebServerSetting')
	delete from GxQscripts where name = 'DM2MigrateWebServerSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2MigrateWebServerSetting')
	delete from GXDBVersions where aliasname = 'DM2MigrateWebServerSetting'
GO
print '... Creating Procedure: DM2MigrateWebServerSetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2MigrateWebServerSetting
  @i_SettingName nvarchar(100),
  @i_ClientId int,
  @i_SettingValue nvarchar(max),
  @i_SettingType nvarchar(40),
  @i_RelativePath nvarchar(256) = 'DM2WebSearchServer'
AS
BEGIN
	DECLARE @exVal NVARCHAR(MAX)
	SELECT @exVal = value FROM App_AdvanceSettings
WHERE keyname = @i_SettingName AND entityType = 3 AND entityId = @i_ClientId and relativePath = @i_RelativePath
	IF @exVal IS NULL
	BEGIN
		INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
SELECT @i_ClientId, @i_SettingName, @i_SettingType, @i_RelativePath, @i_SettingValue, 1, 0, 3, 0, 0
		IF @@ERROR = 0
		BEGIN
			DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
            INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
            SELECT @i_ClientId, -1, 6, '', @now, 0, 0, 0 -- WORK_TOKEN_REGISTRY
			--
			-- INSERTING work queue will help quickly sync registry without which we may have to wait until cvd restart
			--
			SELECT @i_SettingValue SettingValue, 'Created setting successfully' OperationMessage
		END
		ELSE
		BEGIN
			SELECT NULL SettingValue, 'Failed to create' OperationMessage
		END
	END
	ELSE
	BEGIN
		SELECT @exVal SettingValue, 'Setting already exists' OperationMessage
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2MigrateWebServerSetting')
	delete from GxQscripts where name = 'DM2MigrateWebServerSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2MigrateWebServerSetting')
	delete from GXDBVersions where aliasname = 'DM2MigrateWebServerSetting'
GO

insert into GXDBVersions values(2, 'DM2MigrateWebServerSetting',  '00010001000200010000', 'DM2MigrateWebServerSetting', '00010001000200010000')
GO

