

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2MetaDataSourceProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2MetaDataSourceProp.sp,v $ $Id: DM2MetaDataSourceProp.sp,v 1.1.2.1 2020/01/23 12:44:25 jraju Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get/Set dbProps from the dataSourceProperty
---- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2MetaDataSourceProp')
BEGIN
	print '>>> Drop Stored Procedure: DM2MetaDataSourceProp <<<'
	drop procedure DM2MetaDataSourceProp
END
IF EXISTS (select * from GxQscripts where name='DM2MetaDataSourceProp')
	delete from GxQscripts where name = 'DM2MetaDataSourceProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2MetaDataSourceProp')
	delete from GXDBVersions where aliasname = 'DM2MetaDataSourceProp'
GO
print '... Creating Procedure: DM2MetaDataSourceProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2MetaDataSourceProp
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml XML
AS
BEGIN
  DECLARE @outputXml XML 
	SET NOCOUNT ON
	DECLARE @opType INT
	DECLARE	@dataSourceId	INT
	DECLARE @errorCode	INT = 0
	DECLARE @errorMsg	NVARCHAR(MAX) = ''
	DECLARE @dbProp		XML
	DECLARE @propertyId	INT = ISNULL((SELECT PropertyId From SEProperty(NOLOCK) Where PropertyName = 'metaidxinfo'), 0)
	SET @opType = ISNULL (( SELECT ref.value('@opType', 'INTEGER')FROM @inputXml.nodes('Indexing_CollectionDbProps') R(ref)), 0)
	SET @dataSourceId = ISNULL (( SELECT ref.value('@dataSourceId', 'INTEGER')FROM @inputXml.nodes('Indexing_CollectionDbProps') R(ref)), 0)
	IF @dataSourceId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorMsg = 'Invalid input'
		GOTO FINISH
	END
	IF @opType = 0 -- GET
	BEGIN
		SET @dbProp = (SELECT PropertyValue FROM SEDataSourceProperty WHERE dataSourceId = @dataSourceId and PropertyId = @propertyId)
		SET @outputXml = '<Indexing_CollectionDbProps><errorResp errorCode="0"></errorResp></Indexing_CollectionDbProps>'
		SET @outputXml.modify('insert sql:variable("@dbProp") as first into (/Indexing_CollectionDbProps)[1]')
	END
	ELSE
	BEGIN
		SET @dbProp	= ISNULL((SELECT @inputXml.query('/Indexing_CollectionDbProps/*')), '<dbProps/>')
		IF EXISTS(SELECT 1 FROM SEDataSourceProperty WHERE dataSourceId = @dataSourceId and PropertyId = @propertyId)
		BEGIN
			UPDATE SEDataSourceProperty
			SET propertyValue = CAST(@dbProp AS NVARCHAR(MAX)),
			modifiedTime = GETUTCDATE()
			WHERE dataSourceId = @dataSourceId and PropertyId = @propertyId
		END
		ELSE
		BEGIN
			INSERT INTO SEDataSourceProperty(dataSourceId, propertyId, propertyValue)
			VALUES(@dataSourceId, @propertyId, CAST(@dbProp AS NVARCHAR(MAX)))
		END
	END
FINISH:
	IF @outputXml IS NULL
	BEGIN
		SET @outputXml = (
						SELECT
						(
							SELECT
							@errorCode '@errorCode',
							@errorMsg '@message'
							FOR XML PATH('errorResp'), TYPE
						) FOR XML PATH('Indexing_CollectionDbProps'), TYPE
					  )
	END
	SELECT @outputXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2MetaDataSourceProp')
	delete from GxQscripts where name = 'DM2MetaDataSourceProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2MetaDataSourceProp')
	delete from GXDBVersions where aliasname = 'DM2MetaDataSourceProp'
GO

insert into GXDBVersions values(2, 'DM2MetaDataSourceProp',  '00010001000200010000', 'DM2MetaDataSourceProp', '00010001000200010000')
GO

