

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetWebServerXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetWebServerXML.sp,v $ $Id: DM2GetWebServerXML.sp,v 1.1.2.16 2020/05/19 18:45:20 pankajkumar Exp $";
--
--  +========================================================================+
--  |      Cursor:  DM2GetWebServerXML()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetWebServerXML')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetWebServerXML <<<'
	drop procedure DM2GetWebServerXML
END
IF EXISTS (select * from GxQscripts where name='DM2GetWebServerXML')
	delete from GxQscripts where name = 'DM2GetWebServerXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetWebServerXML')
	delete from GXDBVersions where aliasname = 'DM2GetWebServerXML'
GO
print '... Creating Procedure: DM2GetWebServerXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetWebServerXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tmpClientTbl') IS NOT null DROP TABLE #tmpClientTbl
	CREATE TABLE #tmpClientTbl (t_clientId INT)
IF object_id('tempdb.dbo.#tmpClientIPAddressTbl') IS NOT null DROP TABLE #tmpClientIPAddressTbl
	CREATE TABLE #tmpClientIPAddressTbl (t_clientId INT, t_ipAddress VARCHAR(64))
--get all applicable clients
INSERT INTO #tmpClientTbl (t_clientId)
SELECT DISTINCT clientId from simInstalledPackages WITH (nolock)
WHERE SimPackageId IN (	51,
252,
1174,
729,
1108,
1301,
55,
1306,
20 ,
263,
725,
801)
DECLARE @serviceType INT;
SET @serviceType = ISNULL(( SELECT ref.value('@serviceType', 'int')
							FROM @i_xmlText.nodes('EVGui_GetWebServerListReq') R ( ref ) ), 0)
IF @serviceType = 3   -- EVGui::ServiceType_MessageQueue
BEGIN
	--include webconsole clients
	INSERT INTO #tmpClientTbl (t_clientId)
	SELECT DISTINCT clientId from simInstalledPackages
WHERE SimPackageId IN (726, 1135)
	AND clientId NOT IN (select t_clientId from #tmpClientTbl)
	--Whitelist IPD Commcell on all service commcells in multi commcell environment.
	INSERT INTO #tmpClientIPAddressTbl
	SELECT CC.clientId, data FROM APP_CommCell CC
       INNER JOIN App_ThirdPartyApp TPA
              ON TPA.appName = CC.csGUID
              AND TPA.appType = 3
       INNER JOIN APP_ClientProp CSIP
              ON CC.clientId = CSIP.componentNameId
              AND CSIP.modified = 0
              AND attrName = N'AllNicIpAddress'
		CROSS APPLY dbo.SplitString(CSIP.attrVal, ',')
	UNION
	SELECT MQIP.componentNameId, data FROM APP_CommCell CC
       INNER JOIN App_ThirdPartyApp TPA
              ON TPA.appName = CC.csGUID
              AND TPA.appType = 3
       INNER JOIN APP_ClientProp MQIP
              ON CC.clientId = MQIP.componentNameId
              AND MQIP.modified = 0
              AND MQIP.attrName = N'Default Message Queue Client AllNicIpAddress'
		CROSS APPLY dbo.SplitString(MQIP.attrVal, ',')
END
IF @serviceType = 0  --For 11.0 SP12 or lesser, provide hostname
	INSERT INTO #tmpClientIPAddressTbl
	SELECT DISTINCT C.Id, C.net_hostName
	FROM APP_Client C (NOLOCK)
	JOIN #tmpClientTbl T ON C.Id= t.t_clientId
ELSE
BEGIN
	INSERT INTO #tmpClientIPAddressTbl (t_clientId, t_ipAddress)
	SELECT DISTINCT CP.componentNameId, data
	FROM APP_ClientProp CP (NOLOCK)
	JOIN #tmpClientTbl T ON CP.componentNameId= t.t_clientId
	CROSS APPLY dbo.SplitString(CP.attrVal, ',')
	WHERE CP.attrName = 'AllNicIpAddress' AND LEN(CP.attrval)>0 AND LEN(data)>0
	--include hostname for clients which are SP12 or lower
	--CVD will figure out ipaddress these clients
	INSERT INTO #tmpClientIPAddressTbl (t_clientId, t_ipAddress)
	SELECT DISTINCT C.Id, C.net_hostName
	FROM APP_Client C (NOLOCK)
	JOIN #tmpClientTbl T ON C.Id= t.t_clientId
	LEFT JOIN #tmpClientIPAddressTbl IP ON T.t_clientId = IP.t_clientId
	WHERE IP.t_clientId IS NULL
END
--GET public ip (v4 /v6) mentioned in app_client table
--avoid duplicate ipaddress
INSERT INTO #tmpClientIPAddressTbl (t_clientId, t_ipAddress)
SELECT C.id, net_HostName
FROM APP_Client C
JOIN #tmpClientTbl T ON C.Id= t.t_clientId
LEFT JOIN #tmpClientIPAddressTbl IP ON C.net_HostName = IP.t_ipAddress
WHERE (net_HostName like '%[0-9]%.%[0-9]%.%[0-9]%.%[0-9]%'
	OR  CHARINDEX(':',net_HostName)>0 ) and IP.t_ipAddress IS NULL
SET @o_xmlText = ( 	SELECT
	(SELECT  DISTINCT C.t_clientId '@webServerId', C.t_ipAddress  '@webServerHostName'
				FROM #tmpClientIPAddressTbl AS C
			FOR XML PATH('webServersList'), TYPE
			)
			FOR XML  PATH('EVGui_GetWebServerListResp'), TYPE )
IF @o_xmlText IS NULL
    SET @o_xmlText = '<EVGui_GetWebServerListResp/>'
SELECT @o_xmlText AS [o_xmlText]
IF object_id('tempdb.dbo.#tmpClientTbl') IS NOT null DROP TABLE #tmpClientTbl
IF object_id('tempdb.dbo.#tmpClientIPAddressTbl') IS NOT null DROP TABLE #tmpClientIPAddressTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetWebServerXML')
	delete from GxQscripts where name = 'DM2GetWebServerXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetWebServerXML')
	delete from GXDBVersions where aliasname = 'DM2GetWebServerXML'
GO

insert into GXDBVersions values(2, 'DM2GetWebServerXML',  '00010001000200160000', 'DM2GetWebServerXML', '00010001000200160000')
GO

