

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetTagList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetTagList()
--  | Description:  Gets list of Tags
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetTagList.sp,v $ $Id: DM2GetTagList.sp,v 1.19.274.3 2018/03/27 08:47:32 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetTagList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetTagList')
	drop procedure DM2GetTagList
IF EXISTS (select * from GxQscripts where name='DM2GetTagList')
	delete from GxQscripts where name = 'DM2GetTagList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetTagList')
	delete from GXDBVersions where aliasname = 'DM2GetTagList'
GO
print '... Creating Procedure: DM2GetTagList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetTagList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_Attribute		INT
	DECLARE @i_Flags			INT
	DECLARE @i_isTableOut		INT
	DECLARE @i_useDisabled		INT
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_userGUID			VARCHAR(36)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @i_viewTags INT = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	IF object_id('tempdb.dbo.#tmpInputContainerListTbl') is not null
					DROP TABLE #tmpInputContainerListTbl
	CREATE TABLE #tmpInputContainerListTbl (  t_containerId	integer, t_containerGuid varchar(36) )
	SET	@i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq') R(ref)), '')
	IF ( len(@i_userGUID) > 0 )
	BEGIN
		SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID and enabled = 1)
	END
	IF ( @i_userId = 0 )
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorString = 'User not found or specified'
		GOTO EXIT_ERROR
	END
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_capability = 31
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetTagsReq') R ( ref ) ), @i_UserName)
	SET @i_useDisabled = ISNULL (( SELECT ref.value('@disabled', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq') R(ref)), 0)
	SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq') R(ref)), 0)
	SET @i_Attribute = ISNULL (( SELECT ref.value('@attribute', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq') R(ref)), 0)
	SET @i_Flags = ISNULL (( SELECT ref.value('@flags', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq') R(ref)), 0)
					--GET INPUT CONTAINERS
	INSERT INTO #tmpInputContainerListTbl (  t_containerId, t_containerGuid )
	SELECT ref.value('@containerId', 'integer'), ref.value('@containerGuid', 'varchar(36)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq/containers') R(ref)
	IF (SELECT COUNT(*) FROM #tmpInputContainerListTbl) > 0
	BEGIN
		UPDATE #tmpInputContainerListTbl SET t_containerGuid = DMC.containerGuid
		FROM DM2Container AS DMC INNER JOIN #tmpInputContainerListTbl  AS T ON DMC.containerId = T.t_containerId
		WHERE T.t_containerId IS NOT null AND T.t_containerId > 0
		UPDATE #tmpInputContainerListTbl SET t_containerId = DMC.containerId
		FROM DM2Container AS DMC INNER JOIN #tmpInputContainerListTbl  AS T ON DMC.containerGuid = T.t_containerGuid
		WHERE T.t_containerGuid IS NOT null
	END
	--GET USER RIGHTS
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetTagsReq/groups') R(ref)
	EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, @i_domainName, #tmpextGroupListTbl, #dm2UserObjectsTbl
	IF EXISTS (SELECT * FROM #dm2UserObjectsTbl WHERE commCellId = 2 )
	BEGIN
		SET @i_viewTags = 1
	END
DECLARE @entityType INT = 9504
	-- User can view all tags if he has any sharing rights at Commcell level or Tag node level
	IF ( @i_viewTags = 0 )
	BEGIN
		DECLARE	@o_canDeleteEntityType int = 0
		DECLARE @o_canEditEntityType int = 0
		EXEC sec_canDeleteDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
		IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 )
			SET @i_viewTags = 1
	END
		IF (@i_isTableOut <> 0)
		BEGIN
			SELECT C.containerId AS containerId, T.containerGuid AS containerGuid, C.containerName AS containerName, containerType AS containerType, C.attribute AS attribute,
				C.comment AS comment, U.userGuid AS userGuid, U.name AS userName, U.login AS aliasName,
				T.id AS tagId, T.TagID AS id, T.TagValue AS name, T.TagDesc AS description, T.Attribute AS attribute, T.Attribute AS flags
			FROM DM2DocTags AS T INNER JOIN #tmpInputContainerListTbl AS A
				ON T.containerGuid = A.t_containerGuid
				INNER JOIN DM2Container AS C ON C.containerGuid = A.t_containerGuid
				INNER JOIN UMUsers AS U ON U.id = C.userId
			WHERE (@i_Flags = 0 OR (@i_Flags & T.Attribute) = @i_Flags) AND
				(T.Attribute & 0x0010 <> 0x0010)
		END
		ELSE
		BEGIN
			SET @i_xmlText =
			(
				SELECT
					(
						SELECT C.containerId '@containerId', C.containerGuid '@containerGuid', C.containerName '@containerName', containerType '@containerType',
							C.attribute '@attribute', C.comment AS '@comment', U.userGuid 'ownerInfo/@userGuid', U.name 'ownerInfo/@userName', U.login 'ownerInfo/@aliasName'
						FOR XML PATH('container'),TYPE
					),
					(
						SELECT T.id '@tagId', T.TagID '@id', T.TagValue '@name', T.TagDesc '@description', 1 '@tagOwnerType', T.Attribute '@flags',
						(SELECT TE.Attribute '@val' from dm2doctags te where te.TagID = t.TagID FOR XML PATH('attribute'), TYPE)
					        FROM DM2DocTags AS T
						WHERE T.containerGuid = C.containerGuid AND
						(@i_Flags = 0 OR (@i_Flags & T.Attribute) = @i_Flags) AND
					        (T.Attribute & 0x0010 <> 0x0010)
						FOR XML PATH('tags'),TYPE
				)
				FROM #tmpInputContainerListTbl AS A INNER JOIN DM2Container AS C ON C.containerGuid = A.t_containerGuid
					INNER JOIN UMUsers AS U ON U.id = C.userId
				WHERE A.t_containerGuid = C.containerGuid
			FOR XML PATH('containerTags'), ROOT('DM2ContentIndexing_GetTagsResp')
		)
			IF @i_xmlText IS null
			SET @i_xmlText = '<DM2ContentIndexing_GetTagsResp/>'
			SELECT @i_xmlText
	END
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			SELECT CAST(@o_errorCode AS VARCHAR(36)) AS TagID, @o_errorString AS name, '' AS description, 0 AS attribute
		END
		ELSE
		BEGIN
			SELECT	1					as TAG,
				0					as Parent,
				@o_errorCode			as [CVGui_GenericResp!1!errorCode],
				@o_errorString			as [CVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetTagList')
	delete from GxQscripts where name = 'DM2GetTagList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetTagList')
	delete from GXDBVersions where aliasname = 'DM2GetTagList'
GO

insert into GXDBVersions values(2, 'DM2GetTagList',  '00010019027400030000', 'DM2GetTagList', '00010019027400030000')
GO

