

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetSharePointClientProp.sp] ---------- 

--  +========================================================================+
--  | Name:  DM2GetSharePointClientProp()
--  | Description:  Returns properties for share point client
--  +========================================================================+
-- dataServer_h_rcsid[]="$ $Id: DM2GetSharePointClientProp.sp,v 1.2.276.1 2018/03/27 09:07:10 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetSharePointClientProp <<<'

IF EXISTS (select * from sysobjects where name='DM2GetSharePointClientProp')
	drop procedure DM2GetSharePointClientProp
IF EXISTS (select * from GxQscripts where name='DM2GetSharePointClientProp')
	delete from GxQscripts where name = 'DM2GetSharePointClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetSharePointClientProp')
	delete from GXDBVersions where aliasname = 'DM2GetSharePointClientProp'
GO
print '... Creating Procedure: DM2GetSharePointClientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetSharePointClientProp
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId INT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_errorCode 		INT = 0
	DECLARE @o_errorString 		NVARCHAR(MAX) = N'Success'
	DECLARE @o_xmlText		XML
	DECLARE @userName		NVARCHAR(MAX)
	DECLARE @password		NVARCHAR(MAX)
	DECLARE @clientName		NVARCHAR(MAX)
	DECLARE @hostName		NVARCHAR(MAX)
	SET @userName = (SELECT attrVal FROM App_ClientProp
					WHERE componentNameId = @i_clientId AND attrName = 'SharePoint WebService User name')
	SET @password = (SELECT attrVal  FROM App_ClientProp
					WHERE componentNameId = @i_clientId AND attrName = 'SharePoint WebService User password')
	SET @clientName = (SELECT name  FROM App_Client WHERE id = @i_clientId)
	SET @hostName = (SELECT csHostName  FROM App_Client WHERE id = @i_clientId)
	SET @o_xmlText = (
		SELECT
		attrVal '@cIServerURL',
		@clientName '@clientName',
		@hostName '@hostName',
		@userName 'credentials/@userName',
		@password 'credentials/@password'
		FROM App_ClientProp
		WHERE componentNameId = @i_clientId AND attrName = 'SharePoint WebService URL'
		FOR XML PATH('DM2ContentIndexing_CIServer'), TYPE
	)
	SELECT @o_xmlText
EXIT_ERROR:
	IF (@o_errorCode <> 0)
	BEGIN
		SELECT	@o_errorCode			as 'errList/@errorCode',
			@o_errorString			as 'errList/@errLogMessage'
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GenericResp')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetSharePointClientProp')
	delete from GxQscripts where name = 'DM2GetSharePointClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetSharePointClientProp')
	delete from GXDBVersions where aliasname = 'DM2GetSharePointClientProp'
GO

insert into GXDBVersions values(2, 'DM2GetSharePointClientProp',  '00010002027600010000', 'DM2GetSharePointClientProp', '00010002027600010000')
GO

