

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetSMTPAddressSuggestion.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetSMTPAddressSuggestion()
--  | Description:  Returns the matching the SMTP address for the input value based on paging info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetSMTPAddressSuggestion.sp,v $ $Id: DM2GetSMTPAddressSuggestion.sp,v 1.3.208.2 2019/01/31 16:17:41 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetSMTPAddressSuggestion')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetSMTPAddressSuggestion <<<'
	drop procedure DM2GetSMTPAddressSuggestion
END
IF EXISTS (select * from GxQscripts where name='DM2GetSMTPAddressSuggestion')
	delete from GxQscripts where name = 'DM2GetSMTPAddressSuggestion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetSMTPAddressSuggestion')
	delete from GXDBVersions where aliasname = 'DM2GetSMTPAddressSuggestion'
GO
print '... Creating Procedure: DM2GetSMTPAddressSuggestion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetSMTPAddressSuggestion
  @inputVal NVARCHAR(2048),
  @offset INT = 0,
  @pageSize INT = 30
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	--local variables
	DECLARE @startIndex INT = 0,
			@endIndex	INT = -1
	--revalidate the input paging config
	SELECT @pageSize = CASE WHEN (@pageSize <= 0) THEN 30
							ELSE @pageSize
							END,
			@offset = CASE WHEN (@offset <= 0) THEN 1
							ELSE @offset
							END;
	--Assign Start index and endindex
	SELECT @startIndex = @offset,
			@endIndex = @startIndex + @pageSize
	SELECT @inputVal = REPLACE(@inputVal , '*','%') + '%';
	WITH CTE_GetSuggestion (name,rowNumber)
	AS
	(
		SELECT name, ROW_NUMBER() OVER (ORDER BY name asc) AS rowNumber FROM APP_GUID
			WHERE name NOT LIKE 'CN=%' AND
					name LIKE '%@%' AND
					name LIKE @inputVal
	)
	SELECT name FROM CTE_GetSuggestion
	WHERE rowNumber >= @startIndex AND rowNumber < @endIndex;
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetSMTPAddressSuggestion')
	delete from GxQscripts where name = 'DM2GetSMTPAddressSuggestion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetSMTPAddressSuggestion')
	delete from GXDBVersions where aliasname = 'DM2GetSMTPAddressSuggestion'
GO

insert into GXDBVersions values(2, 'DM2GetSMTPAddressSuggestion',  '00010003020800020000', 'DM2GetSMTPAddressSuggestion', '00010003020800020000')
GO

