

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetReviewSetList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetReviewSetList()
--  | Description:  Gets list of Containers
--  +========================================================================+
-- dataServer_h_rcsid[]="$ $Id: DM2GetReviewSetList.sp,v 1.7.274.4.14.1 2021/01/22 00:15:40 sgolla Exp $";
-- Recompile with force macro change
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2GetReviewSetList')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetReviewSetList <<<'
	drop procedure DM2GetReviewSetList
END
IF EXISTS (select * from GxQscripts where name='DM2GetReviewSetList')
	delete from GxQscripts where name = 'DM2GetReviewSetList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetReviewSetList')
	delete from GXDBVersions where aliasname = 'DM2GetReviewSetList'
GO
print '... Creating Procedure: DM2GetReviewSetList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2GetReviewSetList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_Attribute		INT
	DECLARE @i_isTableOut		INT
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @AllCaps 				BIGINT
	DECLARE @i_entityType		INT
	DECLARE @isUserAdmin		INT
	DECLARE @ViewCapBit			BIGINT
	DECLARE @OthersCaps			BIGINT
	DECLARE @DuplicatesProp		VARCHAR(50) = 'DeDuplicateFields'
	DECLARE @DataSourceIdProp	VARCHAR(50) = 'DataSourceId'
	DECLARE @HandlerIdProp		VARCHAR(50) = 'HandlerId'
	DECLARE @RequestedContainers TABLE (containerId INT)
	DECLARE @AllContainers		SMALLINT = 0
	DECLARE @ContainerList 		TABLE( containerId INT, ContainerGuid nvarchar(max), containerName nvarchar(max), createTime int,
								containerType INT, Attribute INT, comment nvarchar(max), containerOwnerType INT,
								Caps BIGINT, name nvarchar(max), userGuid nvarchar(max), login nvarchar(max), DeDuplicateFields varchar(max) null default '',
								DataSourceId varchar(max) null default '', HandlerId varchar(max) null default '')
	SET @AllCaps = (SELECT SUM(POWER(2.0, id-1)) FROM UMCapability)
	SELECT @ViewCapBit = POWER(2.0, (Id-1)) FROM UMCapability WHERE name = 'View'
	-- check if user is the admin
	EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
	-- Depending upon admin or not, containers falling into others category, user will have appopriate permissions
	SELECT @OthersCaps = (CASE WHEN @isUserAdmin = 1 THEN @AllCaps ELSE @ViewCapBit END)
	DECLARE @i_getContainersOptions INT = 0 -- 1 - Get owned containers only, 2 - Get Shared Containers only, 3 - Get others containers based on view capabilities
	DECLARE @i_viewContainers INT = 0
	SET @o_errorCode = 0
	SET @o_errorString = ''
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetContainersReq') R ( ref ) ), @i_UserName)
	SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
	SET @i_Attribute = ISNULL (( SELECT ref.value('@attribute', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
	SET @i_getContainersOptions = ISNULL (( SELECT ref.value('@getContainerOptions', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
	SET @i_entityType = ISNULL (( SELECT ref.value('@entityType', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
	--
	-- For now, admin/master users can see tags in entire comm-cell.
	-- This is because security stored procs work this way only.
	--
	IF @isUserAdmin = 1 AND @i_getContainersOptions = 4
	BEGIN
		SET @i_getContainersOptions = 0
	END
	INSERT INTO @RequestedContainers (containerId)
	SELECT ref.value('@containerId', 'INT') FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq/containers') R(ref)
	IF NOT EXISTS (SELECT 1 FROM @RequestedContainers)
	BEGIN
		SET @AllContainers = 1
	END
	--GET USER RIGHTS
	SET @i_viewContainers = 0
	EXEC	sec_canViewDM2EntityType
		@i_commcellId = NULL,
		@i_userId = @i_userId,
		@i_entityType = @i_entityType,
		@i_entityId = 0,
		@o_canViewEntityType = @i_viewContainers OUTPUT
	IF OBJECT_ID('tempdb.dbo.#DM2GetContainerList_userObject_SET_ID') IS NOT null
			DROP TABLE #DM2GetContainerList_userObject_SET_ID
create table  #DM2GetContainerList_userObject_SET_ID ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#DM2GetContainerList_userObject_SET_ID'
	-- User can view all containers if he has any sharing rights at Commcell level or Container node level
	IF ( @i_viewContainers = 0 )
	BEGIN
		DECLARE	@o_canDeleteEntityType int = 0
		DECLARE @o_canEditEntityType int = 0
		DECLARE @o_canExecuteEntityType int = 0
		DECLARE @o_canRestoreEntityType int = 0
		EXEC sec_canDeleteDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @i_entityType,
		@i_entityId = 0,
		@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @i_entityType,
		@i_entityId = 0,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
IF ( @i_entityType = 9502 )
			EXEC sec_canExecuteDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @i_entityType,
			@i_entityId = 0,
			@o_canExecuteEntityType = @o_canExecuteEntityType OUTPUT
IF ( @i_entityType = 9501 OR @i_entityType = 9503)
			EXEC sec_canRestoreDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @i_entityType,
			@i_entityId = 0,
			@o_canRestoreEntityType = @o_canRestoreEntityType OUTPUT
IF ( @i_entityType = 9501 OR @i_entityType = 9503)
			IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 OR @o_canRestoreEntityType > 0 )
				SET @i_viewContainers = 1
ELSE IF ( @i_entityType = 9502 )
			IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 OR @o_canExecuteEntityType > 0 )
				SET @i_viewContainers = 1
ELSE IF ( @i_entityType = 9504 )
			IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 )
				SET @i_viewContainers = 1
	END
	IF ( @i_getContainersOptions = 0 ) -- get all containers based on user capabilities ( owned and shared containers are retrieved irrespective of capabilities )
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			BEGIN
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute , T.comment as comment, 1 AS containerOwnerType,
								@AllCaps AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								ISNULL((SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = 				@i_entityType), '') as deDuplicateFields, ISNULL((SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = 	@i_entityType), '') as dataSourceId, ISNULL((SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = 	@i_entityType), '') as handlerId
				FROM DM2Container AS T
				LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
				INNER JOIN UMUsers U ON U.id = T.userId
				WHERE T.userId = @i_userId AND (@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute) AND
					(T.Attribute & 0x0010 <> 0x0010) AND containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				UNION ALL
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute , T.comment as comment, 2 AS containerOwnerType,
								UUG.capabilities AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
                                        INNER JOIN UMUsers U ON U.id = T.userId
INNER JOIN #DM2GetContainerList_userObject_SET_ID UUG ON UUG.reviewSetId = T.containerId
					WHERE  (@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute) AND
					(T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType AND T.userId <> @i_userId
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				UNION ALL
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute ,T.comment as comment, 3 AS containerOwnerType,
								@OthersCaps AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
					INNER JOIN UMUsers U ON U.id = T.userId
					WHERE @i_viewContainers = 1 AND T.userId <> @i_userId
AND T.containerId NOT in ( SELECT reviewSetId FROM #DM2GetContainerList_userObject_SET_ID  )
					AND (@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute)
					AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
			END
		END
		ELSE
		BEGIN
			insert into  @ContainerList
				SELECT	T.containerId , T.ContainerGuid , T.containerName , dbo.GetUnixTime(T.createTime) ,
								T.containerType , T.Attribute , T.comment , 1 ,
								@AllCaps , U.name , U.userGuid , U.login, '' as DeDuplicateFields, '' as DataSourceId, '' as HandlerId
				FROM DM2Container AS T
				LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
				INNER JOIN UMUsers U ON U.id = T.userId
                                WHERE T.userId = @i_userId AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
								AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				UNION ALL
				SELECT	T.containerId , T.ContainerGuid , T.containerName , dbo.GetUnixTime(T.createTime) ,
								T.containerType , T.Attribute , T.comment , 2 ,
								UUG.capabilities , U.name , U.userGuid , U.login, '' as DeDuplicateFields, '' as DataSourceId, '' as HandlerId
				FROM DM2Container AS T
				LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
                                INNER JOIN UMUsers U ON U.id = T.userId
INNER JOIN #DM2GetContainerList_userObject_SET_ID UUG ON UUG.reviewSetId = T.containerId
				WHERE  (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType AND T.userId <> @i_userId
				AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				UNION ALL
				SELECT	T.containerId , T.ContainerGuid , T.containerName , dbo.GetUnixTime(T.createTime) ,
								T.containerType , T.Attribute , T.comment , 3 ,
								@OthersCaps, U.name , U.userGuid , U.login, '' as DeDuplicateFields, '' as DataSourceId, '' as HandlerId
				FROM DM2Container AS T
				LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
				INNER JOIN UMUsers U ON U.id = T.userId
				WHERE T.userId <> @i_userId AND @i_viewContainers = 1
AND T.containerId NOT in ( SELECT reviewSetId FROM #DM2GetContainerList_userObject_SET_ID )
				AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
				AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				--ORDER BY dbo.GetUnixTime(T.createTime) -- sort when caputring into xml from temp table
				UPDATE S
				SET S.DeDuplicateFields = TP.PropertyValue
				FROM @ContainerList S, DCEntityProperty TP WITH(NOLOCK)
				WHERE TP.PropertyName = @DuplicatesProp AND S.containerId = TP.EntityId AND TP.EntityType = @i_entityType
				UPDATE S
				SET S.DataSourceId = TP.PropertyValue
				FROM @ContainerList S, DCEntityProperty TP WITH(NOLOCK)
				WHERE TP.PropertyName = @DataSourceIdProp AND S.containerId = TP.EntityId AND TP.EntityType = @i_entityType
				UPDATE S
				SET S.HandlerId = TP.PropertyValue
				FROM @ContainerList S, DCEntityProperty TP WITH(NOLOCK)
				WHERE TP.PropertyName = @HandlerIdProp AND S.containerId = TP.EntityId AND TP.EntityType = @i_entityType
				SET @i_xmlText = (SELECT
					(SELECT	containerId '@containerId', ContainerGuid '@containerGuid', containerName '@containerName',createTime '@createTime',
								containerType '@containerType', Attribute '@attribute', comment '@comment', containerOwnerType '@containerOwnerType',
								Caps '@capabilities', DeDuplicateFields '@deDuplicateFields', DataSourceId '@dataSourceId', HandlerId '@handlerId',
								name 'ownerInfo/@userName', userGuid 'ownerInfo/@userGuid', login 'ownerInfo/@aliasName'
					FROM @ContainerList
					ORDER BY createTime
					FOR XML PATH('containers'), TYPE
					)
					FOR XML PATH(''), ROOT('DM2ContentIndexing_GetContainersResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_GetContainersResp/>'
			SELECT @i_xmlText
		END
	END
	ELSE IF @i_getContainersOptions NOT IN (1, 2, 3, 4)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Unrecognized option'
		GOTO EXIT_ERROR
	END
	ELSE IF @i_getContainersOptions IN (1, 2 ,4)
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			BEGIN
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute , T.comment as comment, 1 AS containerOwnerType,
								@AllCaps AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
					INNER JOIN UMUsers U ON U.id = T.userId
					WHERE T.userId = @i_userId AND (@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute) AND
					(T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
					AND @i_getContainersOptions in (1, 4)
					UNION
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute ,T.comment as comment, 2 AS containerOwnerType,
								UUG.capabilities AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
                                        INNER JOIN UMUsers U ON U.id = T.userId
INNER JOIN #DM2GetContainerList_userObject_SET_ID UUG ON UUG.reviewSetId = T.containerId
					WHERE(@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute) AND
					(T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType AND T.userId <> @i_userId
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
					AND @i_getContainersOptions in (2, 4)
			END
		END
		ELSE
		BEGIN
				DECLARE @TblXml TABLE (XMLText XML)
				;WITH CTEXml
				As
				(
				SELECT	Y.containerId containerId, Y.ContainerGuid containerGuid, Y.containerName containerName,
						Y.containerType containerType, Y.Attribute attribute, Y.comment comment, 1 containerOwnerType,
						@AllCaps capabilities,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND Y.containerId = TP.EntityId AND Y.containerType = @i_entityType) as deDuplicateFields,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND Y.containerId = TP.EntityId AND Y.containerType = @i_entityType) as dataSourceId,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND Y.containerId = TP.EntityId AND Y.containerType = @i_entityType) as handlerId,
						Z.name userName,
						Z.userGuid userGuid,
						Z.login aliasName
					FROM DM2Container AS Y
					LEFT JOIN @RequestedContainers R ON Y.containerId = R.containerId
					INNER JOIN UMUsers Z ON Z.id = Y.userId
					WHERE @i_getContainersOptions in (1, 4)
					AND Y.userId = @i_userId AND (Y.Attribute & 0x0010 <> 0x0010) AND Y.containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				UNION
					SELECT	T.containerId containerId, T.ContainerGuid containerGuid, T.containerName containerName,
						T.containerType containerType, T.Attribute attribute, T.comment comment, 2 containerOwnerType,
						UUG.capabilities capabilities,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId,
						(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId,
						U.name userName,
						U.userGuid userGuid,
						U.login aliasName
				FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
                                INNER JOIN UMUsers U ON U.id = T.userId
INNER JOIN #DM2GetContainerList_userObject_SET_ID UUG ON UUG.reviewSetId = T.containerId
					WHERE @i_getContainersOptions in (2, 4)
					AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType AND T.userId <> @i_userId
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
				)
				INSERT INTO @TblXml
				SELECT (SELECT
				(
					SELECT	containerId '@containerId', ContainerGuid '@containerGuid', containerName '@containerName',
								containerType '@containerType', Attribute '@attribute', comment '@comment', containerOwnerType '@containerOwnerType',
								capabilities '@capabilities', deDuplicateFields '@deDuplicateFields', dataSourceId '@dataSourceId', handlerId '@handlerId',
								userName 'ownerInfo/@userName', userGuid 'ownerInfo/@userGuid', aliasName 'ownerInfo/@aliasName'
					FROM CTEXml
					FOR XML PATH('containers'), TYPE)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_GetContainersResp'))
			--
			-- check if we found any data, then return accordingly..
			--
			IF NOT EXISTS (SELECT 1 FROM @TblXml)
			BEGIN
				SET @i_xmlText = '<DM2ContentIndexing_GetContainersResp/>'
			END
			ELSE
			BEGIN
				SELECT @i_xmlText = xmltext FROM @TblXml
			END
			SELECT @i_xmlText
		END
	END
	ELSE IF ( @i_getContainersOptions = 3 )
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			BEGIN
				SELECT T.containerId AS containerId, T.containerGuid AS containerGuid, T.containerName AS containerName,
								T.containerType AS containerType, T.attribute as attribute , T.comment as comment, 3 AS containerOwnerType,
								@OthersCaps AS capabilities, U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName,
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as deDuplicateFields, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as dataSourceId, (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as handlerId
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
					INNER JOIN UMUsers U ON U.id = T.userId
					WHERE T.userId <> @i_userId AND @i_viewContainers = 1
AND T.containerId NOT in ( SELECT reviewSetId FROM #DM2GetContainerList_userObject_SET_ID  )
					AND (@i_Attribute = 0 OR (@i_Attribute & T.Attribute) = @i_Attribute)
					AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
			END
		END
		ELSE
		BEGIN
			SET @i_xmlText = (SELECT
				(SELECT	T.containerId '@containerId', T.ContainerGuid '@containerGuid', T.containerName '@containerName',
								T.containerType '@containerType', T.Attribute '@attribute', T.comment '@comment', 3 '@containerOwnerType',
								@OthersCaps '@capabilities',
								(SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DuplicatesProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as '@deDuplicateFields', (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @DataSourceIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as '@dataSourceId', (SELECT TOP 1 PropertyValue FROM DCEntityProperty TP WHERE TP.PropertyName = @HandlerIdProp AND T.containerId = TP.EntityId AND T.containerType = @i_entityType) as '@handlerId', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
					FROM DM2Container AS T
					LEFT JOIN @RequestedContainers R ON T.containerId = R.containerId
					INNER JOIN UMUsers U ON U.id = T.userId
					WHERE T.userId <> @i_userId AND @i_viewContainers = 1
AND T.containerId NOT in ( SELECT reviewSetId FROM #DM2GetContainerList_userObject_SET_ID )
					AND (T.Attribute & 0x0010 <> 0x0010) AND T.containerType = @i_entityType
					AND (@AllContainers = 1 OR (@AllContainers = 0 AND R.containerId IS NOT NULL))
					FOR XML PATH('containers'), TYPE
				)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_GetContainersResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_GetContainersResp/>'
			SELECT @i_xmlText
		END
	END
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			SELECT CAST(@o_errorCode AS VARCHAR(36)) AS ContainerID, @o_errorString AS name, '' AS description, 0 AS attribute
		END
		ELSE
		BEGIN
			SELECT	1					as TAG,
				0					as Parent,
				@o_errorCode			as [CVGui_GenericResp!1!errorCode],
				@o_errorString			as [CVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetReviewSetList')
	delete from GxQscripts where name = 'DM2GetReviewSetList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetReviewSetList')
	delete from GXDBVersions where aliasname = 'DM2GetReviewSetList'
GO

insert into GXDBVersions values(2, 'DM2GetReviewSetList',  'v1.7.274.4.14.1', 'DM2GetReviewSetList', 'v1.7.274.4.14.1')
GO

