

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetRetentionTagsList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetRetentionTagsList()
--  | Description:  Gets list of Tags
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetRetentionTagsList')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetRetentionTagsList <<<'
	drop procedure DM2GetRetentionTagsList
END
IF EXISTS (select * from GxQscripts where name='DM2GetRetentionTagsList')
	delete from GxQscripts where name = 'DM2GetRetentionTagsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRetentionTagsList')
	delete from GXDBVersions where aliasname = 'DM2GetRetentionTagsList'
GO
print '... Creating Procedure: DM2GetRetentionTagsList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetRetentionTagsList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0
AS
SET NOCOUNT ON
DECLARE @o_xmlText XML
DECLARE @o_errorCode        INT = 0
DECLARE @ExchangeRetentionContainerGuid varchar(36)= '26A29909-9168-405C-B989-92A8EE243D35'
DECLARE @AzureInformationProtectionContainerGuid varchar(36)= '222CAD52-86D3-4316-889D-2D8804AAF898'
DECLARE @TypeExchangeRetentionTags INT = 1
DECLARE @TypeAzureInformationProtectionTags INT = 2
SET @o_xmlText =
	(SELECT
		(SELECT
			(SELECT T.TagID AS '@tagGUID',
				T.TagDesc AS '@desc',
				V.TagValue AS '@tagValue',
				T.TagValue AS '@tagName',
				CASE
					WHEN V.containerGuid = @ExchangeRetentionContainerGuid THEN @TypeExchangeRetentionTags
					WHEN V.containerGuid = @AzureInformationProtectionContainerGuid THEN @TypeAzureInformationProtectionTags
					ELSE 0
				END AS '@tagType'
				FROM DM2DocTags T, DM2DocTagsValues V WHERE T.containerGuid IN (@AzureInformationProtectionContainerGuid, @ExchangeRetentionContainerGuid) AND T.TagID = V.TagID
		FOR XML PATH('tags'),TYPE)
	FOR XML PATH('Indexing_SyncTagsReq'), TYPE))
SET @o_errorCode = @@error
IF (@o_errorCode = 0)
      select @o_xmlText
ELSE
      select '<ERROR />'
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetRetentionTagsList')
	delete from GxQscripts where name = 'DM2GetRetentionTagsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRetentionTagsList')
	delete from GXDBVersions where aliasname = 'DM2GetRetentionTagsList'
GO

insert into GXDBVersions values(2, 'DM2GetRetentionTagsList',  '00000000000000000000', 'DM2GetRetentionTagsList', '00000000000000000000')
GO

