

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetRecordConnectorList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetRecordCenterList()
--  | Description:  Gets list of Record Center
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetRecordConnectorList.sp,v $ $Id: DM2GetRecordConnectorList.sp,v 1.11.46.2 2018/03/27 08:54:42 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetRecordConnectorList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetRecordConnectorList')
	drop procedure DM2GetRecordConnectorList
IF EXISTS (select * from GxQscripts where name='DM2GetRecordConnectorList')
	delete from GxQscripts where name = 'DM2GetRecordConnectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRecordConnectorList')
	delete from GXDBVersions where aliasname = 'DM2GetRecordConnectorList'
GO
print '... Creating Procedure: DM2GetRecordConnectorList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetRecordConnectorList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_getRecordConnectorOptions	int = 0
	DECLARE @i_Attribute		INT
	DECLARE @i_isTableOut		INT
	DECLARE @i_useDisabled		INT
	DECLARE @i_UserName			NVARCHAR(max)
	DECLARE @i_domainName		NVARCHAR(max)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @AllCaps 				BIGINT
	SET 		@AllCaps = (SELECT SUM(POWER(2.0, id-1)) FROM UMCapability)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @i_viewERM INT = 0
DECLARE @entityType INT  = 9506
	SET @o_errorCode = 0
	SET @o_errorString = ''
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_capability = 31
	IF @i_UserName = ''
		SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
							FROM @i_xmlText.nodes('DM2ContentIndexing_RecordConnectorListReq') R ( ref ) ), @i_UserName)
	SET @i_useDisabled = ISNULL (( SELECT ref.value('@disabled', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorListReq') R(ref)), 0)
	SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorListReq') R(ref)), 0)
	SET @i_Attribute = ISNULL (( SELECT ref.value('@attribute', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorListReq') R(ref)), 0)
	SET @i_getRecordConnectorOptions = ISNULL (( SELECT ref.value('@getRecordConnectorOptions', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_RecordConnectorListReq') R(ref)), 0)
	-- User can view all ERM if he has any sharing rights at Commcell level or Tag node level
	IF ( @i_viewERM = 0 )
	BEGIN
		DECLARE	@o_canDeleteEntityType int = 0
		DECLARE @o_canEditEntityType int = 0
		DECLARE @o_canRestoreEntityType int = 0
		EXEC sec_canDeleteDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
		EXEC sec_canRestoreDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canRestoreEntityType = @o_canRestoreEntityType OUTPUT
		IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 OR @o_canRestoreEntityType > 0 )
			SET @i_viewERM = 1
	END
	IF object_id('tempdb.dbo.#DM2GetRecordConnectorList_userObjects') is not null 		DROP TABLE #DM2GetRecordConnectorList_userObjects
create table  #DM2GetRecordConnectorList_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId,9506,0,'#DM2GetRecordConnectorList_userObjects'
	IF ( @i_getRecordConnectorOptions = 0 ) -- get all tags based on user capabilities ( owned and shared tags are retrieved irrespective of capabilities )
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
				SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, @AllCaps AS capabilities,
				R.description description, R.xmlValue xmlValue, R.status as status, 1 AS recordConnectorOwnerType,
				U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId = @i_userId AND (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute)
				UNION ALL
				SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, UC.capabilities AS capabilities,
				R.description description, R.xmlValue xmlValue, R.status as status, 1 AS recordConnectorOwnerType,
				U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
				FROM DM2RecordCenterConnector AS R
				INNER JOIN #DM2GetRecordConnectorList_userObjects UC ON UC.ermId = R.id
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE  (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute) AND R.ownerUserId <> @i_userId
				UNION ALL
				SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, @AllCaps AS capabilities,
				R.description description, R.xmlValue xmlValue, R.status as status, 1 AS recordConnectorOwnerType,
				U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE @i_viewERM = 1 AND R.ownerUserId <> @i_userId
				AND R.id NOT in ( SELECT ermId FROM #DM2GetRecordConnectorList_userObjects  )
				AND (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute)
		END
		ELSE
		BEGIN
			--DO NOT SEND BACK THE PASSWORD
			SET @i_xmlText = ( SELECT
				-- get owned ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', @AllCaps '@capabilities',
				R.description '@description', R.status '@status', 1 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId = @i_userId
				FOR XML PATH('recordConnectors'), TYPE),
				-- get shared ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', UC.capabilities '@capabilities',
				R.description '@description', R.status '@status', 2 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN #DM2GetRecordConnectorList_userObjects UC ON UC.ermId = R.id
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId <> @i_userId
				FOR XML PATH('recordConnectors'), TYPE),
				-- get other ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', @AllCaps '@capabilities',
				R.description '@description', R.status '@status', 3 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE @i_viewERM = 1 AND R.ownerUserId <> @i_userId
				AND R.id NOT in ( SELECT ermId FROM #DM2GetRecordConnectorList_userObjects  )
				FOR XML PATH('recordConnectors'), TYPE)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_RecordConnectorListResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_RecordConnectorListResp/>'
			SELECT @i_xmlText
		END
	END
	ELSE IF ( @i_getRecordConnectorOptions = 1 ) -- get owned ERMS
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
				SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, @AllCaps AS capabilities,
				R.description description, R.xmlValue xmlValue, R.status as status, 1 AS recordConnectorOwnerType,
				U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId = @i_userId AND (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute)
		END
		ELSE
		BEGIN
			--DO NOT SEND BACK THE PASSWORD
			SET @i_xmlText = ( SELECT
				-- get owned ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', @AllCaps '@capabilities',
				R.description '@description', R.status '@status', 1 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId = @i_userId
				FOR XML PATH('recordConnectors'), TYPE)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_RecordConnectorListResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_RecordConnectorListResp/>'
			SELECT @i_xmlText
		END
	END
	ELSE IF ( @i_getRecordConnectorOptions = 2 ) -- get shared ERMS
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
			SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, UC.capabilities AS capabilities,
			R.description description, R.xmlValue xmlValue, R.status as status, 2 AS recordConnectorOwnerType,
			U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
			FROM DM2RecordCenterConnector AS R
			INNER JOIN #DM2GetRecordConnectorList_userObjects UC ON UC.ermId = R.id
			INNER JOIN UMUsers U ON U.id = R.ownerUserId
			WHERE (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute) AND R.ownerUserId <> @i_userId
		END
		ELSE
		BEGIN
			--DO NOT SEND BACK THE PASSWORD
			SET @i_xmlText = ( SELECT
				-- get shared ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', UC.capabilities '@capabilities',
				R.description '@description', R.status '@status', 2 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN #DM2GetRecordConnectorList_userObjects UC ON UC.ermId = R.id
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE R.ownerUserId <> @i_userId
				FOR XML PATH('recordConnectors'), TYPE)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_RecordConnectorListResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_RecordConnectorListResp/>'
			SELECT @i_xmlText
		END
	END
	ELSE IF ( @i_getRecordConnectorOptions = 3 ) -- get other ERMS
	BEGIN
		IF (@i_isTableOut <> 0)
		BEGIN
            SELECT R.id id, R.connectorName name, R.recordId recordId, R.recordName recordCenterName, @AllCaps AS capabilities,
            R.description description, R.xmlValue xmlValue, R.status as status, 3 AS recordConnectorOwnerType,
            U.name AS userName, U.userGuid AS userGuid, U.login AS aliasName
            FROM DM2RecordCenterConnector AS R
			INNER JOIN UMUsers U ON U.id = R.ownerUserId
            WHERE @i_viewERM = 1 AND R.ownerUserId = @i_userId
            AND R.id NOT in ( SELECT ermId FROM #DM2GetRecordConnectorList_userObjects )
            AND (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute)
		END
		ELSE
		BEGIN
			--DO NOT SEND BACK THE PASSWORD
			SET @i_xmlText = ( SELECT
				-- get other ERMS
				(SELECT R.id '@id', R.connectorName '@name', R.recordId '@recordCenterId', R.recordName '@recordCenterName', @AllCaps '@capabilities',
				R.description '@description', R.status '@status', 3 '@recordConnectorOwnerType',
				(SELECT C.xmlValue FROM DM2RecordCenterConnector AS C WHERE R.id = C.id),
				U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
				FROM DM2RecordCenterConnector AS R
				INNER JOIN UMUsers U ON U.id = R.ownerUserId
				WHERE @i_viewERM = 1 AND R.ownerUserId <> @i_userId
				AND R.id NOT in ( SELECT ermId FROM #DM2GetRecordConnectorList_userObjects)
				FOR XML PATH('recordConnectors'), TYPE)
				FOR XML PATH(''), ROOT('DM2ContentIndexing_RecordConnectorListResp'))
			IF @i_xmlText IS null
				SET @i_xmlText = '<DM2ContentIndexing_RecordConnectorListResp/>'
			SELECT @i_xmlText
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorString = 'Unrecognized option'
		GOTO EXIT_ERROR
	END
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetRecordConnectorList')
	delete from GxQscripts where name = 'DM2GetRecordConnectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRecordConnectorList')
	delete from GXDBVersions where aliasname = 'DM2GetRecordConnectorList'
GO

insert into GXDBVersions values(2, 'DM2GetRecordConnectorList',  '00010011004600020000', 'DM2GetRecordConnectorList', '00010011004600020000')
GO

