

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetRecordCenterList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetRecordCenterList()
--  | Description:  Gets list of Record Center
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetRecordCenterList.sp,v $ $Id: DM2GetRecordCenterList.sp,v 1.8.286.2 2018/03/27 09:08:48 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetRecordCenterList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetRecordCenterList')
	drop procedure DM2GetRecordCenterList
IF EXISTS (select * from GxQscripts where name='DM2GetRecordCenterList')
	delete from GxQscripts where name = 'DM2GetRecordCenterList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRecordCenterList')
	delete from GXDBVersions where aliasname = 'DM2GetRecordCenterList'
GO
print '... Creating Procedure: DM2GetRecordCenterList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetRecordCenterList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_Attribute		INT
	DECLARE @i_isTableOut		INT
	DECLARE @i_useDisabled		INT
DECLARE @i_UserName			NVARCHAR(255)
DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	SET @o_errorCode = 0
	SET @o_errorString = ''
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS NULL OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
SET @i_capability = 25
	IF @i_UserName = ''
		SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
							FROM @i_xmlText.nodes('DM2ContentIndexing_GetRecordCentersReq') R ( ref ) ), @i_UserName)
	SET @i_useDisabled = ISNULL (( SELECT ref.value('@disabled', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetRecordCentersReq') R(ref)), 0)
	SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetRecordCentersReq') R(ref)), 0)
	SET @i_Attribute = ISNULL (( SELECT ref.value('@attribute', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetRecordCentersReq') R(ref)), 0)
	--GET USER RIGHTS
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetRecordCentersReq/groups') R(ref)
	EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, @i_domainName, #tmpextGroupListTbl, #dm2UserObjectsTbl
	IF NOT EXISTS (SELECT * FROM #dm2UserObjectsTbl WHERE commCellId = 2)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have Compliance rights at Commcell level'
		GOTO EXIT_ERROR
	END
	IF (@i_isTableOut <> 0)
	BEGIN
			SELECT R.id RecordId, R.url URL, R.recordName name, R.type type, R.description description,
			R.status status, R.userName as userName, R.password as password, R.domain as domain,
			R.xmlValue as xmlValue
			FROM DM2RecordCenter AS R WHERE (@i_Attribute = 0 OR (@i_Attribute & R.status) = @i_Attribute)
	END
	ELSE
	BEGIN
		DECLARE @rcTable TABLE (rcId INT, UserName NVARCHAR(1024))
		DECLARE @rcId INT
		DECLARE @UserName NVARCHAR(1024)
		DECLARE @domainName NVARCHAR(1024)
		DECLARE	GetRCInfoCursor	CURSOR FOR
		SELECT id, userName, domain FROM DM2RecordCenter
		OPEN GetRCInfoCursor
		FETCH GetRCInfoCursor INTO @rcId, @UserName, @domainName
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			IF LEN(@domainName) > 0
				SET @UserName = @domainName + '\' + @UserName
			INSERT INTO @rcTable VALUES (@rcId, @UserName)
			FETCH GetRCInfoCursor INTO @rcId, @UserName, @domainName
		END
		CLOSE GetRCInfoCursor
		DEALLOCATE GetRCInfoCursor
		--DO NOT SEND BACK THE PASSWORD
		SET @i_xmlText = (SELECT R.id '@id', R.url '@url', R.recordName '@name', R.type '@type',
			R.description '@description', R.status '@status',
			(SELECT T.userName as '@userName', '' as '@password'
				FROM DM2RecordCenter AS C, @rcTable AS T WHERE id = R.id AND R.id = T.rcId
				FOR XML PATH('userPassword'), TYPE)
			FROM DM2RecordCenter AS R
			FOR XML PATH('recordCenters'), ROOT('DM2ContentIndexing_GetRecordCenterResp'))
		IF @i_xmlText IS NULL
			SET @i_xmlText = '<DM2ContentIndexing_GetRecordCenterResp/>'
		SELECT @i_xmlText
	END
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetRecordCenterList')
	delete from GxQscripts where name = 'DM2GetRecordCenterList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetRecordCenterList')
	delete from GXDBVersions where aliasname = 'DM2GetRecordCenterList'
GO

insert into GXDBVersions values(2, 'DM2GetRecordCenterList',  '00010008028600020000', 'DM2GetRecordCenterList', '00010008028600020000')
GO

