

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetPreferredClientIdForCloudId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2GetPreferredClientIdForCloudId')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetPreferredClientIdForCloudId <<<'
	drop procedure DM2GetPreferredClientIdForCloudId
END
IF EXISTS (select * from GxQscripts where name='DM2GetPreferredClientIdForCloudId')
	delete from GxQscripts where name = 'DM2GetPreferredClientIdForCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetPreferredClientIdForCloudId')
	delete from GXDBVersions where aliasname = 'DM2GetPreferredClientIdForCloudId'
GO
print '... Creating Procedure: DM2GetPreferredClientIdForCloudId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2GetPreferredClientIdForCloudId
  @i_Type VARCHAR(128)= NULL,
  @i_cloudId INT =0,
  @i_orderByClause INT = 0
AS
/*
  Retrieves the preferred clientId in a sortable manner for the given cloudId based on the sort criteria provided.
  The TotalCvCloudShardsOnNode represent the total number of cvcloud shards residing on the node.
  @i_orderByClause is an enum defined as such
    0 -> sort the result by free space on node in ascending manner
    1 -> sort the result by free space on node in descending manner
    2 -> sort the result by most recent shard created on node in ascending manner
    3 -> sort the result by most recent shard created on node in descending manner
*/
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
DROP TABLE #getIndexServers
IF OBJECT_ID('tempdb.dbo.#IndexServerNodeInfo') IS NOT NULL
DROP TABLE #IndexServerNodeInfo
CREATE TABLE #IndexServerNodeInfo
(
  CloudId           INT,
  ClientId          INT,
  TotalCvCloudShardsOnNode  INT,
  FreeSpace         BIGINT,
  MostRecentShardCreated    DATETIME
)
CREATE TABLE #getIndexServers
(
  serverURL NVARCHAR(512),
  clientId INT,
  clientName NVARCHAR(256),
  cloudId INT,
  hostName NVARCHAR(256),
  basePort INT,
  engineName  NVARCHAR(256),
  serverType INT,
  indexServerClientId INT,
  internalCloudName NVARCHAR(256)
)
EXEC DM2GetIndexServers @i_roleTypeName = @i_Type, @i_cloudId = @i_cloudId
INSERT INTO #IndexServerNodeInfo
SELECT S.cloudId, S.clientId, ISNULL(SEFC.CvCloudShards, 0), DMC.FreeSpace, SEFC.CreateTime FROM #getIndexServers S
INNER JOIN DM2SearchServerCoreInfo DMC WITH (NOLOCK) ON DMC.CloudId = S.CloudId AND DMC.ClientId = S.clientId
LEFT JOIN (SELECT SEC.CloudId, SEC.ClientId, COUNT(*) AS CvCloudShards, MAX(SEC.CreateTime) AS CreateTime FROM SECollectionInfo SEC WITH(NOLOCK)
       INNER JOIN SEDataSource SED WITH(NOLOCK) ON SEC.CoreId = SED.CoreId
       INNER JOIN SEDataSourceRoute SEDR WITH(NOLOCK) ON SED.DataSourceId = SEDR.DataSourceId
       GROUP BY SEC.CloudID, SEC.ClientId) AS SEFC ON SEFC.ClientId = DMC.ClientId AND SEFC.CloudID = DMC.CloudId
SELECT CloudId, ClientId, TotalCvCloudShardsOnNode FROM #IndexServerNodeInfo
ORDER BY CASE WHEN @i_orderByClause = 0 THEN FreeSpace END,
         CASE WHEN @i_orderByClause = 1 THEN FreeSpace END DESC,
         CASE WHEN @i_orderByClause = 2 THEN MostRecentShardCreated END,
         CASE WHEN @i_orderByClause = 3 THEN MostRecentShardCreated END DESC
IF OBJECT_ID('tempdb.dbo.#IndexServerNodeInfo') IS NOT NULL
DROP TABLE #IndexServerNodeInfo
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetPreferredClientIdForCloudId')
	delete from GxQscripts where name = 'DM2GetPreferredClientIdForCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetPreferredClientIdForCloudId')
	delete from GXDBVersions where aliasname = 'DM2GetPreferredClientIdForCloudId'
GO

insert into GXDBVersions values(2, 'DM2GetPreferredClientIdForCloudId',  '00000000000000000000', 'DM2GetPreferredClientIdForCloudId', '00000000000000000000')
GO

