

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetOldCanonicalNames.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetOldCanonicalNames()
--  | Description:  Returns all the old canonical names for the input canonical name
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetOldCanonicalNames.sp,v $ $Id: DM2GetOldCanonicalNames.sp,v 1.3.200.2 2019/01/31 16:17:49 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetOldCanonicalNames')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetOldCanonicalNames <<<'
	drop procedure DM2GetOldCanonicalNames
END
IF EXISTS (select * from GxQscripts where name='DM2GetOldCanonicalNames')
	delete from GxQscripts where name = 'DM2GetOldCanonicalNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetOldCanonicalNames')
	delete from GXDBVersions where aliasname = 'DM2GetOldCanonicalNames'
GO
print '... Creating Procedure: DM2GetOldCanonicalNames'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetOldCanonicalNames
  @i_newCanonicalName VARCHAR(MAX) = ''
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	WITH DM2_LN_CanonicalName(GUID,name)
	AS
	(
		SELECT T.GUID,T.name FROM APP_GUID AS T WHERE T.name = @i_newCanonicalName AND T.status != 128
		UNION ALL
		SELECT T.GUID,T.name FROM APP_GUID AS T
		INNER JOIN
		DM2_LN_CanonicalName as tc on t.name = tc.GUID
	)
	SELECT GUID AS CanonicalName FROM DM2_LN_CanonicalName
		WHERE LEN(ISNULL(GUID,'')) > 0
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetOldCanonicalNames')
	delete from GxQscripts where name = 'DM2GetOldCanonicalNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetOldCanonicalNames')
	delete from GXDBVersions where aliasname = 'DM2GetOldCanonicalNames'
GO

insert into GXDBVersions values(2, 'DM2GetOldCanonicalNames',  '00010003020000020000', 'DM2GetOldCanonicalNames', '00010003020000020000')
GO

