

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetLoginNameFromDNName.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetLoginNameFromDNName()
--  | Description:  Returns userguid, login, and domain information for the input DN name
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetLoginNameFromDNName.sp,v $ $Id: DM2GetLoginNameFromDNName.sp,v 1.2.12.1 2018/03/27 09:08:42 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetLoginNameFromDNName <<<'

IF EXISTS (select * from sysobjects where name='DM2GetLoginNameFromDNName')
	drop procedure DM2GetLoginNameFromDNName
IF EXISTS (select * from GxQscripts where name='DM2GetLoginNameFromDNName')
	delete from GxQscripts where name = 'DM2GetLoginNameFromDNName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLoginNameFromDNName')
	delete from GXDBVersions where aliasname = 'DM2GetLoginNameFromDNName'
GO
print '... Creating Procedure: DM2GetLoginNameFromDNName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetLoginNameFromDNName
  @i_dnName NVARCHAR(MAX)
AS
	DECLARE @tuserGuid VARCHAR(1024) = ''
	SELECT TOP 1 @tuserGuid  = REPLACE(REPLACE(GUID,'{',''),'}','') FROM APP_GUID WITH (NOLOCK)
	WHERE name = @i_dnName AND status = 16  /* GET userguid from DN name*/
	IF(LEN(ISNULL(@tuserGuid,''))>0)
	BEGIN
		  IF EXISTS ( SELECT ID FROM UMUsers WHERE userGuid = @tuserGuid)
		  BEGIN
				/*UMUsers itself have entry*/
				SELECT U.userGuid,U.login, (SELECT TOP 1 domainName FROM UMDSProviders WHERE id = U.umDSproviderId) AS domainName
				FROM UMUsers AS U WHERE U.userGuid = @tuserGuid
		  END
		  ELSE /* Get the loginName from APP_GUID itself*/
		  BEGIN
				SELECT TOP 1 @tuserGuid "userGuid", name "login", '' "domainName"
				FROM APP_GUID WITH (NOLOCK)
				WHERE GUID = ('{'+@tuserGuid+'}') AND status = 4
		  END
	END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetLoginNameFromDNName')
	delete from GxQscripts where name = 'DM2GetLoginNameFromDNName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLoginNameFromDNName')
	delete from GXDBVersions where aliasname = 'DM2GetLoginNameFromDNName'
GO

insert into GXDBVersions values(2, 'DM2GetLoginNameFromDNName',  '00010002001200010000', 'DM2GetLoginNameFromDNName', '00010002001200010000')
GO

