

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetLicensingInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetLicensingInfo.sp,v $ $Id: DM2GetLicensingInfo.sp,v 1.1.2.1 2020/08/07 20:45:10 pankajkumar Exp $";
--
--  +========================================================================+
--  |      Cursor:  DM2GetLicensingInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetLicensingInfo')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetLicensingInfo <<<'
	drop procedure DM2GetLicensingInfo
END
IF EXISTS (select * from GxQscripts where name='DM2GetLicensingInfo')
	delete from GxQscripts where name = 'DM2GetLicensingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLicensingInfo')
	delete from GXDBVersions where aliasname = 'DM2GetLicensingInfo'
GO
print '... Creating Procedure: DM2GetLicensingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetLicensingInfo
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
---Activate summary
DECLARE @CS_SPVERSION  INT = 0
SELECT Top 1 @CS_SPVERSION = ISNULL(SIM.HighestSP,0) FROM simInstalledPackages SIM
WHERE sim.ClientId = 2 AND Sim.simPackageID = 20 /*commserve package*/
IF(@CS_SPVERSION < 11) RETURN -- This report is for V11 SP11 and above
DECLARE @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_FILES				 INT =100034        -- Compliance search/Ediscovery Files (old and new CI for fs)
DECLARE @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_EMAIL_CLOUD_APPS      INT =100035			-- Compliance search/Ediscovery Users
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_FILES             INT =100036			-- SDG Files
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS  INT =100037			-- SDG Emails
DECLARE @SIM_CSL_AT_V2_FILE_STORAGE_OPTIMIZATION                     INT =100038			 -- FSO Files
DECLARE @SIM_CSL_AT_V2_ACTIVATE_SUITE                                INT =100039
IF OBJECT_ID('tempdb.dbo.#tempgGlobalDSInfos') IS NOT NULL
	DROP TABLE #tempgGlobalDSInfos
CREATE TABLE #tempgGlobalDSInfos
	(	DatasourceId int PRIMARY KEY,
		DatasourceName NVARCHAR(1024),
		TotalCount BIGINT,
		DataSourceType VARCHAR(100),
		EmailMailboxCount INT,
		AppName VARCHAR(20),
		ClientId INT
	);
--retrieve all datasources
INSERT INTO #tempgGlobalDSInfos(DatasourceId, DatasourceName, DataSourceType, AppName)
SELECT SE.DataSourceId, SE.DataSourceName, UPPER(DST.TypeDisplayName), 'DataCube' FROM SEDataSource SE WITH (NOLOCK)
INNER JOIN SEDataSourceType AS DST ON SE.DataSourceType = DST.TypeId AND SE.Attribute & 4 != 4
			AND DST.TypeGUID IN ('A32C5C37-FEDE-4849-BF3E-6FCEFD46D769','0BC3CD9F-5B02-4A47-97FE-125A83BA13FC')
--fetch the total docs, index directory size,
;WITH CTE(datasourceId,statusInfo) as
(
	SELECT T.datasourceId, CONVERT(XML,T.PropertyValue)
	FROM SEDataSourceProperty as T WITH (NOLOCK)
		INNER JOIN SEProperty AS P ON T.PropertyId = P.PropertyId AND P.PropertyName = 'statusinfo'
	WHERE T.PropertyValue is not null AND T.PropertyValue != ''
)
UPDATE tGDS SET
	TotalCount = ISNULL(m.c.value('@TotalDocs','BIGINT'),0)
FROM #tempgGlobalDSInfos tGDS INNER JOIN  CTE ON CTE.datasourceId = tGDS.DatasourceId outer apply CTE.statusInfo.nodes('/StatusInfo') as m(c)
/*
SET GDPR flag that are part of project
*/
IF OBJECT_ID('tempdb.dbo.#tempGDPRDSId') IS NOT NULL
	DROP TABLE #tempGDPRDSId
CREATE TABLE #tempGDPRDSId (
    DataSourceId INT
)
;with CTEGPRoj(id) AS
(
	SELECT c.id FROM APP_Client c
	INNER JOIN APP_ClientProp cp ON	cp.componentNameId = c.id
					AND (c.status & 0x10000000 ) <> 0
					AND cp.attrName = N'System Drive Type'
					AND cp.attrVal = N'6'	--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
)
INSERT INTO #tempGDPRDSId
select CONVERT(INT, attrVal)
FROM APP_ClientProp cp WITH (NOLOCK)
JOIN CTEGPRoj TP ON TP.id = cp.componentNameId
WHERE cp.attrName = 'Datasource Id'
UPDATE tGDS SET
	AppName = 'GDPR'
FROM #tempgGlobalDSInfos AS tGDS
	INNER JOIN #tempGDPRDSId AS ds ON tGDS.DatasourceId = ds.DataSourceId
-- filter to get only email datasoures
DELETE T FROM #tempGDPRDSId T
JOIN SEDataSource S WITH (NOLOCK)
	ON S.DataSourceId = T.DataSourceId
JOIN SEDataSourceType ST WITH (NOLOCK)
	ON S.DataSourceType = ST.TypeId
WHERE ST.TypeName <> 'email' AND ST.TypeName <> 'exchange'
-- get property info: backed up subclient, crawl type, additional info
IF OBJECT_ID('tempdb.dbo.#tempEDatasourceCrawlDetail') IS NOT NULL
	DROP TABLE #tempEDatasourceCrawlDetail
CREATE TABLE #tempEDatasourceCrawlDetail (DatasourceId INT, CrawlType INT, SubClientId INT, MailBoxLst NVARCHAR(MAX), MailBoxCount INT)
-- fill data from property - crawl type
INSERT INTO #tempEDatasourceCrawlDetail
SELECT T.DatasourceId, CAST(ISNULL(DSP.PropertyValue, '1') AS INT), 0, '', 0
FROM #tempGDPRDSId T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'crawltype')
DELETE FROM #tempEDatasourceCrawlDetail
WHERE CrawlType <> 2 AND CrawlType <> 3
-- update subclient id from property
UPDATE T
SET SubClientId = CAST(ISNULL(DSP.PropertyValue, '0') AS INT)
FROM #tempEDatasourceCrawlDetail T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'backedupsubclientids')
-- update mailbox list from property
UPDATE T
SET MailBoxLst = ISNULL(DSP.PropertyValue, '')
FROM #tempEDatasourceCrawlDetail T
LEFT JOIN SEDataSourceProperty DSP WITH (NOLOCK)
	ON T.DataSourceId = DSP.DataSourceId AND DSP.PropertyId = (SELECT PropertyId FROM SEProperty P WITH (NOLOCK) WHERE PropertyName = 'additionalinfo')
-- now do the count for each datasourc depending on crawl type
UPDATE T
SET MailBoxCount =
	CASE WHEN T.CrawlType = 3 THEN
			(
				--Count of Ci Enabled User Mailboxes of a given Subclient
				SELECT ISNULL(COUNT(DISTINCT smtpAdrress),0) from APP_EmailConfigPolicyAssoc E (nolock)
				JOIN APP_EmailConfigPolicies EP (nolock) ON Ep.componentNameId = E.assocId
				JOIN APP_ConfigurationPolicyDetails CD (nolock) on CD.componentNameId = EP.policyId
				WHERE E.subClientId = T.SubClientId AND E.mailBoxType = 1 AND E.modified = 0 AND EP.policyType = 1 /* Ida::EmailPolicyType_ARCHIVE=1 */ AND EP.modified = 0
				AND CD.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
				AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0
			)
		WHEN T.CrawlType = 2 AND T.MailBoxLst = '' THEN
			(
				--Count of All User mailboxes of a given subclient
				SELECT ISNULL(count(distinct smtpAdrress),0) from APP_EmailConfigPolicyAssoc E (nolock)
				WHERE E.subClientId = T.SubClientId AND E.mailBoxType = 1 AND E.modified = 0
				AND E.status = 0 AND E.deleted = 0 AND E.modified = 0
			)
		ELSE LEN(MailBoxLst) - LEN( REPLACE ( MailBoxLst, 'smtpAdrress', 'smtpAdrres'))
	END
FROM #tempEDatasourceCrawlDetail T
INSERT INTO #tempgGlobalDSInfos(DatasourceId, DataSourceType,EmailMailboxCount,AppName,ClientId)
SELECT distinct T.DatasourceId,'Email', T.MailBoxCount, 'GDPR',APP.clientId  FROM #tempEDatasourceCrawlDetail T inner join
	SEDataSource ds on T.DatasourceId = ds.DataSourceId INNER JOIN
	APP_Application APP WITH (NOLOCK) ON App.id = T.SubClientId
/*---------------------------------------------------------*/
DROP TABLE #tempGDPRDSId
DECLARE @tenantUsers  table (clientId INT, smtp NVARCHAR(512))
INSERT INTO @tenantUsers  (clientId, smtp)
SELECT distinct client, smtp
FROM
(
       --Total v2 CI mailboxes (content indexing enabled in archive policy)
       select  clientId as client, smtpAdrress as smtp from APP_EmailConfigPolicyAssoc E
       JOIN APP_EmailConfigPolicies EP ON Ep.componentNameId = E.assocId
       JOIN APP_ConfigurationPolicyDetails CD on CD.componentNameId = EP.policyId
       WHERE E.mailBoxType = 1 AND E.modified = 0 AND EP.policyType = 1 /* Ida::EmailPolicyType_ARCHIVE=1 */ AND EP.modified = 0
       AND CD.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
       AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0
       AND E.subClientId IN (SELECT id FROM APP_Application (NOLOCK) WHERE appTypeId = 137  AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/)
       UNION
       --- Total v2 Users that are being journaled to JRN MB's where CI is enabled
       SELECT   clientId as client, smtpAdrress as smtp
       FROM App_EmailConfigPolicyAssoc (nolock) WHERE modified = 0  and discoverByType = 13
       AND subClientId IN (SELECT id FROM APP_Application (NOLOCK) WHERE appTypeId = 137  AND subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND subclientStatus & 0x04 != 0x04 /*DELETED*/ AND subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/)
       AND subclientId in ( select distinct subclientId from APP_EmailConfigPolicyAssoc E
                                        JOIN APP_EmailConfigPolicies EP ON Ep.componentNameId = E.assocId
                                        JOIN APP_ConfigurationPolicyDetails CD on CD.componentNameId = EP.policyId
                                        WHERE E.mailBoxType IN (2,3) AND E.modified = 0 AND EP.policyType = 4 /* Ida::EmailPolicyType_JOURNAL=4 */ AND EP.modified = 0
                                        AND CD.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enableContentIndex)[1]','INT') = 1
                                        AND E.status = 0 AND E.deleted = 0 AND E.modified = 0 AND CD.modified = 0)
) Exch
UPDATE t SET clientID = SC.ClientId
FROM #tempgGlobalDSInfos t
JOIN SEDataSource DS ON t.DatasourceId = DS.DataSourceId
JOIN SECollectionInfo SC	ON DS.CoreId = SC.CoreId
--OUTPUT
SELECT @SIM_CSL_AT_V2_FILE_STORAGE_OPTIMIZATION  'LicenseType', ClientId, ISNULL(SUM(TotalCount),0) 'Counts'
from #tempgGlobalDSInfos
WHERE AppName ='DataCube' AND DataSourceType = 'FILE' AND TotalCount >0
GROUP BY ClientId
union
SELECT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_FILES, ClientId, ISNULL(SUM(TotalCount),0)
from #tempgGlobalDSInfos
WHERE AppName ='GDPR' AND DataSourceType = 'FILE' AND TotalCount >0
GROUP BY ClientId
union
SELECT @SIM_CSL_AT_V2_ACTIVATE_SENSITIVE_DATA_FOR_EMAIL_CLOUD_APPS, ClientId, ISNULL(SUM(EmailMailboxCount),0)
from #tempgGlobalDSInfos
WHERE AppName ='GDPR' AND DataSourceType = 'EMAIL' AND EmailMailboxCount >0
GROUP BY ClientId
UNION
SELECT @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_FILES, NSPROP.EntityId, NSPROP.PropertyLongValue
FROM SEIndexServerNodeStatsProp NSPROP
JOIN SEIndexServerNodeStats NS ON NSPROP.ShardId = NS.ShardId
JOIN DM2SearchServerCoreInfo S ON NS.SearchServerCoreId = S.CoreId AND S.CloudType In  (1,3)
WHERE NSPROP.PropertyName ='Total File Size'
UNION
SELECT @SIM_CSL_AT_V2_ACTIVATE_EDISCOVERY_FOR_EMAIL_CLOUD_APPS, ClientId, COUNT(*)
from @tenantUsers
WHERE ISNULL(smtp,'')<>''
GROUP BY ClientId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetLicensingInfo')
	delete from GxQscripts where name = 'DM2GetLicensingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLicensingInfo')
	delete from GXDBVersions where aliasname = 'DM2GetLicensingInfo'
GO

insert into GXDBVersions values(2, 'DM2GetLicensingInfo',  '00010001000200010000', 'DM2GetLicensingInfo', '00010001000200010000')
GO

