

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetLegalHoldList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetLegalHoldList()
--  | Description:  Gets list of Legal Hold
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetLegalHoldList.sp,v $ $Id: DM2GetLegalHoldList.sp,v 1.21.44.2 2018/03/27 08:43:27 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetLegalHoldList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetLegalHoldList')
	drop procedure DM2GetLegalHoldList
IF EXISTS (select * from GxQscripts where name='DM2GetLegalHoldList')
	delete from GxQscripts where name = 'DM2GetLegalHoldList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLegalHoldList')
	delete from GXDBVersions where aliasname = 'DM2GetLegalHoldList'
GO
print '... Creating Procedure: DM2GetLegalHoldList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetLegalHoldList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT = 0,
  @i_localeId integer = 0,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_viewLH int = 0
	DECLARE @i_getLegalHoldOptions int = 0
	DECLARE @o_errorCode		INT = 0
	DECLARE @o_errorString		NVARCHAR(MAX) = ''
	DECLARE @i_userGuid			VARCHAR(36) = ''
	DECLARE @AllCaps 				BIGINT
	SET @AllCaps = (SELECT SUM(POWER(2.0, id-1)) FROM UMCapability)
	DECLARE @LHInfo	TABLE( CompPolicyId	VARCHAR(36), ArchGroupId INT, ArchGroupName NVARCHAR(1024), RetentionDays INT)
	DECLARE @maxRetention	TABLE (archGroupId int, maxRetention int)
	INSERT INTO @LHInfo
	SELECT DISTINCT CP.CompPolicyID, AG.id, AG.name, 0
	FROM DM2CompliancePolicy CP WITH (NOLOCK), APP_Application APP WITH (NOLOCK), archGroup AG WITH (NOLOCK)
	WHERE CP.BackupsetId = APP.backupset
	AND   APP.dataArchGrpID = AG.ID
	INSERT INTO @maxRetention
	SELECT AGC.archGroupId, mAx(AAR.retentionDays)
	FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
	WHERE AGC.id = AAR.copyID
	AND   AGC.isActive > 0
	GROUP BY AGC.archGroupId
	UPDATE @maxRetention
	SET maxRetention = AAR.RetentionDays
	FROM @maxRetention M, archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
	WHERE M.archGroupId = AGC.archGroupId
	AND AGC.id = AAR.copyId
	AND AAR.retentionDays = -1
	UPDATE @LHInfo
	SET RetentionDays = B.maxRetention
	FROM @LHInfo A, @maxRetention B
	WHERE A.ArchGroupId = B.ArchGroupId
	SET @i_getLegalHoldOptions = ISNULL (( SELECT ref.value('@getLegalHoldOptions', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetLegalHoldReq') R(ref)), 0)
	SET @i_userGuid = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetLegalHoldReq') R(ref)), '')
	IF @i_userGuid <> ''
	BEGIN
		SET @i_userId = ISNULL((SELECT TOP(1) id FROM UMUSERS WHERE userGuid = @i_userGuid), 0)
	END
	--USE ADMIN AS DEFAULT IF ID NOT PASSED
	IF @i_userId IS null OR @i_userId = 0
	BEGIN
		--SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
		SET @o_errorCode		= 1
		SET @o_errorString		= 'User not mentioned or not found.'
		GOTO EXIT_ERROR
	END
	-- GET USER RIGHTS
	DECLARE	@o_canViewEntityType int = 0
DECLARE @entityType int = 9505
	EXEC sec_canViewDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canViewEntityType = @o_canViewEntityType OUTPUT
	IF ( @o_canViewEntityType = 1 )
	BEGIN
		SET @i_viewLH = 1
	END
	-- User can view all LH if he has any sharing rights at Commcell level or Tag node level
	IF ( @i_viewLH = 0 )
	BEGIN
		DECLARE	@o_canDeleteEntityType int = 0
		DECLARE @o_canEditEntityType int = 0
		DECLARE @o_canRestoreEntityType int = 0
		EXEC sec_canDeleteDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
		EXEC sec_canRestoreDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canRestoreEntityType = @o_canRestoreEntityType OUTPUT
		IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 OR @o_canRestoreEntityType > 0 )
			SET @i_viewLH = 1
	END
	  IF OBJECT_ID('tempdb.dbo.#DM2GetLegHoldList_userObject') IS NOT null
            DROP TABLE #DM2GetLegHoldList_userObject
create table  #DM2GetLegHoldList_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @i_userId, 9505, 0, '#DM2GetLegHoldList_userObject'
	IF ( @i_getLegalHoldOptions = 0 ) -- get all LH based on user capabilities ( owned and shared LH are retrieved irrespective of capabilities )
	BEGIN
		SET @i_xmlText = (SELECT
		-- Get owned legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds' ,1 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		@AllCaps '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE C.ownerUserId = @i_userId
		FOR XML PATH('legalHolds'), TYPE),
		-- Get shared legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds' , 2 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		UC.capabilities '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A
		INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN #DM2GetLegHoldList_userObject UC ON C.id = UC.legalHoldId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE  C.ownerUserId <> @i_userId
		FOR XML PATH('legalHolds'), TYPE),
		-- Get other legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds' ,3 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		@AllCaps '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE @i_viewLH = 1 AND C.ownerUserId <> @i_userId AND
		C.id NOT in ( SELECT legalHoldId FROM #DM2GetLegHoldList_userObject)
		FOR XML PATH('legalHolds'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetLegalHoldResp'))
	END
	ELSE IF ( @i_getLegalHoldOptions = 1 ) -- get owned LH only
	BEGIN
		 SET @i_xmlText = (SELECT
		-- Get owned legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds' , 1 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		@AllCaps '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE C.ownerUserId = @i_userId
		FOR XML PATH('legalHolds'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetLegalHoldResp'))
	END
	ELSE IF ( @i_getLegalHoldOptions = 2 ) -- get shared LH only
	BEGIN
		SET @i_xmlText = (SELECT
		-- Get shared legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds', 2 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		UC.capabilities '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A
		INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN #DM2GetLegHoldList_userObject UC ON C.id = UC.legalHoldId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE  C.ownerUserId <> @i_userId
		FOR XML PATH('legalHolds'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetLegalHoldResp'))
	END
	ELSE IF ( @i_getLegalHoldOptions = 3 ) -- get others LH only
	BEGIN
		SET @i_xmlText = (SELECT
		-- Get other legal holds
		(SELECT C.id'@legalHoldId', C.CompPolicyID '@id', C.CompPolicyName '@name', C.CompPolicyDesc '@description',
		'@retentionPeriod' =  CASE WHEN C.RetainUntil = '12/31/9999' THEN -1
									WHEN C.RetainUntil  IS null THEN 0
									ELSE dbo.GetUnixTime(C.RetainUntil)
							  END ,
		LH.ArchGroupId '@storagePolicy', LH.ArchGroupName '@storagePolicyName', LH.RetentionDays '@SPRetentionDays',
		C.BackupsetId '@backupsetId', C.Attribute '@attribute', C.UserGUID '@userId',
		dbo.GetUnixTime(C.CreateTime) '@createTime', dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
		C.emailIds '@emailIds', 3 '@legalHoldOwnerType',
(CASE C.flags 	WHEN 2 THEN 1
								ELSE 0 END) '@isReferenceCopy',
		@AllCaps '@capabilities', U.name 'ownerInfo/@userName', U.userGuid 'ownerInfo/@userGuid', U.login 'ownerInfo/@aliasName'
		FROM APP_Application AS A INNER JOIN DM2CompliancePolicy AS C ON A.backupSet = C.BackupsetId
		INNER JOIN @LHInfo LH ON C.CompPolicyID = LH.CompPolicyId
		INNER JOIN UMUsers U ON U.id = C.ownerUserId
		WHERE @i_viewLH = 1 AND C.ownerUserId <> @i_userId AND
		C.id NOT in ( SELECT legalHoldId FROM #DM2GetLegHoldList_userObject)
		FOR XML PATH('legalHolds'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetLegalHoldResp'))
	END
	ELSE
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Unrecognized option'
		GOTO EXIT_ERROR
	END
	IF @i_xmlText IS null
		SET @i_xmlText = '<DM2ContentIndexing_GetLegalHoldResp/>'
	SELECT @i_xmlText
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
				0					as Parent,
				@o_errorCode		as [CVGui_GenericResp!1!errorCode],
				@o_errorString		as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetLegalHoldList')
	delete from GxQscripts where name = 'DM2GetLegalHoldList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetLegalHoldList')
	delete from GXDBVersions where aliasname = 'DM2GetLegalHoldList'
GO

insert into GXDBVersions values(2, 'DM2GetLegalHoldList',  '00010021004400020000', 'DM2GetLegalHoldList', '00010021004400020000')
GO

