

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetJobListForCaseClient.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetJobListForCaseClient()
--  | Description:  Get current and historical jobs details for given case (reference copy client).
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetJobListForCaseClient.sp,v $ $Id: DM2GetJobListForCaseClient.sp,v 1.4.40.2 2018/03/27 08:57:55 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetJobListForCaseClient <<<'

IF EXISTS (select * from sysobjects where name='DM2GetJobListForCaseClient')
	drop procedure DM2GetJobListForCaseClient
IF EXISTS (select * from GxQscripts where name='DM2GetJobListForCaseClient')
	delete from GxQscripts where name = 'DM2GetJobListForCaseClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetJobListForCaseClient')
	delete from GXDBVersions where aliasname = 'DM2GetJobListForCaseClient'
GO
print '... Creating Procedure: DM2GetJobListForCaseClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetJobListForCaseClient
  @i_ClientId int,
  @i_SortColumn VARCHAR(1024) = 'jobId',
  @i_SortOrder VARCHAR(20) = 'DESC',
  @i_StartIndex int = 0,
  @i_PageSize int = 10,
  @o_TotalCount int = 0 OUTPUT,
  @i_FetchDataAsXML int = 1 
AS
BEGIN
DECLARE @EndIndex int = 0
DECLARE @FinalSQL NVARCHAR(MAX)
DECLARE @DebugSQL NVARCHAR(MAX)
DECLARE @ParamDefSQL NVARCHAR(MAX)
DECLARE @localeId INT = 0
DECLARE @debug int = 0
IF ISNULL(@i_PageSize, 0) = 0
BEGIN
	SET @i_PageSize = 10
END
IF ISNULL(@i_SortColumn, '') = ''
BEGIN
	SET @i_SortColumn = 'jobid'
END
IF ISNULL(@i_SortOrder, '') = ''
BEGIN
	SET @i_SortOrder = 'DESC'
END
IF @i_StartIndex IS NULL
BEGIN
	SET @i_StartIndex = 1
END
ELSE IF @i_StartIndex % 10 = 0 -- if 0 based index is given in input, then we will make it 1 based index..
BEGIN
	--We only support 0 based index. But T-SQL generates row numbers starting from 1, so incriment to get a 1 based index.
	SET @i_StartIndex = @i_StartIndex + 1
END
--evaluate end index.
SET @EndIndex = @i_StartIndex + @i_PageSize - 1
IF OBJECT_ID('tempdb.dbo.#TempJobList') IS NOT NULL
DROP TABLE #TempJobList
create TABLE #TempJobList  (
jobid int,
appTypeId int,
bkpLevel int,
jobStartTime int,
jobEndTime int,
numberOfItems bigint,
backupLevel nvarchar(2048),
dataType varchar(255),
jobStatusString varchar(100),
sizeInBytes bigint,
durationInSeconds int,
contentIndexStatus nvarchar(512)
)
;WITH CTEJobs
AS
(
SELECT J.jobId, A.appTypeId, J.bkpLevel, ISNULL(JI.jobStartTime, 0) jobStartTime, 0 jobEndTime, J.filesXfered numberOfItems,
dbo.getBackupLevelText(J.bkpLevel,@localeId) backupLevel, AI.displayName dataType, dbo.GetJobStateName(JI.state) jobStatusString,
j.unCompBytes sizeInBytes, (dbo.GetUnixTime(getutcdate()) - JI.jobStartTime) durationInSeconds, '' contentIndexStatus
FROM JMBkpJobInfo J WITH(NOLOCK)
LEFT JOIN JMJobInfo JI WITH(NOLOCK) ON JI.jobId = J.jobId
JOIN APP_Application A WITH(NOLOCK) ON A.ID = J.applicationId AND a.clientId = @i_ClientId
JOIN APP_iDAType AI WITH(NOLOCK) ON A.appTypeId = AI.type
UNION
SELECT J.jobId, A.appTypeId, J.bkpLevel, J.servStartDate jobStartTime, J.servEndDate jobEndTime, J.totalNumOfFiles numberOfItems,
dbo.getBackupLevelText(J.bkpLevel,@localeId) backupLevel, AI.displayName dataType, dbo.GetJobStatusName(J.Status) jobStatusString,
J.totalUncompBytes sizeInBytes, (servEndDate - servStartDate) durationInSeconds, dbo.getCIStatusText(J.jobId,@localeId) contentIndexStatus
FROM JMBkpStats J WITH(NOLOCK)
JOIN APP_Application A WITH(NOLOCK) ON A.ID = J.appId AND a.clientId = @i_ClientId
JOIN APP_iDAType AI WITH(NOLOCK) ON A.appTypeId = AI.type
)
INSERT INTO #TempJobList
SELECT * FROM CTEJobs
/*
jobid int,
appTypeId int,
bkpLevel int,
jobStartTime int,
jobEndTime int,
numberOfItems bigint,
backupLevel nvarchar(2048),
dataType varchar(255),
jobStatusString varchar(100),
sizeInBytes bigint,
durationInSeconds int,
contentIndexStatus nvarchar(512)
*/
IF @i_SortColumn IS NOT NULL
BEGIN
	SET @i_SortColumn = CASE WHEN @i_SortColumn IN ('jobid', 'dataType', 'backupLevel', 'jobStatusString', 'numberOfItems', 'jobStartTime', 'jobEndTime', 'startTime', 'endTime') THEN @i_SortColumn ELSE 'jobid' END
END
IF @i_SortColumn IS NULL
BEGIN
	SET @i_SortColumn = 'jobid'
END
IF @i_SortOrder IS NOT NULL
BEGIN
	SET @i_SortOrder = CASE
						WHEN @i_SortOrder IN ('ASC', 'ASCENDING') THEN 'ASC'
						WHEN @i_SortOrder IN ('DESC', 'DESCENDING') THEN 'DESC'
						ELSE 'DESC'
						END
END
IF @i_SortOrder IS NULL
BEGIN
	SET @i_SortOrder = 'DESC'
END
SET @FinalSQL = 'WITH CTEFinal AS ( SELECT ROW_NUMBER() OVER (ORDER BY ' + @i_SortColumn + ' ' + @i_SortOrder + ') AS RowNum, * FROM #TempJobList )'
SET @FinalSQL += 'SELECT F.jobid ''@jobId'', F.dataType ''@dataType'', backupLevel ''@backupLevel'', F.jobStatusString ''@jobStatusString'''
SET @FinalSQL += ', F.numberOfItems ''@numberOfItems'', F.jobStartTime ''@jobStartTime'', F.jobEndTime ''@jobEndTime'''
if @i_FetchDataAsXML = 0
begin
	SET @FinalSQL += ', dbo.getDateTime(F.jobStartTime) ''@startTime'', dbo.getDateTime(F.jobEndTime) ''@endTime'''
end
SET @FinalSQL += ', sizeInBytes ''@sizeInBytes'', durationInSeconds ''@durationInSeconds'', contentIndexStatus ''@contentIndexStatus''
FROM CTEFinal F WHERE F.RowNum >= @i_StartIndex AND F.RowNum <= @endIndex
ORDER BY F.RowNum'
IF @i_FetchDataAsXML = 1
BEGIN
SET @FinalSQL += '
FOR XML PATH(''caseJobDetails''), TYPE, ROOT(''DM2ContentIndexing_CaseJobResponse'')
'
END
SET @ParamDefSQL = '@i_StartIndex int, @endIndex int'
EXEC SP_EXECUTESQL @FinalSQL, @ParamDefSQL, @i_StartIndex = @i_StartIndex, @endIndex = @endIndex
SELECT @o_TotalCount = COUNT(*) FROM #TempJobList
if @debug & 1 = 1
SELECT * FROM #TempJobList
IF OBJECT_ID('tempdb.dbo.#TempJobList') IS NOT NULL
DROP TABLE #TempJobList
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetJobListForCaseClient')
	delete from GxQscripts where name = 'DM2GetJobListForCaseClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetJobListForCaseClient')
	delete from GXDBVersions where aliasname = 'DM2GetJobListForCaseClient'
GO

insert into GXDBVersions values(2, 'DM2GetJobListForCaseClient',  '00010004004000020000', 'DM2GetJobListForCaseClient', '00010004004000020000')
GO

