

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetIndexServersXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetIndexServersXML')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetIndexServersXML <<<'
	drop procedure DM2GetIndexServersXML
END
IF EXISTS (select * from GxQscripts where name='DM2GetIndexServersXML')
	delete from GxQscripts where name = 'DM2GetIndexServersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetIndexServersXML')
	delete from GXDBVersions where aliasname = 'DM2GetIndexServersXML'
GO
print '... Creating Procedure: DM2GetIndexServersXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetIndexServersXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
DECLARE	@i_roleTypeName VARCHAR(128)= NULL
DECLARE	@i_indexServerClientId INT =0
DECLARE	@i_cloudId INT =0
DECLARE	@i_nodeClientId INT =0
DECLARE	@i_status INT = 1
DECLARE	@i_shouldSelectOutput INT = 0
DECLARE	@i_includeDefaultOnly INT = 0
--get input from xml request
SET @i_roleTypeName = ISNULL (( SELECT ref.value('@roleName', 'VARCHAR(128)')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), '')
SET @i_indexServerClientId = ISNULL (( SELECT ref.value('@indexServerClientId', 'INT')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), 0)
SET @i_cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), 0)
SET @i_nodeClientId = ISNULL (( SELECT ref.value('@nodeClientId', 'INT')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), 0)
SET @i_status = ISNULL (( SELECT ref.value('@status', 'INT')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), 1)
SET @i_includeDefaultOnly = ISNULL (( SELECT ref.value('@includeDefaultOnly', 'INT')
                    FROM @i_xmlText.nodes ('DM2ContentIndexing_GetIndexServerDetailsReq') R(ref)), 0)
-- call existing store proc
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
EXEC DM2GetIndexServers @i_roleTypeName, @i_indexServerClientId, @i_cloudId, @i_nodeClientId, @i_status, @i_shouldSelectOutput, @i_includeDefaultOnly
SET @o_xmlText =(
                        SELECT serverURL AS '@cIServerURL',
                            clientId as '@clientId',
                            clientName as '@clientName',
                            cloudId as '@cloudID',
                            hostName as '@hostName',
                            basePort AS '@basePort',
                            engineName AS '@engineName',
                            serverType AS '@serverType',
                            indexServerClientId AS '@indexServerClientId',
                            internalCloudName '@internalCloudName'
                            FROM #getIndexServers
                            ORDER BY cloudId
                            FOR XML PATH('listOfCIServer'), ROOT('DM2ContentIndexing_CIServers')
                     )
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF @o_xmlText IS NULL
	SET @o_xmlText = '<DM2ContentIndexing_CIServers/>'
SELECT @o_xmlText AS [o_xmlText]
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetIndexServersXML')
	delete from GxQscripts where name = 'DM2GetIndexServersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetIndexServersXML')
	delete from GXDBVersions where aliasname = 'DM2GetIndexServersXML'
GO

insert into GXDBVersions values(2, 'DM2GetIndexServersXML',  '00000000000000000000', 'DM2GetIndexServersXML', '00000000000000000000')
GO

