

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetIndexServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetIndexServers')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetIndexServers <<<'
	drop procedure DM2GetIndexServers
END
IF EXISTS (select * from GxQscripts where name='DM2GetIndexServers')
	delete from GxQscripts where name = 'DM2GetIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetIndexServers')
	delete from GXDBVersions where aliasname = 'DM2GetIndexServers'
GO
print '... Creating Procedure: DM2GetIndexServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetIndexServers
  @i_roleTypeName VARCHAR(128)= NULL,
  @i_indexServerClientId INT =0,
  @i_cloudId INT =0,
  @i_nodeClientId INT =0,
  @i_status INT = 1,
  @i_shouldSelectOutput INT = 0,
  @i_includeDefaultOnly INT = 0
AS
  DECLARE @o_serverName NVARCHAR(512)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(256)
  DECLARE @o_cloudId INT
  DECLARE @o_hostName NVARCHAR(256)
  DECLARE @o_basePort INT
  DECLARE @o_engineName NVARCHAR(256)
  DECLARE @o_serverType INT
  DECLARE @o_indexServerClientId INT
  DECLARE @o_internalCloudName NVARCHAR(256)
 -- Output tables.
IF @i_shouldSelectOutput = 1          -- Caller has not created output table.
BEGIN
    IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
END
DECLARE @l_haveValidClause BIT = 0
IF OBJECT_ID('tempdb.dbo.#populateInputCloudId') IS NOT NULL  DROP TABLE #populateInputCloudId
CREATE TABLE #populateInputCloudId(CloudId INT);
CREATE INDEX populateInputCloudId_cloudIdId_idx on #populateInputCloudId(cloudId);
--RoleTypeName
IF(ISNULL(@i_roleTypeName,'') != '')
BEGIN
	SET @l_haveValidClause = 1
	INSERT INTO #populateInputCloudId
	SELECT R.cloudId FROM DM2CloudCoreRole R (NOLOCK)
			INNER JOIN DM2CloudRoleMaster M (NOLOCK)
			ON M.roleId = R.roleId
	WHERE M.roleTypeName = @i_roleTypeName
END
INSERT INTO #getIndexServers (serverURL, clientId, clientName, cloudId, hostName, basePort, engineName, serverType, indexServerClientId, internalCloudName)
SELECT 'http://'+ CL.net_hostname + ':' + CAST (S.Portno AS nvarchar(20)),
				S.ClientId, CL.name, C.cloudId, CL.net_hostname, S.portNo,
				'', C.cloudType, C.pseudoClientId, C.name
FROM  DM2Cloud C (NOLOCK)
    JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.CloudId = C.cloudId
    JOIN APP_Client CL (NOLOCK) ON S.ClientId = CL.id
	JOIN APP_Client CL2 (NOLOCK) ON C.pseudoClientId = CL2.id  --do not include deleted index server clients
WHERE (@l_haveValidClause = 0 OR C.cloudId in (SELECT CloudId from #populateInputCloudId))
AND S.CloudType IN (1, 5)
    AND ( @i_nodeClientId = 0 OR S.ClientId = @i_nodeClientId)
    AND ( @i_indexServerClientId = 0 OR C.pseudoClientId = @i_indexServerClientId)
    AND ( @i_cloudId = 0 OR C.cloudId = @i_cloudId)
	AND (@i_status = 0 OR C.status = @i_status)
AND (@i_includeDefaultOnly = 0 OR S.coreRoles & 128 >0)
ORDER BY S.coreRoles DESC             --return DEFAULT node first
UPDATE #getIndexServers
SET engineName = CL.name
FROM APP_Client CL (NOLOCK)
WHERE #getIndexServers.indexServerClientId = CL.id
IF OBJECT_ID('tempdb.dbo.#populateInputCloudId') IS NOT NULL DROP TABLE #populateInputCloudId
IF @i_shouldSelectOutput = 1
BEGIN
	SELECT * FROM #getIndexServers
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetIndexServers')
	delete from GxQscripts where name = 'DM2GetIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetIndexServers')
	delete from GXDBVersions where aliasname = 'DM2GetIndexServers'
GO

insert into GXDBVersions values(2, 'DM2GetIndexServers',  '00000000000000000000', 'DM2GetIndexServers', '00000000000000000000')
GO

