

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetDelegateList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetDelegateList()
--  | Description:  Gets list of Delegates
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetDelegateList.sp,v $ $Id: DM2GetDelegateList.sp,v 1.5.54.6 2019/09/26 06:26:02 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetDelegateList')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetDelegateList <<<'
	drop procedure DM2GetDelegateList
END
IF EXISTS (select * from GxQscripts where name='DM2GetDelegateList')
	delete from GxQscripts where name = 'DM2GetDelegateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetDelegateList')
	delete from GXDBVersions where aliasname = 'DM2GetDelegateList'
GO
print '... Creating Procedure: DM2GetDelegateList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetDelegateList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userGUID NVARCHAR(MAX)
AS
SET NOCOUNT ON
BEGIN
	DECLARE @userId INT = 0
	DECLARE @TripletSep CHAR = 0x12	--Mailbox triplet seperator char
	DECLARE @EXCHANGE_CLIENTYPE INT = 25 --Declared in App.x enum ClienType
	--
	-- intermediate table to store inputs and process them
	--
	DECLARE @InputGUIDs table (
		InputGuid varchar(40) not null,
		ResourceDomainName nvarchar(1024) null,
		ADUserGUID nvarchar(512) not null,
		LoginName nvarchar(255),
		AdminDomainName nvarchar(1024),
		ProviderId INT DEFAULT 0,
		ResourceId INT DEFAULT 0,
		AppGUIDName NVARCHAR(512) NULL,
		UserId INT
	)
	IF object_id('tempdb.dbo.#tmpUserDelegateInfo') IS NOT NULL
		 DROP TABLE #tmpUserDelegateInfo
	CREATE TABLE #tmpUserDelegateInfo
	(
		mailboxUserGUID   nvarchar(40),
		mbParentGuid   nvarchar(128),
		folder nvarchar(max),
		sharedType int default 1,
		syncWebFolderName nvarchar(max) default '',
		displayPath nvarchar(max) default '',
		rights nvarchar(128) default 'FullAccess',
		mailboxDisplayName nvarchar(max),
		mailboxaliasName nvarchar(max),
		mailboxSMTP nvarchar(max)
	)
	INSERT INTO @InputGUIDs (InputGuid, ADUserGUID)
	SELECT T.Data AS InputGuid, REPLACE(REPLACE(T.Data, '{', ''), '}', '') AS ADUserGUID
	FROM dbo.SplitString(@i_userGUID, ';') T
	--try to update each separetly
	UPDATE I
	SET LoginName = U.login ,ProviderId = U.umDSproviderId, UserId = U.id
	FROM @InputGUIDs AS I INNER JOIN UMUsers U WITH (NOLOCK) ON I.ADUserGUID = U.userGuid AND U.enabled = 1
	--Fetch AdminDomainName
	UPDATE I
	SET AdminDomainName = P.domainName,
		ResourceId = P.resourceId
	FROM @InputGUIDs AS I INNER JOIN UMDSProviders P WITH (NOLOCK) ON I.ProviderId > 0  AND P.id = I.ProviderId
	UPDATE I
	SET ResourceDomainName = P.domainName
	FROM @InputGUIDs AS I INNER JOIN UMDSProviders P WITH (NOLOCK) ON I.ResourceId > 0 AND P.id = I.ResourceId
	UPDATE @InputGUIDs SET AppGUIDName = REPLACE(LoginName, AdminDomainName, ResourceDomainName)
	WHERE ResourceDomainName IS NOT NULL
	--
	-- Collect exchange GUIDs of corresponding user from resource domain
	--
	INSERT INTO @InputGUIDs (InputGuid, ADUserGUID)
	SELECT B.GUID, REPLACE(REPLACE(B.GUID, '{', ''), '}', '') AS ADUserGUID
	FROM @InputGUIDs A INNER JOIN APP_GUID B WITH (NOLOCK)
	ON A.AppGUIDName = B.name AND B.status = 4
	WHERE A.ResourceDomainName IS NOT NULL
	/*
	--
	-- capture inputs and also determine login name, admin domain, and resource domain names along with
	-- AD user guid (value without {} enclosure)
	--
	;WITH CTESplitData
	as
	(
	SELECT T.Data AS InputGuid, REPLACE(REPLACE(T.Data, '{', ''), '}', '') AS ADUserGUID
	FROM dbo.SplitString(@i_userGUID, ';') T
	)
	INSERT INTO @InputGUIDs (InputGuid, ADUserGUID, ResourceDomainName, LoginName, AdminDomainName)
	SELECT InputGuid, ADUserGUID , R.domainName , U.login, P.domainName
	FROM CTESplitData I
	LEFT JOIN UMUsers U with (nolock) ON I.ADUserGUID = U.userGuid AND u.enabled = 1
	LEFT JOIN UMDSProviders P with (nolock) ON P.id = U.umDSproviderId
	LEFT JOIN UMDSProviders R with (nolock) ON R.ID = P.resourceId AND P.resourceId > 0
	--
	-- Collect exchange GUIDs of corresponding user from resource domain
	--
	INSERT INTO @InputGUIDs (InputGuid, LoginName, ADUserGUID)
	SELECT B.GUID, REPLACE(LoginName, AdminDomainName, ResourceDomainName), REPLACE(REPLACE(B.GUID, '{', ''), '}', '')
	FROM @InputGUIDs A
	JOIN APP_GUID B WITH(NOLOCK) ON REPLACE(LoginName, AdminDomainName, ResourceDomainName) = B.name AND B.status = 4
	WHERE A.ResourceDomainName IS NOT NULL
	*/
	-- DM2GetDelegate is called for single user only
	-- userId is later used in AppGetSharedMailboxes.spb to get shared mailboxes
	SELECT TOP 1 @userId= userId FROM @InputGUIDs
--- CODE BELOW HERE IS FROM AppGetSharedMailboxes.spb STARTS -------
DECLARE @getSharedFoldersByMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="1"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
DECLARE @getShareFoldersWithMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="2"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NULL
BEGIN
	CREATE TABLE #OutputAppSharingGetSharedFolders
	(
	outputXml XML
	)
END
--Get Shared by me folders
EXEC AppSharingGetSharedFolders @getSharedFoldersByMeReqest, @userId, 0
--Get Shared with me folders
EXEC AppSharingGetSharedFolders @getShareFoldersWithMeReqest, @userId, 0
--- CODE FROM AppGetSharedMailboxes.spb ENDS----------
	-- Get rid of Shared by me, we don't need those entries here
	DELETE FROM #OutputAppSharingGetSharedFolders
		WHERE ISNULL(outputXml.value('(App_GetSharedFoldersResp/shares/@shareType)[1]','INT'), 0 ) = 1
	INSERT INTO #tmpUserDelegateInfo (mailboxUserGUID, mbParentGuid,  folder, sharedType, displayPath)
		SELECT distinct ISNULL(SC.value('(browseInfo/paths/appInfo/@mailboxGuid)[1]', 'nvarchar(40)'),''),
					ISNULL(SC.value('(browseInfo/paths/@path)[1]', 'nvarchar(max)'),''),
					ISNULL(SC.value('(shareFolder/@syncWebFolderName)[1]', 'nvarchar(max)'),''),
					ISNULL(SC.value('(@shareType)[1]', 'INT'),0),
					ISNULL(SC.value('(browseInfo/paths/@displayPath)[1]', 'nvarchar(max)'),'')
			FROM #OutputAppSharingGetSharedFolders T
			CROSS APPLY T.outputXml.nodes('App_GetSharedFoldersResp/shares') DOC(SC)
			WHERE ISNULL(SC.value('(browseInfo/@clientType)[1]', 'INT'),0) = @EXCHANGE_CLIENTYPE
	UPDATE #tmpUserDelegateInfo
	SET mailboxDisplayName = (EA.displayName), mailboxSMTP = EA.smtpAdrress, mailboxaliasName = EA.aliasName
	FROM #tmpUserDelegateInfo
	INNER JOIN App_EmailconfigPolicyAssoc(nolock) EA  ON EA.userGuid = #tmpUserDelegateInfo.mailboxUserGUID
	WHERE EA.mailboxType IN (1,2,3) AND EA.discoverByType = 1 --consider mailboxes only
	--
	-- fetch delegates from resource domain as well as admin domain
	--
	;WITH CTE AS(
		SELECT a.id FROM APP_MailBoxDelegates a with (nolock) INNER JOIN @InputGUIDs T ON T.InputGuid = A.mailboxUserGUID
	)
	--Exchange delegates
	SELECT delegateInfo.value('(/DM2ContentIndexing_MailBoxDelegateInfo)[1]/@folder', 'nvarchar(1024)') folder,
	delegateUserGuid as mailboxUserGUID,
	delegateUserName AS mailboxUserName,
	delegateInfo.value('(/DM2ContentIndexing_MailBoxDelegateInfo)[1]/@rights', 'NVARCHAR(256)') as rights
	FROM APP_MailBoxDelegates a with (nolock) INNER JOIN CTE T ON T.id = A.id
	UNION
	--Commvault share delegates
	SELECT DISTINCT CASE WHEN mailboxUserGUID = mbParentGuid THEN '\'					--Mailbox level shares
					ELSE REPLACE(displayPath, mailboxDisplayName+'\', '') END folder,	-- Folder level shares
	('{'+REPLACE(mailboxUserGUID, 'X', '-')+'}') AS mailboxUserGUID,
	(mailboxDisplayName + @TripletSep + mailboxaliasName + @TripletSep + mailboxSMTP) AS mailboxUserName ,
	 rights FROM #tmpUserDelegateInfo
	--Drop the table which was created in AppGetSharedMailboxes.spb
	IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NOT NULL
		DROP TABLE #OutputAppSharingGetSharedFolders
	IF OBJECT_ID('tempdb.dbo.#tmpUserDelegateInfo') IS NOT NULL
		DROP TABLE #tmpUserDelegateInfo
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetDelegateList')
	delete from GxQscripts where name = 'DM2GetDelegateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetDelegateList')
	delete from GXDBVersions where aliasname = 'DM2GetDelegateList'
GO

insert into GXDBVersions values(2, 'DM2GetDelegateList',  '00010005005400060000', 'DM2GetDelegateList', '00010005005400060000')
GO

