

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetContentIndexEngineByCloud.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetContentIndexEngineByCloud
--  | Description:  Return Content Indexing Engine for the given Cloud and Source Client IDs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetContentIndexEngineByCloud.sp,v $ $Id: DM2GetContentIndexEngineByCloud.sp,v 1.13.60.5 2018/06/01 21:39:20 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetContentIndexEngineByCloud <<<'

IF EXISTS (select * from sysobjects where name='DM2GetContentIndexEngineByCloud')
	drop procedure DM2GetContentIndexEngineByCloud
IF EXISTS (select * from GxQscripts where name='DM2GetContentIndexEngineByCloud')
	delete from GxQscripts where name = 'DM2GetContentIndexEngineByCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContentIndexEngineByCloud')
	delete from GXDBVersions where aliasname = 'DM2GetContentIndexEngineByCloud'
GO
print '... Creating Procedure: DM2GetContentIndexEngineByCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2GetContentIndexEngineByCloud
  @i_CommCellId integer,
  @i_CloudId integer,
  @i_SourceClientId integer,
  @i_JobId integer,
  @i_ArchGroupId integer,
  @i_StreamId integer,
  @i_MediaGroupId integer
AS
  DECLARE @o_errorCode INT = 0;
  DECLARE @o_errorString NVARCHAR(MAX) = 'Search Server Core Update Successfully';
  DECLARE @o_clientId INT = 0;
  DECLARE @o_clientName NVARCHAR(MAX) = '';
  DECLARE @o_coreId INT = 0;
  DECLARE @o_coreName NVARCHAR(MAX) = '';
SET NOCOUNT ON
	IF @i_CommCellId IS NULL OR @i_CommCellId = 0
		SET @i_CommCellId = 2
	IF @i_SourceClientId IS NULL OR @i_SourceClientId = 0
	BEGIN
SET @o_errorCode = 20114
		SET @o_errorString = 'Failed to look up Search Server Core due to invalid Client ID'
		GOTO EXIT_AND_RETURN
	END
	IF @i_CloudId IS NULL OR @i_CloudID = 0
	BEGIN
SET @o_errorCode = 20114
		SET @o_errorString = 'Failed to look up Search Server Core due to invalid Cloud ID'
		GOTO EXIT_AND_RETURN
	END
	-- MR 89391 Implement a lock for number of documents to CI per node
	-- NOT APPLICABLE FOR UPGRADED FAST SERVER
	IF @i_CloudId IN (SELECT CloudId FROM DM2SearchServerCoreInfo) --SOLR engine
AND NOT EXISTS (SELECT * FROM DM2SearchServerCoreInfo  WHERE CloudId = @i_CloudId AND (CoreRoles & 16) > 0)
	BEGIN
		DECLARE @isDocCountReached INT  =0
		DECLARE @isSpaceLimitReached INT  =0
		DECLARE @isDisabled INT  =0
		DECLARE @freeSpaceLimitToIndexSizePercent INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'FreeSpaceLimitToIndexSizePercent' AND modified =0), 50)
		DECLARE @docCountLimit INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'CINumDocumentMaxLimit' AND modified =0), 30000000)
		--search engine always belong current commcellid = 2
		if not exists (select * from DM2SearchServerCoreInfo a WITH (READUNCOMMITTED)
where   a.CommCellId = 2
						AND		a.CloudId = @i_CloudId
						AND		a.Enabled = 1
					)
				SET @isDisabled  =1
		if not exists (select * from DM2SearchServerCoreInfo a WITH (READUNCOMMITTED)
where   a.CommCellId = 2
						AND		a.CloudId = @i_CloudId
						AND 	(CollectionSize + failedItems)  < @docCountLimit
					)
				SET @isDocCountReached  =1
		if not exists (select * from DM2SearchServerCoreInfo a WITH (READUNCOMMITTED)
where	a.CommCellId = 2
						AND		a.CloudId = @i_CloudId
						AND		(FreeSpace > ((OccupiedSpace * @freeSpaceLimitToIndexSizePercent) / 100 ))
					)
				SET @isSpaceLimitReached  =1
		if @isDisabled =1 AND @isSpaceLimitReached =1 AND @isDocCountReached =1
set @o_ErrorCode = 20125
		else if @isDisabled =1 AND @isSpaceLimitReached =1
set @o_ErrorCode = 20126
		else if @isDisabled =1 AND @isDocCountReached =1
set @o_ErrorCode = 20127
		else if @isSpaceLimitReached =1 AND @isDocCountReached =1
set @o_ErrorCode = 20128
		else if @isDisabled =1
set @o_ErrorCode = 20129
		else if @isSpaceLimitReached =1
set @o_ErrorCode = 20130
		else if @isDocCountReached =1
set @o_ErrorCode = 20131
		else
SET @o_errorCode = 20114
		SET @o_errorString = 'Failed to look up Search Engine Node in Cloud ['+  (SELECT stringVal FROM APP_ComponentProp  WHERE id = @i_CloudId) +'] with Index capability'
		GOTO EXIT_AND_RETURN
	END
	DECLARE @reservedFreeSpaceConfigValue bigint
	SET @reservedFreeSpaceConfigValue = 1024
	SELECT @reservedFreeSpaceConfigValue = isnull(value, 1024)
	FROM MMConfigs WITH (NOLOCK)
	WHERE NAME = 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_ENGINE_RESERVED_FREESPACE_IN_MB'
	DECLARE @orderConfigValue int
	SET @orderConfigValue = 0
	SELECT @orderConfigValue = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE NAME = 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_PREFER_LANFREE_ENGINE'
	DECLARE @loadbalanceConfigValue int
	SET @loadbalanceConfigValue = 0
	SELECT @loadbalanceConfigValue = isnull(value, 1)
	FROM MMConfigs WITH (NOLOCK)
	WHERE NAME = 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_PREFER_LOADBALANCE'
	-- This is for restart job,
	-- If there is archfile in restart table for the given Media Group, then choose the previous CI engine.
	-- Otherwise, consider it as a stream that has not been processed yet and choose a new CI engine.
	IF @i_ArchGroupId > 0
AND	EXISTS (SELECT * FROM archContentIndexingRestart WHERE ArchGroupId = @i_ArchGroupId AND CommCellId = @i_CommCellId AND CloudId = @i_CloudId AND operationType = 1)
	BEGIN
		IF @i_MediaGroupId > 0 AND @loadbalanceConfigValue > 0
		BEGIN
			SELECT TOP 1 @o_ClientId = ciEngineClientId
			FROM
				( SELECT * FROM archContentIndexingRestart with (nolock) where archGroupId = @i_ArchGroupId) a
				INNER JOIN
				archchunkmapping b with (nolock) on a.archFileId = b.archFileId and a.commCellId = b.commCellId
				INNER JOIN
				archchunk c with (nolock) on b.archChunkId = c.id and b.commCellId = c.commCellId
				INNER JOIN
				(select * from MMVolume with (nolock) where MediaGroupId = @i_MediaGroupId) d on c.VolumeId = d.VolumeId
		END
		ELSE
		BEGIN
			SELECT	TOP 1 @o_ClientId = ciEngineClientId
			FROM	archContentIndexingRestart
			WHERE 	ArchGroupId = @i_ArchGroupId AND CommCellId = @i_CommCellId AND CloudId = @i_CloudId
		END
		IF @o_ClientId IS NOT NULL AND @o_ClientId > 0
		BEGIN
			SELECT	@o_clientName = b.net_hostname,
					@o_coreId = a.CoreId,
					@o_coreName = a.CoreName
			FROM	DM2SearchServerCoreInfo a WITH (READUNCOMMITTED), App_Client b WITH (READUNCOMMITTED)
WHERE	a.CommCellId = 2
			AND		a.ClientId = @o_ClientId
			AND		a.CloudId = @i_CloudId
			AND		a.ClientId = b.Id
AND 	(a.CoreRoles & 16 = 16)
		END
	END
	-- This is for newly started job or new stream
	IF @o_ClientId IS NULL OR @o_ClientId = 0
	BEGIN
		IF NOT EXISTS (SELECT ReservationId FROM MMResourceToJob WITH (READUNCOMMITTED) WHERE CIEngineCoreId > 0)
		BEGIN
			SELECT Top 1 @o_ClientId = a.ClientId,
						@o_clientName = b.net_hostname,
						@o_coreId = a.CoreId,
						@o_coreName = a.CoreName
			FROM	DM2SearchServerCoreInfo a WITH (READUNCOMMITTED), App_Client b WITH (READUNCOMMITTED), MMHost c WITH (READUNCOMMITTED)
WHERE	a.CommCellId = 2
			AND		a.CloudId = @i_CloudId
			AND		a.ClientId = b.Id
AND		a.CoreRoles & 16 > 0
			AND		a.SoftState > 0
			AND		a.Enabled > 0
			AND		a.ClientId = c.ClientId
			AND		c.MMHostSoftState > 0
			AND		c.MMHostEnabled > 0
			AND		a.freeSpace >= (@reservedFreeSpaceConfigValue * 1024 * 1024)
			ORDER BY CASE WHEN @orderConfigValue > 0 AND a.ClientId = @i_SourceClientId THEN 0 ELSE 1 END,
						CAST(a.CollectionSize / 10000 AS INT),
						a.freeSpace desc,
						a.OccupiedSpace
		END
		ELSE
		BEGIN
			IF @i_MediaGroupId IS NOT NULL AND @i_MediaGroupId > 0
			BEGIN
				SELECT Top 1 @o_ClientId = a.ClientId,
							@o_clientName = b.net_hostname,
							@o_coreId = a.CoreId,
							@o_coreName = a.CoreName
				FROM
				(
					SELECT	restojob.CIEngineCoreId
					FROM	MMResource res WITH (READUNCOMMITTED), MMResourceToJob restojob WITH (READUNCOMMITTED)
					WHERE	restojob.JobId_l = @i_JobId
					AND		restojob.CIEngineCoreId > 0
					AND		restojob.ReservationId = res.ReservationId
					AND		res.MediaGroupId = @i_MediaGroupId
				) core,
				DM2SearchServerCoreInfo a WITH (READUNCOMMITTED), App_Client b WITH (READUNCOMMITTED)
				WHERE
					core.CIEngineCoreId = a.CoreId
AND		a.CommCellId = 2
					AND		a.CloudId = @i_CloudId
					AND		a.ClientId = b.Id
AND		a.CoreRoles & 16 > 0
			END
			IF @o_ClientId IS NULL or @o_ClientId = 0
			BEGIN
				SELECT Top 1 @o_ClientId = a.ClientId,
							@o_clientName = b.net_hostname,
							@o_coreId = a.CoreId,
							@o_coreName = a.CoreName
				FROM	DM2SearchServerCoreInfo a WITH (READUNCOMMITTED), App_Client b WITH (READUNCOMMITTED), MMHost c WITH (READUNCOMMITTED)
WHERE	a.CommCellId = 2
				AND		a.CloudId = @i_CloudId
				AND		a.ClientId = b.Id
AND		a.CoreRoles & 16 > 0
				AND		a.SoftState > 0
				AND		a.Enabled > 0
				AND		a.ClientId = c.ClientId
				AND		c.MMHostSoftState > 0
				AND		c.MMHostEnabled > 0
				AND		a.freeSpace >= (@reservedFreeSpaceConfigValue * 1024 * 1024)
				ORDER BY CASE WHEN @loadbalanceConfigValue > 0
								THEN (SELECT count(*) FROM MMResourceToJob WITH (READUNCOMMITTED) WHERE CIEngineCoreId = a.CoreId)
								ELSE
										CASE WHEN @orderConfigValue > 0 AND a.ClientId = @i_SourceClientId THEN 0 ELSE 1 END
								END,
							CAST(a.CollectionSize / 10000 AS INT),
							a.freeSpace desc,
							a.OccupiedSpace
			END
		END
	END
	IF @o_ClientId IS NULL OR @o_ClientId = 0
	BEGIN
		-- Look up all the clients within the same cloud
		SELECT TOP 1 @o_ClientId = b.ClientId
		FROM APP_ComponentProp a WITH (READUNCOMMITTED),
			(
				SELECT Id as ComponentId, longVal as ClientId
				FROM APP_ComponentProp WITH (READUNCOMMITTED)
WHERE	componentType = 2
				AND		componentId = @i_CloudId
AND		propertyTypeId = 1008
				AND		modified =0
			) b
		WHERE	a.componentId = b.componentId
AND		a.componentType = 3
AND 	a.propertyTypeId = 1009
		AND		a.modified =0
		AND	(
			-- CDS capability for FAST engine
				( b.ClientId NOT in (select ClientId from DM2SearchServerCoreInfo WITH (READUNCOMMITTED))
AND a.longVal & 1 > 0)
			-- INDEX capability for SOLR engine
				OR		( b.ClientId in (select ClientId from DM2SearchServerCoreInfo WITH (READUNCOMMITTED) where Enabled > 0)
AND a.longVal & 16 > 0)
			)
		SELECT @o_clientName = net_hostName
		FROM	App_Client WITH (READUNCOMMITTED)
		WHERE	id = @o_ClientId
	END
	IF @o_ClientId IS NULL OR @o_ClientId = 0
	BEGIN
SET @o_errorCode = 20114
		SET @o_errorString = 'Failed to look up Search Server Cleint and Core for Content Index Cloud [' + CAST(@i_CloudId as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
	SET @o_errorString = 'Search Server Core look up Successfully with Client ID [' + CAST(@o_ClientId as varchar(10)) +
				'] Core ID [' + CAST(@o_coreId as varchar(10)) + '] for Conent Index Cloud and Client [' + CAST(@i_CloudId as varchar(10)) + '/' + CAST(@i_SourceClientId as varchar(10)) + ']'
EXIT_AND_RETURN:
	SELECT @o_errorCode, @o_errorString, @o_clientId, @o_clientName, @o_coreId, @o_coreName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetContentIndexEngineByCloud')
	delete from GxQscripts where name = 'DM2GetContentIndexEngineByCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContentIndexEngineByCloud')
	delete from GXDBVersions where aliasname = 'DM2GetContentIndexEngineByCloud'
GO

insert into GXDBVersions values(2, 'DM2GetContentIndexEngineByCloud',  '00010013006000050000', 'DM2GetContentIndexEngineByCloud', '00010013006000050000')
GO

